/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.warc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import org.archive.format.http.HttpConstants;
import org.archive.format.http.HttpHeaders;
import org.archive.format.warc.WARCConstants;
import org.archive.util.DateUtils;

public class WARCRecordWriter
implements WARCConstants,
HttpConstants {
    private static final String SCHEME = "urn:uuid";
    private static final String SCHEME_COLON = "urn:uuid:";

    private void writeRecord(OutputStream out, HttpHeaders headers, byte[] contents) throws IOException {
        if (contents == null) {
            headers.add("Content-Length", "0");
        } else {
            headers.add("Content-Length", String.valueOf(contents.length));
        }
        out.write("WARC/1.0".getBytes("UTF-8"));
        out.write(13);
        out.write(10);
        headers.write(out);
        if (contents != null) {
            out.write(contents);
        }
        out.write(13);
        out.write(10);
        out.write(13);
        out.write(10);
    }

    public void writeWARCInfoRecord(OutputStream out, String filename, byte[] contents) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("WARC-Type", WARCConstants.WARCRecordType.warcinfo.name());
        headers.add("WARC-Date", DateUtils.getLog14Date());
        headers.add("WARC-Filename", filename);
        headers.add("WARC-Record-ID", this.makeRecordId());
        headers.add("Content-Type", "application/warc-fields");
        this.writeRecord(out, headers, contents);
    }

    public void writeJSONMetadataRecord(OutputStream out, byte[] contents, String targetURI, Date originalDate, String origRecordId) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("WARC-Type", WARCConstants.WARCRecordType.metadata.name());
        if (targetURI != null) {
            headers.add("WARC-Target-URI", targetURI);
        }
        headers.add("WARC-Date", DateUtils.getLog14Date(originalDate));
        headers.add("WARC-Record-ID", this.makeRecordId());
        headers.add("WARC-Refers-To", origRecordId);
        headers.add("Content-Type", "application/json");
        this.writeRecord(out, headers, contents);
    }

    private String makeRecordId() {
        StringBuilder recID = new StringBuilder();
        recID.append("<").append(SCHEME_COLON);
        recID.append(UUID.randomUUID().toString());
        recID.append(">");
        return recID.toString();
    }
}

