/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.nutch.crawl.Generator;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLPartitioner
extends Partitioner<Text, Writable>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PARTITION_MODE_KEY = "partition.url.mode";
    public static final String PARTITION_MODE_HOST = "byHost";
    public static final String PARTITION_MODE_DOMAIN = "byDomain";
    public static final String PARTITION_MODE_IP = "byIP";
    private int seed;
    private URLNormalizers normalizers;
    private String mode = "byHost";
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.seed = conf.getInt("partition.url.seed", 0);
        this.mode = conf.get(PARTITION_MODE_KEY, PARTITION_MODE_HOST);
        if (!(this.mode.equals(PARTITION_MODE_IP) || this.mode.equals(PARTITION_MODE_DOMAIN) || this.mode.equals(PARTITION_MODE_HOST))) {
            LOG.error("Unknown partition mode : {} - forcing to byHost", (Object)this.mode);
            this.mode = PARTITION_MODE_HOST;
        }
        this.normalizers = new URLNormalizers(conf, "partition");
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int getPartition(Text key, Writable value, int numReduceTasks) {
        String urlString = key.toString();
        URL url = null;
        int hashCode = 0;
        try {
            urlString = this.normalizers.normalize(urlString, "partition");
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.warn("Malformed URL: '{}'", (Object)urlString);
        }
        if (url == null) {
            hashCode = urlString.hashCode();
        } else if (this.mode.equals(PARTITION_MODE_HOST)) {
            hashCode = url.getHost().hashCode();
        } else if (this.mode.equals(PARTITION_MODE_DOMAIN)) {
            hashCode = URLUtil.getDomainName(url).hashCode();
        } else if (this.mode.equals(PARTITION_MODE_IP)) {
            try {
                InetAddress address = InetAddress.getByName(url.getHost());
                hashCode = address.getHostAddress().hashCode();
            }
            catch (UnknownHostException e) {
                Generator.LOG.info("Couldn't find IP for host: {}", (Object)url.getHost());
            }
        }
        return ((hashCode ^= this.seed) & Integer.MAX_VALUE) % numReduceTasks;
    }
}

