/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.webgraph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.scoring.webgraph.LinkDatum;
import org.apache.nutch.scoring.webgraph.Node;
import org.apache.nutch.util.FSUtils;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDumper
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DUMP_DIR = "linkdump";

    public void dumpLinks(Path webGraphDb) throws IOException, InterruptedException, ClassNotFoundException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("NodeDumper: starting");
        Configuration conf = this.getConf();
        FileSystem fs = webGraphDb.getFileSystem(conf);
        Path linkdump = new Path(webGraphDb, DUMP_DIR);
        Path nodeDb = new Path(webGraphDb, "nodes");
        Path outlinkDb = new Path(webGraphDb, "outlinks/current");
        Path tempInverted = new Path(webGraphDb, "inverted-" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
        Job inverter = Job.getInstance((Configuration)conf, (String)("Nutch LinkDumper: invert " + String.valueOf(webGraphDb)));
        FileInputFormat.addInputPath((Job)inverter, (Path)nodeDb);
        FileInputFormat.addInputPath((Job)inverter, (Path)outlinkDb);
        inverter.setInputFormatClass(SequenceFileInputFormat.class);
        inverter.setJarByClass(Inverter.class);
        inverter.setMapperClass(Inverter.InvertMapper.class);
        inverter.setReducerClass(Inverter.InvertReducer.class);
        inverter.setMapOutputKeyClass(Text.class);
        inverter.setMapOutputValueClass(ObjectWritable.class);
        inverter.setOutputKeyClass(Text.class);
        inverter.setOutputValueClass(LinkNode.class);
        FileOutputFormat.setOutputPath((Job)inverter, (Path)tempInverted);
        inverter.setOutputFormatClass(SequenceFileOutputFormat.class);
        try {
            LOG.info("LinkDumper: running inverter");
            boolean success = inverter.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage("LinkDumper inverter", inverter);
                LOG.error(message);
                throw new RuntimeException(message);
            }
            LOG.info("LinkDumper: finished inverter");
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error("LinkDumper inverter job failed:", (Throwable)e);
            throw e;
        }
        Job merger = Job.getInstance((Configuration)conf, (String)("Nutch LinkDumper: merge " + String.valueOf(tempInverted)));
        FileInputFormat.addInputPath((Job)merger, (Path)tempInverted);
        merger.setJarByClass(Merger.class);
        merger.setInputFormatClass(SequenceFileInputFormat.class);
        merger.setReducerClass(Merger.class);
        merger.setMapOutputKeyClass(Text.class);
        merger.setMapOutputValueClass(LinkNode.class);
        merger.setOutputKeyClass(Text.class);
        merger.setOutputValueClass(LinkNodes.class);
        FileOutputFormat.setOutputPath((Job)merger, (Path)linkdump);
        merger.setOutputFormatClass(MapFileOutputFormat.class);
        try {
            LOG.info("LinkDumper: running merger");
            boolean success = merger.waitForCompletion(true);
            if (!success) {
                String message = NutchJob.getJobFailureLogMessage("LinkDumper merger", merger);
                LOG.error(message);
                throw new RuntimeException(message);
            }
            LOG.info("LinkDumper: finished merger");
        }
        catch (IOException e) {
            LOG.error("LinkDumper merger job failed:", (Throwable)e);
            throw e;
        }
        fs.delete(tempInverted, true);
        stopWatch.stop();
        LOG.info("LinkDumper: finished, elapsed: {} ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new LinkDumper(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.withDescription((String)"show this help message");
        Option helpOpts = OptionBuilder.create((String)"help");
        options.addOption(helpOpts);
        OptionBuilder.withArgName((String)"webgraphdb");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the web graph database to use");
        Option webGraphDbOpts = OptionBuilder.create((String)"webgraphdb");
        options.addOption(webGraphDbOpts);
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help") || !line.hasOption("webgraphdb")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("LinkDumper", options);
                return -1;
            }
            String webGraphDb = line.getOptionValue("webgraphdb");
            this.dumpLinks(new Path(webGraphDb));
            return 0;
        }
        catch (Exception e) {
            LOG.error("LinkDumper:", (Throwable)e);
            return -2;
        }
    }

    public static class Merger
    extends Reducer<Text, LinkNode, Text, LinkNodes> {
        private Configuration conf;
        private int maxInlinks = 50000;

        public void reduce(Text key, Iterable<LinkNode> values, Reducer.Context context) throws IOException, InterruptedException {
            ArrayList<LinkNode> nodeList = new ArrayList<LinkNode>();
            int numNodes = 0;
            for (LinkNode cur : values) {
                if (numNodes >= this.maxInlinks) break;
                nodeList.add((LinkNode)WritableUtils.clone((Writable)cur, (Configuration)this.conf));
                ++numNodes;
            }
            LinkNode[] linkNodesAr = nodeList.toArray(new LinkNode[nodeList.size()]);
            LinkNodes linkNodes = new LinkNodes(linkNodesAr);
            context.write((Object)key, (Object)linkNodes);
        }
    }

    public static class Inverter {

        public static class InvertReducer
        extends Reducer<Text, ObjectWritable, Text, LinkNode> {
            private Configuration conf;

            public void setup(Reducer.Context context) {
                this.conf = context.getConfiguration();
            }

            public void reduce(Text key, Iterable<ObjectWritable> values, Reducer.Context context) throws IOException, InterruptedException {
                String fromUrl = key.toString();
                ArrayList<LinkDatum> outlinks = new ArrayList<LinkDatum>();
                Node node = null;
                for (ObjectWritable write : values) {
                    Object obj = write.get();
                    if (obj instanceof Node) {
                        node = (Node)obj;
                        continue;
                    }
                    if (!(obj instanceof LinkDatum)) continue;
                    outlinks.add((LinkDatum)WritableUtils.clone((Writable)((LinkDatum)obj), (Configuration)this.conf));
                }
                int numOutlinks = node.getNumOutlinks();
                if (numOutlinks > 0) {
                    for (int i = 0; i < outlinks.size(); ++i) {
                        LinkDatum outlink = (LinkDatum)outlinks.get(i);
                        String toUrl = outlink.getUrl();
                        context.write((Object)new Text(toUrl), (Object)new LinkNode(fromUrl, node));
                    }
                }
            }
        }

        public static class InvertMapper
        extends Mapper<Text, Writable, Text, ObjectWritable> {
            public void map(Text key, Writable value, Mapper.Context context) throws IOException, InterruptedException {
                ObjectWritable objWrite = new ObjectWritable();
                objWrite.set((Object)value);
                context.write((Object)key, (Object)objWrite);
            }
        }
    }

    public static class LinkNodes
    implements Writable {
        private LinkNode[] links;

        public LinkNodes() {
        }

        public LinkNodes(LinkNode[] links) {
            this.links = links;
        }

        public LinkNode[] getLinks() {
            return this.links;
        }

        public void setLinks(LinkNode[] links) {
            this.links = links;
        }

        public void readFields(DataInput in) throws IOException {
            int numLinks = in.readInt();
            if (numLinks > 0) {
                this.links = new LinkNode[numLinks];
                for (int i = 0; i < numLinks; ++i) {
                    LinkNode node = new LinkNode();
                    node.readFields(in);
                    this.links[i] = node;
                }
            }
        }

        public void write(DataOutput out) throws IOException {
            if (this.links != null && this.links.length > 0) {
                int numLinks = this.links.length;
                out.writeInt(numLinks);
                for (int i = 0; i < numLinks; ++i) {
                    this.links[i].write(out);
                }
            }
        }
    }

    public static class LinkNode
    implements Writable {
        private String url = null;
        private Node node = null;

        public LinkNode() {
        }

        public LinkNode(String url, Node node) {
            this.url = url;
            this.node = node;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public void readFields(DataInput in) throws IOException {
            this.url = in.readUTF();
            this.node = new Node();
            this.node.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.url);
            this.node.write(out);
        }
    }

    public static class Reader {
        public static void main(String[] args) throws Exception {
            if (args == null || args.length < 2) {
                System.out.println("LinkDumper$Reader usage: <webgraphdb> <url>");
                return;
            }
            Configuration conf = NutchConfiguration.create();
            Path webGraphDb = new Path(args[0]);
            String url = args[1];
            MapFile.Reader[] readers = MapFileOutputFormat.getReaders((Path)new Path(webGraphDb, LinkDumper.DUMP_DIR), (Configuration)conf);
            Text key = new Text(url);
            LinkNodes nodes = new LinkNodes();
            MapFileOutputFormat.getEntry((MapFile.Reader[])readers, (Partitioner)new HashPartitioner(), (WritableComparable)key, (Writable)nodes);
            LinkNode[] linkNodesAr = nodes.getLinks();
            System.out.println(url + ":");
            for (LinkNode node : linkNodesAr) {
                System.out.println("  " + node.getUrl() + " - " + node.getNode().toString());
            }
            FSUtils.closeReaders(readers);
        }
    }
}

