/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.util.NutchConfiguration;

public class ShowProperties
extends Configured
implements Tool {
    private String format3cols = "%-32s  %24s  %20s";

    public int run(String[] arg0) {
        Configuration conf = this.getConf();
        ArrayList list = new ArrayList();
        conf.iterator().forEachRemaining(list::add);
        Collections.sort(list, (a, b) -> ((String)a.getKey()).compareTo((String)b.getKey()));
        System.out.println(String.format(this.format3cols, "conf.name", "conf.value", "substituted.value"));
        System.out.println("================================================================================");
        for (Map.Entry e : list) {
            String format;
            String substitutedVal;
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (val.equals(substitutedVal = conf.get(key))) {
                format = String.format("%%-%ds  %%%ds", key.length(), 78 - key.length());
                System.out.println(String.format(format, key, val));
                continue;
            }
            format = String.format("%%-%ds  %%%ds  %%18s", key.length(), 58 - key.length());
            System.out.println(String.format(format, key, val, substitutedVal));
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new ShowProperties(), (String[])args));
    }
}

