/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.aggregator;

import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmType;

public class EntityPropertyInfo {
    private final String name;
    private final EdmType type;
    private final EdmFacets facets;
    private final EdmCustomizableFeedMappings customMapping;
    private final String mimeType;
    private final EdmMapping mapping;

    EntityPropertyInfo(String name, EdmType type, EdmFacets facets, EdmCustomizableFeedMappings customizableFeedMapping, String mimeType, EdmMapping mapping) {
        this.name = name;
        this.type = type;
        this.facets = facets;
        this.customMapping = customizableFeedMapping;
        this.mimeType = mimeType;
        this.mapping = mapping;
    }

    static EntityPropertyInfo create(EdmProperty property) throws EdmException {
        return new EntityPropertyInfo(property.getName(), property.getType(), property.getFacets(), property.getCustomizableFeedMappings(), property.getMimeType(), property.getMapping());
    }

    public boolean isMandatory() {
        return this.facets != null && this.facets.isNullable() != null && this.facets.isNullable() == false;
    }

    public boolean isComplex() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public EdmType getType() {
        return this.type;
    }

    public EdmFacets getFacets() {
        return this.facets;
    }

    public EdmCustomizableFeedMappings getCustomMapping() {
        return this.customMapping;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public EdmMapping getMapping() {
        return this.mapping;
    }

    public String toString() {
        return this.name;
    }
}

