/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.Key;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmKeyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmPropertyView;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmProperty;

public class JPAEdmKey
extends JPAEdmBaseViewImpl
implements JPAEdmKeyView {
    private JPAEdmPropertyView propertyView;
    private JPAEdmComplexTypeView complexTypeView = null;
    private boolean isBuildModeComplexType = false;
    private Key key;

    public JPAEdmKey(JPAEdmProperty view) {
        super(view);
        this.propertyView = view;
    }

    public JPAEdmKey(JPAEdmComplexTypeView complexTypeView, JPAEdmPropertyView propertyView) {
        super((JPAEdmBaseView)complexTypeView);
        this.propertyView = propertyView;
        this.complexTypeView = complexTypeView;
        this.isBuildModeComplexType = true;
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmKeyBuider();
        }
        return this.builder;
    }

    public Key getEdmKey() {
        return this.key;
    }

    private class JPAEdmKeyBuider
    implements JPAEdmBuilder {
        private JPAEdmKeyBuider() {
        }

        public void build() throws ODataJPAModelException {
            ArrayList<PropertyRef> propertyRefList = null;
            if (JPAEdmKey.this.key == null) {
                JPAEdmKey.this.key = new Key();
            }
            if (JPAEdmKey.this.key.getKeys() == null) {
                propertyRefList = new ArrayList();
                JPAEdmKey.this.key.setKeys(propertyRefList);
            } else {
                propertyRefList = JPAEdmKey.this.key.getKeys();
            }
            if (JPAEdmKey.this.isBuildModeComplexType) {
                ComplexType complexType = JPAEdmKey.this.complexTypeView.searchEdmComplexType(JPAEdmKey.this.propertyView.getJPAAttribute().getJavaType().getName());
                this.normalizeComplexKey(complexType, propertyRefList);
            } else {
                PropertyRef propertyRef = new PropertyRef();
                propertyRef.setName(JPAEdmKey.this.propertyView.getEdmSimpleProperty().getName());
                Facets facets = (Facets)JPAEdmKey.this.propertyView.getEdmSimpleProperty().getFacets();
                if (facets == null) {
                    JPAEdmKey.this.propertyView.getEdmSimpleProperty().setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)));
                } else {
                    facets.setNullable(Boolean.valueOf(false));
                }
                propertyRefList.add(propertyRef);
            }
        }

        public void normalizeComplexKey(ComplexType complexType, List<PropertyRef> propertyRefList) {
            for (Property property : complexType.getProperties()) {
                try {
                    SimpleProperty simpleProperty = (SimpleProperty)property;
                    Facets facets = (Facets)simpleProperty.getFacets();
                    if (facets == null) {
                        simpleProperty.setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)));
                    } else {
                        facets.setNullable(Boolean.valueOf(false));
                    }
                    PropertyRef propertyRef = new PropertyRef();
                    propertyRef.setName(simpleProperty.getName());
                    propertyRefList.add(propertyRef);
                }
                catch (ClassCastException e) {
                    ComplexProperty complexProperty = (ComplexProperty)property;
                    this.normalizeComplexKey(JPAEdmKey.this.complexTypeView.searchEdmComplexType(complexProperty.getType()), propertyRefList);
                }
            }
        }
    }
}

