/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.TypeCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TypeReference
extends SpelNodeImpl {
    private final int dimensions;
    @Nullable
    private transient Class<?> type;

    public TypeReference(int startPos, int endPos, SpelNodeImpl qualifiedId) {
        this(startPos, endPos, qualifiedId, 0);
    }

    public TypeReference(int startPos, int endPos, SpelNodeImpl qualifiedId, int dims) {
        super(startPos, endPos, qualifiedId);
        this.dimensions = dims;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypeCode tc;
        String typeName = (String)this.children[0].getValueInternal(state).getValue();
        Assert.state((typeName != null ? 1 : 0) != 0, (String)"No type name");
        if (!typeName.contains(".") && Character.isLowerCase(typeName.charAt(0)) && (tc = TypeCode.valueOf(typeName.toUpperCase())) != TypeCode.OBJECT) {
            Class<?> clazz = this.makeArrayIfNecessary(tc.getType());
            this.exitTypeDescriptor = "Ljava/lang/Class";
            this.type = clazz;
            return new TypedValue(clazz);
        }
        Class<?> clazz = state.findType(typeName);
        clazz = this.makeArrayIfNecessary(clazz);
        this.exitTypeDescriptor = "Ljava/lang/Class";
        this.type = clazz;
        return new TypedValue(clazz);
    }

    private Class<?> makeArrayIfNecessary(Class<?> clazz) {
        if (this.dimensions < 1) {
            return clazz;
        }
        int[] dims = new int[this.dimensions];
        Object array = Array.newInstance(clazz, dims);
        return array.getClass();
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("T(");
        sb.append(this.getChild(0).toStringAST());
        sb.append("[]".repeat(this.dimensions));
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        Assert.state((this.type != null ? 1 : 0) != 0, (String)"No type available");
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Byte.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Character.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Double.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Float.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Integer.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Long.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
            } else if (this.type == Short.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
            }
        } else {
            mv.visitLdcInsn((Object)Type.getType(this.type));
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

