/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.portable.events.discovery.ExtensionAware;

public class BeforeBeanDiscoveryImpl
implements BeforeBeanDiscovery,
ExtensionAware {
    private BeanManagerImpl beanManager = null;
    private final WebBeansContext webBeansContext;
    private Object extension;
    private boolean started;

    public BeforeBeanDiscoveryImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
    }

    public void setStarted() {
        this.started = true;
    }

    public void addAnnotatedType(AnnotatedType<?> type) {
        if (this.started) {
            throw new IllegalStateException("Only call container eevnt methods in their lifecycle");
        }
        this.beanManager.addAdditionalAnnotatedType(this.extension, type);
    }

    public void addQualifier(Class<? extends Annotation> qualifier) {
        if (this.started) {
            throw new IllegalStateException("Only call container eevnt methods in their lifecycle");
        }
        this.beanManager.addAdditionalQualifier(qualifier);
    }

    public void addInterceptorBinding(Class<? extends Annotation> binding, Annotation ... bindingDef) {
        if (this.started) {
            throw new IllegalStateException("Only call container eevnt methods in their lifecycle");
        }
        this.webBeansContext.getInterceptorsManager().addInterceptorBindingType(binding, bindingDef);
    }

    public void addScope(Class<? extends Annotation> scope, boolean normal, boolean passivating) {
        if (this.started) {
            throw new IllegalStateException("Only call container eevnt methods in their lifecycle");
        }
        ExternalScope additionalScope = new ExternalScope(scope, normal, passivating);
        this.beanManager.addAdditionalScope(additionalScope);
    }

    public void addStereotype(Class<? extends Annotation> stereotype, Annotation ... stereotypeDef) {
        if (this.started) {
            throw new IllegalStateException("Only call container eevnt methods in their lifecycle");
        }
        this.webBeansContext.getAnnotationManager().checkStereoTypeClass(stereotype, stereotypeDef);
        StereoTypeModel model = new StereoTypeModel(this.webBeansContext, stereotype, stereotypeDef);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel(model);
    }

    public void addAnnotatedType(AnnotatedType<?> annotatedType, String id) {
        if (this.started) {
            throw new IllegalStateException("Only call container eevnt methods in their lifecycle");
        }
        this.beanManager.addAdditionalAnnotatedType(this.extension, annotatedType, id);
    }

    public void addInterceptorBinding(AnnotatedType<? extends Annotation> annotatedType) {
        if (this.started) {
            throw new IllegalStateException("Only call container eevnt methods in their lifecycle");
        }
        this.webBeansContext.getInterceptorsManager().addInterceptorBindingType(annotatedType);
    }

    public void addQualifier(AnnotatedType<? extends Annotation> annotatedType) {
        if (this.started) {
            throw new IllegalStateException("Only call container eevnt methods in their lifecycle");
        }
        this.beanManager.addAdditionalQualifier(annotatedType);
    }

    @Override
    public void setExtension(Object extension) {
        this.extension = extension;
    }
}

