/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BatchReceivePolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BatchReceivePolicy DEFAULT_POLICY = new BatchReceivePolicy(-1, 0xA00000, 100, TimeUnit.MILLISECONDS, true);
    public static final BatchReceivePolicy DEFAULT_MULTI_TOPICS_DISABLE_POLICY = new BatchReceivePolicy(-1, 0xA00000, 100, TimeUnit.MILLISECONDS, false);
    private final int maxNumMessages;
    private final int maxNumBytes;
    private final int timeout;
    private final TimeUnit timeoutUnit;
    private final boolean messagesFromMultiTopicsEnabled;

    private BatchReceivePolicy(int maxNumMessages, int maxNumBytes, int timeout, TimeUnit timeoutUnit, boolean messagesFromMultiTopicsEnabled) {
        this.maxNumMessages = maxNumMessages;
        this.maxNumBytes = maxNumBytes;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        this.messagesFromMultiTopicsEnabled = messagesFromMultiTopicsEnabled;
    }

    public void verify() {
        if (this.maxNumMessages <= 0 && this.maxNumBytes <= 0 && this.timeout <= 0) {
            throw new IllegalArgumentException("At least one of maxNumMessages, maxNumBytes, timeout must be specified.");
        }
        if (this.timeout > 0 && this.timeoutUnit == null) {
            throw new IllegalArgumentException("Must set timeout unit for timeout.");
        }
    }

    public long getTimeoutMs() {
        return this.timeout > 0 && this.timeoutUnit != null ? this.timeoutUnit.toMillis(this.timeout) : 0L;
    }

    public int getMaxNumMessages() {
        return this.maxNumMessages;
    }

    public int getMaxNumBytes() {
        return this.maxNumBytes;
    }

    public boolean isMessagesFromMultiTopicsEnabled() {
        return this.messagesFromMultiTopicsEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "BatchReceivePolicy{maxNumMessages=" + this.maxNumMessages + ", maxNumBytes=" + this.maxNumBytes + ", timeout=" + this.timeout + ", timeoutUnit=" + (Object)((Object)this.timeoutUnit) + ", messagesFromMultiTopicsEnabled=" + this.messagesFromMultiTopicsEnabled + '}';
    }

    public static class Builder {
        private int maxNumMessages;
        private int maxNumBytes;
        private int timeout;
        private TimeUnit timeoutUnit;
        private boolean messagesFromMultiTopicsEnabled = true;

        public Builder maxNumMessages(int maxNumMessages) {
            this.maxNumMessages = maxNumMessages;
            return this;
        }

        public Builder maxNumBytes(int maxNumBytes) {
            this.maxNumBytes = maxNumBytes;
            return this;
        }

        public Builder timeout(int timeout, TimeUnit timeoutUnit) {
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
            return this;
        }

        public Builder messagesFromMultiTopicsEnabled(boolean messagesFromMultiTopicsEnabled) {
            this.messagesFromMultiTopicsEnabled = messagesFromMultiTopicsEnabled;
            return this;
        }

        public BatchReceivePolicy build() {
            return new BatchReceivePolicy(this.maxNumMessages, this.maxNumBytes, this.timeout, this.timeoutUnit, this.messagesFromMultiTopicsEnabled);
        }
    }
}

