/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.comparison;

import java.util.regex.Pattern;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.AbstractComparisonExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.ConstantExpression;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;

public class LikeExpression<T, R>
extends AbstractComparisonExpression<T, Boolean> {
    private static final Pattern REPEATED_WILDCARDS = Pattern.compile("%{2,}");
    private final FunctionParameterTypePredicate<R> _typeValidator = FunctionParameterTypePredicate.builder().allowNulls().allowBooleans().allowEnums().allowDateTimeTypes().allowNumbers().allowStrings().build();

    private static <X> ExpressionNode<X, ?> toConstantExpression(String source) {
        if (source.contains("%%")) {
            source = REPEATED_WILDCARDS.matcher(source).replaceAll("%");
        }
        return new ConstantExpression(source);
    }

    public LikeExpression(ExpressionNode<T, R> left, String source, String escape) {
        super("", left, LikeExpression.toConstantExpression(source), new ConstantExpression(escape));
    }

    @Override
    public Boolean apply(T value) {
        Object arg = this.evaluateChild(0, value);
        if (arg == null) {
            return Boolean.FALSE;
        }
        if (!this._typeValidator.test(arg)) {
            throw QueryParsingException.of("Parameter of function '%s' invalid (parameter type: %s)", arg, StringUtils.getClassName(arg));
        }
        String convertedPattern = (String)this.evaluateChild(1, null);
        String convertedValue = String.valueOf(arg);
        String patternSource = (String)this.evaluateChild(2, null);
        Pattern pattern = this.sqlPatternToRegex(convertedPattern, patternSource);
        return pattern.matcher(convertedValue).matches();
    }

    private Pattern sqlPatternToRegex(String pattern, String escape) {
        if (pattern == null) {
            throw new IllegalArgumentException("Null pattern");
        }
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Empty pattern");
        }
        Character escapeChar = escape == null ? null : Character.valueOf(escape.charAt(0));
        StringBuilder buffer = new StringBuilder();
        buffer.append("^");
        for (int j = 0; j < pattern.length(); ++j) {
            char nextChar = pattern.charAt(j);
            if (escapeChar != null && escapeChar.charValue() == nextChar) {
                if (++j >= pattern.length()) break;
                char t = pattern.charAt(j);
                buffer.append("\\");
                buffer.append(t);
                continue;
            }
            if (nextChar == '%') {
                buffer.append('.').append('*');
                continue;
            }
            if (nextChar == '?') {
                buffer.append('.');
                continue;
            }
            if (nextChar == '.' || nextChar == '/' || nextChar == '$' || nextChar == '^') {
                buffer.append('\\').append(nextChar);
                continue;
            }
            buffer.append(nextChar);
        }
        buffer.append("$");
        return Pattern.compile(buffer.toString());
    }
}

