/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.BaseEntry;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class INLogEntry<T extends IN>
extends BaseEntry<T>
implements LogEntry,
INContainingEntry {
    private DatabaseId dbId;
    private T in;
    private ByteBuffer inBytes;
    private long prevFullLsn;
    private long prevDeltaLsn;

    public static <T extends IN> INLogEntry<T> create(Class<T> INClass) {
        return new INLogEntry<Class<T>>(INClass);
    }

    INLogEntry(Class<T> INClass) {
        super(INClass);
    }

    public INLogEntry(T in) {
        this(in, false);
    }

    INLogEntry(T in, boolean isBINDelta) {
        this.setLogType(isBINDelta ? LogEntryType.LOG_BIN_DELTA : ((IN)in).getLogType());
        this.dbId = ((IN)in).getDatabase().getId();
        this.in = in;
        this.inBytes = null;
        this.prevFullLsn = ((IN)in).getLastFullLsn();
        this.prevDeltaLsn = ((IN)in).getLastDeltaLsn();
    }

    public INLogEntry(ByteBuffer bytes, long lastFullLsn, long lastDeltaLsn, LogEntryType logEntryType, IN parent) {
        this.setLogType(logEntryType);
        this.dbId = parent.getDatabase().getId();
        this.in = null;
        this.inBytes = bytes;
        this.prevFullLsn = lastFullLsn;
        this.prevDeltaLsn = lastDeltaLsn;
    }

    @Override
    public boolean isBINDelta() {
        return false;
    }

    @Override
    public DatabaseId getDbId() {
        return this.dbId;
    }

    @Override
    public long getPrevFullLsn() {
        return this.prevFullLsn;
    }

    @Override
    public long getPrevDeltaLsn() {
        return this.prevDeltaLsn;
    }

    public T getMainItem() {
        assert (this.inBytes == null);
        return this.in;
    }

    @Override
    public IN getIN(DatabaseImpl dbImpl) {
        assert (this.inBytes == null);
        return this.in;
    }

    public long getNodeId() {
        assert (this.inBytes == null);
        return ((IN)this.in).getNodeId();
    }

    public boolean isPreSerialized() {
        return this.inBytes != null;
    }

    public BIN getBINWithExpiration() {
        if (this.inBytes != null) {
            BIN bin = new BIN();
            if (!bin.mayHaveExpirationValues(this.inBytes, 14)) {
                return null;
            }
            this.inBytes.mark();
            this.readMainItem(bin, this.inBytes, 14);
            this.inBytes.reset();
            return bin.hasExpirationValues() ? bin : null;
        }
        assert (((Node)this.in).isBIN());
        BIN bin = (BIN)this.in;
        return bin.hasExpirationValues() ? bin : null;
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        boolean version6OrLater;
        assert (this.inBytes == null);
        int logVersion = header.getVersion();
        boolean bl = version6OrLater = logVersion >= 6;
        if (logVersion < 2) {
            throw EnvironmentFailureException.unexpectedState("Attempt to read from log file with version " + logVersion + ", which is not supported any more");
        }
        if (version6OrLater) {
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, logVersion);
            this.prevFullLsn = LogUtils.readLong(entryBuffer, false);
            this.prevDeltaLsn = logVersion >= 8 ? LogUtils.readPackedLong(entryBuffer) : -1L;
        }
        this.in = (IN)this.newInstanceOfType();
        this.readMainItem(this.in, entryBuffer, logVersion);
        if (!version6OrLater) {
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, logVersion);
            this.prevFullLsn = LogUtils.readLong(entryBuffer, true);
            this.prevDeltaLsn = -1L;
        }
    }

    private void readMainItem(T in, ByteBuffer entryBuffer, int logVersion) {
        if (this.isBINDelta()) {
            assert (logVersion >= 9);
            ((IN)in).readFromLog(entryBuffer, logVersion, true);
            if (logVersion == 9) {
                this.prevFullLsn = LogUtils.readPackedLong(entryBuffer);
            }
            ((IN)in).setLastFullLsn(this.prevFullLsn);
        } else {
            ((IN)in).readFromLog(entryBuffer, logVersion);
        }
    }

    @Override
    public int getSize() {
        int inSize = this.inBytes != null ? this.inBytes.remaining() : ((IN)this.in).getLogSize(this.isBINDelta());
        return inSize + this.dbId.getLogSize() + LogUtils.getPackedLongLogSize(this.prevFullLsn) + LogUtils.getPackedLongLogSize(this.prevDeltaLsn);
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer) {
        this.dbId.writeToLog(destBuffer);
        LogUtils.writePackedLong(destBuffer, this.prevFullLsn);
        LogUtils.writePackedLong(destBuffer, this.prevDeltaLsn);
        if (this.inBytes != null) {
            int pos = this.inBytes.position();
            destBuffer.put(this.inBytes);
            this.inBytes.position(pos);
        } else {
            ((IN)this.in).writeToLog(destBuffer, this.isBINDelta());
        }
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        return false;
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        this.dbId.dumpLog(sb, verbose);
        if (this.inBytes != null) {
            sb.append("<INBytes len=\"");
            sb.append(this.inBytes.remaining());
            sb.append("\"/>");
        } else {
            ((IN)this.in).dumpLog(sb, verbose);
        }
        if (this.prevFullLsn != -1L) {
            sb.append("<prevFullLsn>");
            sb.append(DbLsn.getNoFormatString(this.prevFullLsn));
            sb.append("</prevFullLsn>");
        }
        if (this.prevDeltaLsn != -1L) {
            sb.append("<prevDeltaLsn>");
            sb.append(DbLsn.getNoFormatString(this.prevDeltaLsn));
            sb.append("</prevDeltaLsn>");
        }
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
    }
}

