/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.stats;

import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.MessageStore;

public class BrokerStats {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private final MessageStore defaultMessageStore;
    private volatile long msgPutTotalYesterdayMorning;
    private volatile long msgPutTotalTodayMorning;
    private volatile long msgGetTotalYesterdayMorning;
    private volatile long msgGetTotalTodayMorning;

    public BrokerStats(MessageStore defaultMessageStore) {
        this.defaultMessageStore = defaultMessageStore;
    }

    public void record() {
        this.msgPutTotalYesterdayMorning = this.msgPutTotalTodayMorning;
        this.msgGetTotalYesterdayMorning = this.msgGetTotalTodayMorning;
        this.msgPutTotalTodayMorning = this.defaultMessageStore.getStoreStatsService().getPutMessageTimesTotal();
        this.msgGetTotalTodayMorning = this.defaultMessageStore.getStoreStatsService().getGetMessageTransferredMsgCount().longValue();
        log.info("yesterday put message total: {}", (Object)(this.msgPutTotalTodayMorning - this.msgPutTotalYesterdayMorning));
        log.info("yesterday get message total: {}", (Object)(this.msgGetTotalTodayMorning - this.msgGetTotalYesterdayMorning));
    }

    public long getMsgPutTotalYesterdayMorning() {
        return this.msgPutTotalYesterdayMorning;
    }

    public void setMsgPutTotalYesterdayMorning(long msgPutTotalYesterdayMorning) {
        this.msgPutTotalYesterdayMorning = msgPutTotalYesterdayMorning;
    }

    public long getMsgPutTotalTodayMorning() {
        return this.msgPutTotalTodayMorning;
    }

    public void setMsgPutTotalTodayMorning(long msgPutTotalTodayMorning) {
        this.msgPutTotalTodayMorning = msgPutTotalTodayMorning;
    }

    public long getMsgGetTotalYesterdayMorning() {
        return this.msgGetTotalYesterdayMorning;
    }

    public void setMsgGetTotalYesterdayMorning(long msgGetTotalYesterdayMorning) {
        this.msgGetTotalYesterdayMorning = msgGetTotalYesterdayMorning;
    }

    public long getMsgGetTotalTodayMorning() {
        return this.msgGetTotalTodayMorning;
    }

    public void setMsgGetTotalTodayMorning(long msgGetTotalTodayMorning) {
        this.msgGetTotalTodayMorning = msgGetTotalTodayMorning;
    }

    public long getMsgPutTotalTodayNow() {
        return this.defaultMessageStore.getStoreStatsService().getPutMessageTimesTotal();
    }

    public long getMsgGetTotalTodayNow() {
        return this.defaultMessageStore.getStoreStatsService().getGetMessageTransferredMsgCount().longValue();
    }
}

