/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.common;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.rocketmq.proxy.common.Shutdown;
import org.apache.rocketmq.proxy.common.Start;
import org.apache.rocketmq.proxy.common.StartAndShutdown;

public abstract class AbstractStartAndShutdown
implements StartAndShutdown {
    protected List<StartAndShutdown> startAndShutdownList = new CopyOnWriteArrayList<StartAndShutdown>();

    protected void appendStartAndShutdown(StartAndShutdown startAndShutdown) {
        this.startAndShutdownList.add(startAndShutdown);
    }

    @Override
    public void start() throws Exception {
        for (StartAndShutdown startAndShutdown : this.startAndShutdownList) {
            startAndShutdown.start();
        }
    }

    @Override
    public void shutdown() throws Exception {
        for (int index = this.startAndShutdownList.size() - 1; index >= 0; --index) {
            this.startAndShutdownList.get(index).shutdown();
        }
    }

    public void appendStart(final Start start) {
        this.appendStartAndShutdown(new StartAndShutdown(){

            @Override
            public void shutdown() throws Exception {
            }

            @Override
            public void start() throws Exception {
                start.start();
            }
        });
    }

    public void appendShutdown(final Shutdown shutdown) {
        this.appendStartAndShutdown(new StartAndShutdown(){

            @Override
            public void shutdown() throws Exception {
                shutdown.shutdown();
            }

            @Override
            public void start() throws Exception {
            }
        });
    }
}

