/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.processor;

import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.proxy.common.AbstractStartAndShutdown;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.service.ServiceManager;

public abstract class AbstractProcessor
extends AbstractStartAndShutdown {
    protected MessagingProcessor messagingProcessor;
    protected ServiceManager serviceManager;

    public AbstractProcessor(MessagingProcessor messagingProcessor, ServiceManager serviceManager) {
        this.messagingProcessor = messagingProcessor;
        this.serviceManager = serviceManager;
    }

    protected void validateReceiptHandle(ReceiptHandle handle) {
        if (handle.isExpired()) {
            throw new ProxyException(ProxyExceptionCode.INVALID_RECEIPT_HANDLE, "receipt handle is expired");
        }
    }

    protected TopicMessageType parseFromMessageExt(Message message) {
        String isTransValue = "true";
        String isTrans = message.getProperty("TRAN_MSG");
        if (isTransValue.equals(isTrans)) {
            return TopicMessageType.TRANSACTION;
        }
        if (message.getProperty("DELAY") != null || message.getProperty("TIMER_DELIVER_MS") != null || message.getProperty("TIMER_DELAY_SEC") != null) {
            return TopicMessageType.DELAY;
        }
        if (message.getProperty("__SHARDINGKEY") != null) {
            return TopicMessageType.FIFO;
        }
        return TopicMessageType.NORMAL;
    }
}

