/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.cluster;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.body.KVTable;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class ClusterListSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "clusterList";
    }

    @Override
    public String commandDesc() {
        return "List cluster infos";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("m", "moreStats", false, "Print more stats");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("i", "interval", true, "specify intervals numbers, it is in seconds");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("c", "clusterName", true, "which cluster");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        long printInterval = 1L;
        boolean enableInterval = commandLine.hasOption('i');
        if (enableInterval) {
            printInterval = Long.parseLong(commandLine.getOptionValue('i')) * 1000L;
        }
        String clusterName = commandLine.hasOption('c') ? commandLine.getOptionValue('c').trim() : "";
        try {
            defaultMQAdminExt.start();
            long i = 0L;
            do {
                if (i++ > 0L) {
                    Thread.sleep(printInterval);
                }
                ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
                Set<String> clusterNames = this.getTargetClusterNames(clusterName, clusterInfo);
                if (commandLine.hasOption('m')) {
                    this.printClusterMoreStats(clusterNames, defaultMQAdminExt, clusterInfo);
                    continue;
                }
                this.printClusterBaseInfo(clusterNames, defaultMQAdminExt, clusterInfo);
            } while (enableInterval);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    private Set<String> getTargetClusterNames(String clusterName, ClusterInfo clusterInfo) {
        if (StringUtils.isEmpty((CharSequence)clusterName)) {
            return clusterInfo.getClusterAddrTable().keySet();
        }
        TreeSet<String> clusterNames = new TreeSet<String>();
        clusterNames.add(clusterName);
        return clusterNames;
    }

    private void printClusterMoreStats(Set<String> clusterNames, DefaultMQAdminExt defaultMQAdminExt, ClusterInfo clusterInfo) {
        System.out.printf("%-16s  %-32s %14s %14s %14s %14s%n", "#Cluster Name", "#Broker Name", "#InTotalYest", "#OutTotalYest", "#InTotalToday", "#OutTotalToday");
        for (String clusterName : clusterNames) {
            TreeSet brokerNameTreeSet = new TreeSet();
            Set brokerNameSet = (Set)clusterInfo.getClusterAddrTable().get(clusterName);
            if (brokerNameSet != null && !brokerNameSet.isEmpty()) {
                brokerNameTreeSet.addAll(brokerNameSet);
            }
            for (String brokerName : brokerNameTreeSet) {
                BrokerData brokerData = (BrokerData)clusterInfo.getBrokerAddrTable().get(brokerName);
                if (brokerData == null) continue;
                for (Map.Entry next1 : brokerData.getBrokerAddrs().entrySet()) {
                    long inTotalYest = 0L;
                    long outTotalYest = 0L;
                    long inTotalToday = 0L;
                    long outTotalToday = 0L;
                    try {
                        KVTable kvTable = defaultMQAdminExt.fetchBrokerRuntimeStats((String)next1.getValue());
                        String msgPutTotalYesterdayMorning = (String)kvTable.getTable().get("msgPutTotalYesterdayMorning");
                        String msgPutTotalTodayMorning = (String)kvTable.getTable().get("msgPutTotalTodayMorning");
                        String msgPutTotalTodayNow = (String)kvTable.getTable().get("msgPutTotalTodayNow");
                        String msgGetTotalYesterdayMorning = (String)kvTable.getTable().get("msgGetTotalYesterdayMorning");
                        String msgGetTotalTodayMorning = (String)kvTable.getTable().get("msgGetTotalTodayMorning");
                        String msgGetTotalTodayNow = (String)kvTable.getTable().get("msgGetTotalTodayNow");
                        inTotalYest = Long.parseLong(msgPutTotalTodayMorning) - Long.parseLong(msgPutTotalYesterdayMorning);
                        outTotalYest = Long.parseLong(msgGetTotalTodayMorning) - Long.parseLong(msgGetTotalYesterdayMorning);
                        inTotalToday = Long.parseLong(msgPutTotalTodayNow) - Long.parseLong(msgPutTotalTodayMorning);
                        outTotalToday = Long.parseLong(msgGetTotalTodayNow) - Long.parseLong(msgGetTotalTodayMorning);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.printf("%-16s  %-32s %14d %14d %14d %14d%n", clusterName, brokerName, inTotalYest, outTotalYest, inTotalToday, outTotalToday);
                }
            }
        }
    }

    private void printClusterBaseInfo(Set<String> clusterNames, DefaultMQAdminExt defaultMQAdminExt, ClusterInfo clusterInfo) {
        System.out.printf("%-22s  %-22s  %-4s  %-22s %-16s  %16s  %16s  %-22s  %-11s  %-12s  %-8s  %-10s%n", "#Cluster Name", "#Broker Name", "#BID", "#Addr", "#Version", "#InTPS(LOAD)", "#OutTPS(LOAD)", "#Timer(Progress)", "#PCWait(ms)", "#Hour", "#SPACE", "#ACTIVATED");
        for (String clusterName : clusterNames) {
            TreeSet brokerNameTreeSet = new TreeSet();
            Set brokerNameSet = (Set)clusterInfo.getClusterAddrTable().get(clusterName);
            if (brokerNameSet != null && !brokerNameSet.isEmpty()) {
                brokerNameTreeSet.addAll(brokerNameSet);
            }
            for (String brokerName : brokerNameTreeSet) {
                BrokerData brokerData = (BrokerData)clusterInfo.getBrokerAddrTable().get(brokerName);
                if (brokerData == null) continue;
                for (Map.Entry next1 : brokerData.getBrokerAddrs().entrySet()) {
                    double in = 0.0;
                    double out = 0.0;
                    String version = "";
                    String sendThreadPoolQueueSize = "";
                    String pullThreadPoolQueueSize = "";
                    String sendThreadPoolQueueHeadWaitTimeMills = "";
                    String pullThreadPoolQueueHeadWaitTimeMills = "";
                    String pageCacheLockTimeMills = "";
                    String earliestMessageTimeStamp = "";
                    String commitLogDiskRatio = "";
                    long timerReadBehind = 0L;
                    long timerOffsetBehind = 0L;
                    long timerCongestNum = 0L;
                    float timerEnqueueTps = 0.0f;
                    float timerDequeueTps = 0.0f;
                    boolean isBrokerActive = false;
                    try {
                        String[] tpss;
                        KVTable kvTable = defaultMQAdminExt.fetchBrokerRuntimeStats((String)next1.getValue());
                        isBrokerActive = Boolean.parseBoolean((String)kvTable.getTable().get("brokerActive"));
                        String putTps = (String)kvTable.getTable().get("putTps");
                        String getTransferredTps = (String)kvTable.getTable().get("getTransferredTps");
                        sendThreadPoolQueueSize = (String)kvTable.getTable().get("sendThreadPoolQueueSize");
                        pullThreadPoolQueueSize = (String)kvTable.getTable().get("pullThreadPoolQueueSize");
                        sendThreadPoolQueueSize = (String)kvTable.getTable().get("sendThreadPoolQueueSize");
                        pullThreadPoolQueueSize = (String)kvTable.getTable().get("pullThreadPoolQueueSize");
                        sendThreadPoolQueueHeadWaitTimeMills = (String)kvTable.getTable().get("sendThreadPoolQueueHeadWaitTimeMills");
                        pullThreadPoolQueueHeadWaitTimeMills = (String)kvTable.getTable().get("pullThreadPoolQueueHeadWaitTimeMills");
                        pageCacheLockTimeMills = (String)kvTable.getTable().get("pageCacheLockTimeMills");
                        earliestMessageTimeStamp = (String)kvTable.getTable().get("earliestMessageTimeStamp");
                        commitLogDiskRatio = (String)kvTable.getTable().get("commitLogDiskRatio");
                        try {
                            timerReadBehind = Long.parseLong((String)kvTable.getTable().get("timerReadBehind"));
                            timerOffsetBehind = Long.parseLong((String)kvTable.getTable().get("timerOffsetBehind"));
                            timerCongestNum = Long.parseLong((String)kvTable.getTable().get("timerCongestNum"));
                            timerEnqueueTps = Float.parseFloat((String)kvTable.getTable().get("timerEnqueueTps"));
                            timerDequeueTps = Float.parseFloat((String)kvTable.getTable().get("timerDequeueTps"));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        version = (String)kvTable.getTable().get("brokerVersionDesc");
                        if (StringUtils.isNotBlank((CharSequence)putTps) && (tpss = putTps.split(" ")).length > 0) {
                            in = Double.parseDouble(tpss[0]);
                        }
                        if (StringUtils.isNotBlank((CharSequence)getTransferredTps) && (tpss = getTransferredTps.split(" ")).length > 0) {
                            out = Double.parseDouble(tpss[0]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    double hour = 0.0;
                    double space = 0.0;
                    if (earliestMessageTimeStamp != null && earliestMessageTimeStamp.length() > 0) {
                        long mills = System.currentTimeMillis() - Long.parseLong(earliestMessageTimeStamp);
                        hour = (double)mills / 1000.0 / 60.0 / 60.0;
                    }
                    if (commitLogDiskRatio != null && commitLogDiskRatio.length() > 0) {
                        space = Double.parseDouble(commitLogDiskRatio);
                    }
                    System.out.printf("%-22s  %-22s  %-4s  %-22s %-16s  %16s  %16s  %-22s  %11s  %-12s  %-8s  %10s%n", clusterName, brokerName, next1.getKey(), next1.getValue(), version, String.format("%9.2f(%s,%sms)", in, sendThreadPoolQueueSize, sendThreadPoolQueueHeadWaitTimeMills), String.format("%9.2f(%s,%sms)", out, pullThreadPoolQueueSize, pullThreadPoolQueueHeadWaitTimeMills), String.format("%d-%d(%.1fw, %.1f, %.1f)", timerReadBehind, timerOffsetBehind, Float.valueOf((float)timerCongestNum / 10000.0f), Float.valueOf(timerEnqueueTps), Float.valueOf(timerDequeueTps)), pageCacheLockTimeMills, String.format("%2.2f", hour), String.format("%.4f", space), isBrokerActive);
                }
            }
        }
    }
}

