/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.autoswitch;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.EpochEntry;
import org.apache.rocketmq.remoting.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.ha.DefaultHAService;
import org.apache.rocketmq.store.ha.GroupTransferService;
import org.apache.rocketmq.store.ha.HAClient;
import org.apache.rocketmq.store.ha.HAConnection;
import org.apache.rocketmq.store.ha.HAConnectionStateNotificationService;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAClient;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAConnection;
import org.apache.rocketmq.store.ha.autoswitch.EpochFileCache;

public class AutoSwitchHAService
extends DefaultHAService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqStore");
    private final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryImpl("AutoSwitchHAService_Executor_"));
    private final ConcurrentHashMap<Long, Long> connectionCaughtUpTimeTable = new ConcurrentHashMap();
    private final List<Consumer<Set<Long>>> syncStateSetChangedListeners = new ArrayList<Consumer<Set<Long>>>();
    private final Set<Long> syncStateSet = new HashSet<Long>();
    private final Set<Long> remoteSyncStateSet = new HashSet<Long>();
    private final ReadWriteLock syncStateSetReadWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.syncStateSetReadWriteLock.readLock();
    private final Lock writeLock = this.syncStateSetReadWriteLock.writeLock();
    private volatile boolean isSynchronizingSyncStateSet = false;
    private EpochFileCache epochCache;
    private AutoSwitchHAClient haClient;
    private Long brokerControllerId = null;

    @Override
    public void init(DefaultMessageStore defaultMessageStore) throws IOException {
        this.epochCache = new EpochFileCache(defaultMessageStore.getMessageStoreConfig().getStorePathEpochFile());
        this.epochCache.initCacheFromFile();
        this.defaultMessageStore = defaultMessageStore;
        this.acceptSocketService = new AutoSwitchAcceptSocketService(defaultMessageStore.getMessageStoreConfig());
        this.groupTransferService = new GroupTransferService(this, defaultMessageStore);
        this.haConnectionStateNotificationService = new HAConnectionStateNotificationService(this, defaultMessageStore);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.haClient != null) {
            this.haClient.shutdown();
        }
        this.executorService.shutdown();
    }

    @Override
    public void removeConnection(HAConnection conn) {
        Long slave;
        Set<Long> syncStateSet;
        if (!this.defaultMessageStore.isShutdown() && (syncStateSet = this.getLocalSyncStateSet()).contains(slave = Long.valueOf(((AutoSwitchHAConnection)conn).getSlaveId()))) {
            syncStateSet.remove(slave);
            this.markSynchronizingSyncStateSet(syncStateSet);
            this.notifySyncStateSetChanged(syncStateSet);
        }
        super.removeConnection(conn);
    }

    @Override
    public boolean changeToMaster(int masterEpoch) {
        int lastEpoch = this.epochCache.lastEpoch();
        if (masterEpoch < lastEpoch) {
            LOGGER.warn("newMasterEpoch {} < lastEpoch {}, fail to change to master", (Object)masterEpoch, (Object)lastEpoch);
            return false;
        }
        this.destroyConnections();
        if (this.haClient != null) {
            this.haClient.shutdown();
        }
        long truncateOffset = this.truncateInvalidMsg();
        this.defaultMessageStore.setConfirmOffset(this.computeConfirmOffset());
        if (truncateOffset >= 0L) {
            this.epochCache.truncateSuffixByOffset(truncateOffset);
        }
        EpochEntry newEpochEntry = new EpochEntry(masterEpoch, this.defaultMessageStore.getMaxPhyOffset());
        if (this.epochCache.lastEpoch() >= masterEpoch) {
            this.epochCache.truncateSuffixByEpoch(masterEpoch);
        }
        this.epochCache.appendEntry(newEpochEntry);
        while (this.defaultMessageStore.dispatchBehindBytes() > 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (this.defaultMessageStore.isTransientStorePoolEnable()) {
            this.waitingForAllCommit();
            this.defaultMessageStore.getTransientStorePool().setRealCommit(true);
        }
        LOGGER.info("TruncateOffset is {}, confirmOffset is {}, maxPhyOffset is {}", new Object[]{truncateOffset, this.defaultMessageStore.getConfirmOffset(), this.defaultMessageStore.getMaxPhyOffset()});
        this.defaultMessageStore.recoverTopicQueueTable();
        this.defaultMessageStore.setStateMachineVersion(masterEpoch);
        LOGGER.info("Change ha to master success, newMasterEpoch:{}, startOffset:{}", (Object)masterEpoch, (Object)newEpochEntry.getStartOffset());
        return true;
    }

    @Override
    public boolean changeToSlave(String newMasterAddr, int newMasterEpoch, Long slaveId) {
        int lastEpoch = this.epochCache.lastEpoch();
        if (newMasterEpoch < lastEpoch) {
            LOGGER.warn("newMasterEpoch {} < lastEpoch {}, fail to change to slave", (Object)newMasterEpoch, (Object)lastEpoch);
            return false;
        }
        try {
            this.destroyConnections();
            if (this.haClient == null) {
                this.haClient = new AutoSwitchHAClient(this, this.defaultMessageStore, this.epochCache, slaveId);
            } else {
                this.haClient.reOpen();
            }
            this.haClient.updateMasterAddress(newMasterAddr);
            this.haClient.updateHaMasterAddress(null);
            this.haClient.start();
            if (this.defaultMessageStore.isTransientStorePoolEnable()) {
                this.waitingForAllCommit();
                this.defaultMessageStore.getTransientStorePool().setRealCommit(false);
            }
            this.defaultMessageStore.setStateMachineVersion(newMasterEpoch);
            LOGGER.info("Change ha to slave success, newMasterAddress:{}, newMasterEpoch:{}", (Object)newMasterAddr, (Object)newMasterEpoch);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error happen when change ha to slave", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean changeToMasterWhenLastRoleIsMaster(int masterEpoch) {
        int lastEpoch = this.epochCache.lastEpoch();
        if (masterEpoch < lastEpoch) {
            LOGGER.warn("newMasterEpoch {} < lastEpoch {}, fail to change to master", (Object)masterEpoch, (Object)lastEpoch);
            return false;
        }
        EpochEntry newEpochEntry = new EpochEntry(masterEpoch, this.defaultMessageStore.getMaxPhyOffset());
        if (this.epochCache.lastEpoch() >= masterEpoch) {
            this.epochCache.truncateSuffixByEpoch(masterEpoch);
        }
        this.epochCache.appendEntry(newEpochEntry);
        this.defaultMessageStore.setStateMachineVersion(masterEpoch);
        LOGGER.info("Change ha to master success, last role is master, newMasterEpoch:{}, startOffset:{}", (Object)masterEpoch, (Object)newEpochEntry.getStartOffset());
        return true;
    }

    @Override
    public boolean changeToSlaveWhenMasterNotChange(String newMasterAddr, int newMasterEpoch) {
        int lastEpoch = this.epochCache.lastEpoch();
        if (newMasterEpoch < lastEpoch) {
            LOGGER.warn("newMasterEpoch {} < lastEpoch {}, fail to change to slave", (Object)newMasterEpoch, (Object)lastEpoch);
            return false;
        }
        this.defaultMessageStore.setStateMachineVersion(newMasterEpoch);
        LOGGER.info("Change ha to slave success, master doesn't change, newMasterAddress:{}, newMasterEpoch:{}", (Object)newMasterAddr, (Object)newMasterEpoch);
        return true;
    }

    public void waitingForAllCommit() {
        while (this.getDefaultMessageStore().remainHowManyDataToCommit() > 0L) {
            this.getDefaultMessageStore().getCommitLog().getFlushManager().wakeUpCommit();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public HAClient getHAClient() {
        return this.haClient;
    }

    @Override
    public void updateHaMasterAddress(String newAddr) {
        if (this.haClient != null) {
            this.haClient.updateHaMasterAddress(newAddr);
        }
    }

    @Override
    public void updateMasterAddress(String newAddr) {
    }

    public void registerSyncStateSetChangedListener(Consumer<Set<Long>> listener) {
        this.syncStateSetChangedListeners.add(listener);
    }

    public void notifySyncStateSetChanged(Set<Long> newSyncStateSet) {
        this.executorService.submit(() -> this.syncStateSetChangedListeners.forEach(listener -> listener.accept(newSyncStateSet)));
        LOGGER.info("Notify the syncStateSet has been changed into {}.", newSyncStateSet);
    }

    public Set<Long> maybeShrinkSyncStateSet() {
        Set<Long> newSyncStateSet = this.getLocalSyncStateSet();
        boolean isSyncStateSetChanged = false;
        long haMaxTimeSlaveNotCatchup = this.defaultMessageStore.getMessageStoreConfig().getHaMaxTimeSlaveNotCatchup();
        for (Map.Entry<Long, Long> next : this.connectionCaughtUpTimeTable.entrySet()) {
            Long slaveBrokerId = next.getKey();
            if (!newSyncStateSet.contains(slaveBrokerId)) continue;
            Long lastCaughtUpTimeMs = next.getValue();
            if (System.currentTimeMillis() - lastCaughtUpTimeMs <= haMaxTimeSlaveNotCatchup) continue;
            newSyncStateSet.remove(slaveBrokerId);
            isSyncStateSetChanged = true;
        }
        for (Long slaveBrokerId : newSyncStateSet) {
            if (this.connectionCaughtUpTimeTable.containsKey(slaveBrokerId)) continue;
            newSyncStateSet.remove(slaveBrokerId);
            isSyncStateSetChanged = true;
        }
        if (isSyncStateSetChanged) {
            this.markSynchronizingSyncStateSet(newSyncStateSet);
        }
        return newSyncStateSet;
    }

    public void maybeExpandInSyncStateSet(Long slaveBrokerId, long slaveMaxOffset) {
        EpochEntry currentLeaderEpoch;
        Set<Long> currentSyncStateSet = this.getLocalSyncStateSet();
        if (currentSyncStateSet.contains(slaveBrokerId)) {
            return;
        }
        long confirmOffset = this.defaultMessageStore.getConfirmOffset();
        if (slaveMaxOffset >= confirmOffset && slaveMaxOffset >= (currentLeaderEpoch = this.epochCache.lastEntry()).getStartOffset()) {
            LOGGER.info("The slave {} has caught up, slaveMaxOffset: {}, confirmOffset: {}, epoch: {}, leader epoch startOffset: {}.", new Object[]{slaveBrokerId, slaveMaxOffset, confirmOffset, currentLeaderEpoch.getEpoch(), currentLeaderEpoch.getStartOffset()});
            currentSyncStateSet.add(slaveBrokerId);
            this.markSynchronizingSyncStateSet(currentSyncStateSet);
            this.notifySyncStateSetChanged(currentSyncStateSet);
        }
    }

    private void markSynchronizingSyncStateSet(Set<Long> newSyncStateSet) {
        this.writeLock.lock();
        try {
            this.isSynchronizingSyncStateSet = true;
            this.remoteSyncStateSet.clear();
            this.remoteSyncStateSet.addAll(newSyncStateSet);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void markSynchronizingSyncStateSetDone() {
        this.isSynchronizingSyncStateSet = false;
    }

    public boolean isSynchronizingSyncStateSet() {
        return this.isSynchronizingSyncStateSet;
    }

    public void updateConnectionLastCaughtUpTime(Long slaveBrokerId, long lastCaughtUpTimeMs) {
        Long prevTime = (Long)ConcurrentHashMapUtils.computeIfAbsent(this.connectionCaughtUpTimeTable, (Object)slaveBrokerId, k -> 0L);
        this.connectionCaughtUpTimeTable.put(slaveBrokerId, Math.max(prevTime, lastCaughtUpTimeMs));
    }

    public void updateConfirmOffsetWhenSlaveAck(Long slaveBrokerId) {
        this.readLock.lock();
        try {
            if (this.syncStateSet.contains(slaveBrokerId)) {
                this.defaultMessageStore.setConfirmOffset(this.computeConfirmOffset());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int inSyncReplicasNums(long masterPutWhere) {
        this.readLock.lock();
        try {
            if (this.isSynchronizingSyncStateSet) {
                int n = Math.max(this.syncStateSet.size(), this.remoteSyncStateSet.size());
                return n;
            }
            int n = this.syncStateSet.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public HARuntimeInfo getRuntimeInfo(long masterPutWhere) {
        HARuntimeInfo info = new HARuntimeInfo();
        if (BrokerRole.SLAVE.equals((Object)this.getDefaultMessageStore().getMessageStoreConfig().getBrokerRole())) {
            info.setMaster(false);
            info.getHaClientRuntimeInfo().setMasterAddr(this.haClient.getHaMasterAddress());
            info.getHaClientRuntimeInfo().setMaxOffset(this.getDefaultMessageStore().getMaxPhyOffset());
            info.getHaClientRuntimeInfo().setLastReadTimestamp(this.haClient.getLastReadTimestamp());
            info.getHaClientRuntimeInfo().setLastWriteTimestamp(this.haClient.getLastWriteTimestamp());
            info.getHaClientRuntimeInfo().setTransferredByteInSecond(this.haClient.getTransferredByteInSecond());
            info.getHaClientRuntimeInfo().setMasterFlushOffset(this.defaultMessageStore.getMasterFlushedOffset());
        } else {
            info.setMaster(true);
            info.setMasterCommitLogMaxOffset(masterPutWhere);
            Set<Long> localSyncStateSet = this.getLocalSyncStateSet();
            for (HAConnection conn : this.connectionList) {
                HARuntimeInfo.HAConnectionRuntimeInfo cInfo = new HARuntimeInfo.HAConnectionRuntimeInfo();
                long slaveAckOffset = conn.getSlaveAckOffset();
                cInfo.setSlaveAckOffset(slaveAckOffset);
                cInfo.setDiff(masterPutWhere - slaveAckOffset);
                cInfo.setAddr(conn.getClientAddress().substring(1));
                cInfo.setTransferredByteInSecond(conn.getTransferredByteInSecond());
                cInfo.setTransferFromWhere(conn.getTransferFromWhere());
                cInfo.setInSync(localSyncStateSet.contains(((AutoSwitchHAConnection)conn).getSlaveId()));
                info.getHaConnectionInfo().add(cInfo);
            }
            info.setInSyncSlaveNums(localSyncStateSet.size() - 1);
        }
        return info;
    }

    public long computeConfirmOffset() {
        Set<Long> currentSyncStateSet = this.getSyncStateSet();
        long newConfirmOffset = this.defaultMessageStore.getMaxPhyOffset();
        List idList = this.connectionList.stream().map(connection -> ((AutoSwitchHAConnection)connection).getSlaveId()).collect(Collectors.toList());
        for (Long syncId : currentSyncStateSet) {
            if (idList.contains(syncId) || this.brokerControllerId == null || Objects.equals(syncId, this.brokerControllerId)) continue;
            LOGGER.warn("Slave {} is still in syncStateSet, but has lost its connection. So new offset can't be compute.", (Object)syncId);
            return this.defaultMessageStore.getConfirmOffsetDirectly();
        }
        for (HAConnection connection2 : this.connectionList) {
            Long slaveId = ((AutoSwitchHAConnection)connection2).getSlaveId();
            if (!currentSyncStateSet.contains(slaveId) || connection2.getSlaveAckOffset() <= 0L) continue;
            newConfirmOffset = Math.min(newConfirmOffset, connection2.getSlaveAckOffset());
        }
        return newConfirmOffset;
    }

    public void setSyncStateSet(Set<Long> syncStateSet) {
        this.writeLock.lock();
        try {
            this.markSynchronizingSyncStateSetDone();
            this.syncStateSet.clear();
            this.syncStateSet.addAll(syncStateSet);
            this.defaultMessageStore.setConfirmOffset(this.computeConfirmOffset());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Long> getSyncStateSet() {
        this.readLock.lock();
        try {
            if (this.isSynchronizingSyncStateSet) {
                HashSet<Long> unionSyncStateSet = new HashSet<Long>(this.syncStateSet.size() + this.remoteSyncStateSet.size());
                unionSyncStateSet.addAll(this.syncStateSet);
                unionSyncStateSet.addAll(this.remoteSyncStateSet);
                HashSet<Long> hashSet = unionSyncStateSet;
                return hashSet;
            }
            HashSet<Long> syncStateSet = new HashSet<Long>(this.syncStateSet.size());
            syncStateSet.addAll(this.syncStateSet);
            HashSet<Long> hashSet = syncStateSet;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Long> getLocalSyncStateSet() {
        this.readLock.lock();
        try {
            HashSet<Long> localSyncStateSet = new HashSet<Long>(this.syncStateSet.size());
            localSyncStateSet.addAll(this.syncStateSet);
            HashSet<Long> hashSet = localSyncStateSet;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void truncateEpochFilePrefix(long offset) {
        this.epochCache.truncatePrefixByOffset(offset);
    }

    public void truncateEpochFileSuffix(long offset) {
        this.epochCache.truncateSuffixByOffset(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncateInvalidMsg() {
        SelectMappedBufferResult result;
        long dispatchBehind = this.defaultMessageStore.dispatchBehindBytes();
        if (dispatchBehind <= 0L) {
            LOGGER.info("Dispatch complete, skip truncate");
            return -1L;
        }
        boolean doNext = true;
        long reputFromOffset = this.defaultMessageStore.getReputFromOffset();
        while ((result = this.defaultMessageStore.getCommitLog().getData(reputFromOffset)) != null) {
            try {
                int size;
                reputFromOffset = result.getStartOffset();
                for (int readSize = 0; readSize < result.getSize(); readSize += size) {
                    DispatchRequest dispatchRequest = this.defaultMessageStore.getCommitLog().checkMessageAndReturnSize(result.getByteBuffer(), false, false);
                    if (dispatchRequest.isSuccess()) {
                        size = dispatchRequest.getMsgSize();
                        if (size > 0) {
                            reputFromOffset += (long)size;
                            continue;
                        }
                        reputFromOffset = this.defaultMessageStore.getCommitLog().rollNextFile(reputFromOffset);
                    } else {
                        doNext = false;
                    }
                    break;
                }
            }
            finally {
                result.release();
            }
            if (reputFromOffset < this.defaultMessageStore.getMaxPhyOffset() && doNext) continue;
        }
        LOGGER.info("Truncate commitLog to {}", (Object)reputFromOffset);
        this.defaultMessageStore.truncateDirtyFiles(reputFromOffset);
        return reputFromOffset;
    }

    public int getLastEpoch() {
        return this.epochCache.lastEpoch();
    }

    public List<EpochEntry> getEpochEntries() {
        return this.epochCache.getAllEntries();
    }

    public Long getBrokerControllerId() {
        return this.brokerControllerId;
    }

    public void setBrokerControllerId(Long brokerControllerId) {
        this.brokerControllerId = brokerControllerId;
    }

    class AutoSwitchAcceptSocketService
    extends DefaultHAService.AcceptSocketService {
        public AutoSwitchAcceptSocketService(MessageStoreConfig messageStoreConfig) {
            super(AutoSwitchHAService.this, messageStoreConfig);
        }

        public String getServiceName() {
            if (AutoSwitchHAService.this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
                return AutoSwitchHAService.this.defaultMessageStore.getBrokerConfig().getIdentifier() + DefaultHAService.AcceptSocketService.class.getSimpleName();
            }
            return AutoSwitchAcceptSocketService.class.getSimpleName();
        }

        @Override
        protected HAConnection createConnection(SocketChannel sc) throws IOException {
            return new AutoSwitchHAConnection(AutoSwitchHAService.this, sc, AutoSwitchHAService.this.epochCache);
        }
    }
}

