/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.coldctr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.rocketmq.broker.coldctr.ColdCtrStrategy;
import org.apache.rocketmq.broker.coldctr.ColdDataCgCtrService;

public class PIDAdaptiveColdCtrStrategy
implements ColdCtrStrategy {
    private static final int MAX_STORE_NUMS = 10;
    private static final Double KP = 0.5;
    private static final Double KI = 0.3;
    private static final Double KD = 0.2;
    private final List<Long> historyEtValList = new ArrayList<Long>();
    private final ColdDataCgCtrService coldDataCgCtrService;
    private final Long expectGlobalVal;
    private long et = 0L;

    public PIDAdaptiveColdCtrStrategy(ColdDataCgCtrService coldDataCgCtrService, Long expectGlobalVal) {
        this.coldDataCgCtrService = coldDataCgCtrService;
        this.expectGlobalVal = expectGlobalVal;
    }

    @Override
    public Double decisionFactor() {
        if (this.historyEtValList.size() < 10) {
            return 0.0;
        }
        Long et1 = this.historyEtValList.get(this.historyEtValList.size() - 1);
        Long et2 = this.historyEtValList.get(this.historyEtValList.size() - 2);
        Long differential = et1 - et2;
        Double integration = 0.0;
        for (Long item : this.historyEtValList) {
            integration = integration + (double)item.longValue();
        }
        return KP * (double)this.et + KI * integration + KD * (double)differential.longValue();
    }

    @Override
    public void promote(String consumerGroup, Long currentThreshold) {
        if (this.decisionFactor() > 0.0) {
            this.coldDataCgCtrService.addOrUpdateGroupConfig(consumerGroup, (long)((double)currentThreshold.longValue() * 1.5));
        }
    }

    @Override
    public void decelerate(String consumerGroup, Long currentThreshold) {
        if (this.decisionFactor() < 0.0) {
            long changedThresholdVal = (long)((double)currentThreshold.longValue() * 0.8);
            if (changedThresholdVal < this.coldDataCgCtrService.getBrokerConfig().getCgColdReadThreshold()) {
                changedThresholdVal = this.coldDataCgCtrService.getBrokerConfig().getCgColdReadThreshold();
            }
            this.coldDataCgCtrService.addOrUpdateGroupConfig(consumerGroup, changedThresholdVal);
        }
    }

    @Override
    public void collect(Long globalAcc) {
        this.et = this.expectGlobalVal - globalAcc;
        this.historyEtValList.add(this.et);
        Iterator<Long> iterator = this.historyEtValList.iterator();
        while (this.historyEtValList.size() > 10 && iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }
}

