/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.Platform;
import com.alipay.sofa.jraft.util.Requires;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;

public final class StorageOptionsFactory {
    private static final Map<String, DBOptions> rocksDBOptionsTable;
    private static final Map<String, ColumnFamilyOptions> columnFamilyOptionsTable;
    private static final Map<String, BlockBasedTableConfig> tableFormatConfigTable;

    public static void releaseAllOptions() {
        for (DBOptions dBOptions : rocksDBOptionsTable.values()) {
            if (dBOptions == null) continue;
            dBOptions.close();
        }
        for (ColumnFamilyOptions columnFamilyOptions : columnFamilyOptionsTable.values()) {
            if (columnFamilyOptions == null) continue;
            columnFamilyOptions.close();
        }
    }

    private static String buildKey(String groupId, Class<?> cls) {
        Requires.requireNonNull(cls, "cls");
        if (Objects.isNull(groupId)) {
            return cls.getName();
        }
        return groupId + "-" + cls.getName();
    }

    public static void registerRocksDBOptions(String groupId, Class<?> cls, DBOptions opts) {
        Requires.requireNonNull(cls, "cls");
        Requires.requireNonNull(opts, "opts");
        String key = StorageOptionsFactory.buildKey(groupId, cls);
        if (rocksDBOptionsTable.putIfAbsent(key, opts) != null) {
            throw new IllegalStateException("DBOptions with class key [" + key + "] has already been registered");
        }
    }

    public static void registerRocksDBOptions(Class<?> cls, DBOptions opts) {
        StorageOptionsFactory.registerRocksDBOptions(null, cls, opts);
    }

    public static DBOptions getRocksDBOptions(String groupId, Class<?> cls) {
        Requires.requireNonNull(cls, "cls");
        String key = StorageOptionsFactory.buildKey(groupId, cls);
        DBOptions opts = rocksDBOptionsTable.get(key);
        if (opts == null) {
            DBOptions newOpts = StorageOptionsFactory.getDefaultRocksDBOptions();
            opts = rocksDBOptionsTable.putIfAbsent(key, newOpts);
            if (opts == null) {
                opts = newOpts;
            } else {
                newOpts.close();
            }
        }
        return new DBOptions(StorageOptionsFactory.checkInvalid(opts));
    }

    public static DBOptions getDefaultRocksDBOptions() {
        DBOptions opts = new DBOptions();
        opts.setCreateIfMissing(true);
        opts.setCreateMissingColumnFamilies(true);
        opts.setMaxOpenFiles(-1);
        opts.setKeepLogFileNum(100L);
        opts.setMaxTotalWalSize(0x40000000L);
        return opts;
    }

    public static void registerRocksDBColumnFamilyOptions(String groupId, Class<?> cls, ColumnFamilyOptions opts) {
        Requires.requireNonNull(cls, "cls");
        Requires.requireNonNull(opts, "opts");
        String key = StorageOptionsFactory.buildKey(groupId, cls);
        if (columnFamilyOptionsTable.putIfAbsent(key, opts) != null) {
            throw new IllegalStateException("ColumnFamilyOptions with class key [" + key + "] has already been registered");
        }
    }

    public static void registerRocksDBColumnFamilyOptions(Class<?> cls, ColumnFamilyOptions opts) {
        StorageOptionsFactory.registerRocksDBColumnFamilyOptions(null, cls, opts);
    }

    public static ColumnFamilyOptions getRocksDBColumnFamilyOptions(String groupId, Class<?> cls) {
        Requires.requireNonNull(cls, "cls");
        String key = StorageOptionsFactory.buildKey(groupId, cls);
        ColumnFamilyOptions opts = columnFamilyOptionsTable.get(key);
        if (opts == null) {
            ColumnFamilyOptions newOpts = StorageOptionsFactory.getDefaultRocksDBColumnFamilyOptions();
            opts = columnFamilyOptionsTable.putIfAbsent(key, newOpts);
            if (opts == null) {
                opts = newOpts;
            } else {
                newOpts.close();
            }
        }
        return new ColumnFamilyOptions(StorageOptionsFactory.checkInvalid(opts));
    }

    public static ColumnFamilyOptions getDefaultRocksDBColumnFamilyOptions() {
        ColumnFamilyOptions opts = new ColumnFamilyOptions();
        opts.setWriteBufferSize(0x4000000L);
        opts.setMaxWriteBufferNumber(3);
        opts.setMinWriteBufferNumberToMerge(1);
        opts.setLevel0FileNumCompactionTrigger(10);
        opts.setLevel0SlowdownWritesTrigger(20);
        opts.setLevel0StopWritesTrigger(40);
        opts.setMaxBytesForLevelBase(0x20000000L);
        opts.setTargetFileSizeBase(0x4000000L);
        opts.setMemtablePrefixBloomSizeRatio(0.125);
        if (!Platform.isWindows()) {
            opts.setCompressionType(CompressionType.LZ4_COMPRESSION).setCompactionStyle(CompactionStyle.LEVEL).optimizeLevelStyleCompaction();
        }
        opts.setForceConsistencyChecks(true);
        return opts;
    }

    public static void registerRocksDBTableFormatConfig(String groupId, Class<?> cls, BlockBasedTableConfig cfg) {
        Requires.requireNonNull(cls, "cls");
        Requires.requireNonNull(cfg, "cfg");
        String key = StorageOptionsFactory.buildKey(groupId, cls);
        if (tableFormatConfigTable.putIfAbsent(key, cfg) != null) {
            throw new IllegalStateException("TableFormatConfig with class key [" + key + "] has already been registered");
        }
    }

    public static void registerRocksDBTableFormatConfig(Class<?> cls, BlockBasedTableConfig cfg) {
        StorageOptionsFactory.registerRocksDBTableFormatConfig(null, cls, cfg);
    }

    public static BlockBasedTableConfig getRocksDBTableFormatConfig(String groupId, Class<?> cls) {
        BlockBasedTableConfig newCfg;
        Requires.requireNonNull(cls, "cls");
        String key = StorageOptionsFactory.buildKey(groupId, cls);
        BlockBasedTableConfig cfg = tableFormatConfigTable.get(key);
        if (cfg == null && (cfg = tableFormatConfigTable.putIfAbsent(key, newCfg = StorageOptionsFactory.getDefaultRocksDBTableConfig())) == null) {
            cfg = newCfg;
        }
        return StorageOptionsFactory.copyTableFormatConfig(cfg);
    }

    public static BlockBasedTableConfig getDefaultRocksDBTableConfig() {
        return new BlockBasedTableConfig().setIndexType(IndexType.kTwoLevelIndexSearch).setFilterPolicy((Filter)new BloomFilter(16.0, false)).setPartitionFilters(true).setMetadataBlockSize(8192L).setCacheIndexAndFilterBlocks(false).setCacheIndexAndFilterBlocksWithHighPriority(true).setPinL0FilterAndIndexBlocksInCache(true).setBlockSize(4096L);
    }

    private static BlockBasedTableConfig copyTableFormatConfig(BlockBasedTableConfig cfg) {
        return new BlockBasedTableConfig().setNoBlockCache(cfg.noBlockCache()).setBlockSize(cfg.blockSize()).setBlockSizeDeviation(cfg.blockSizeDeviation()).setBlockRestartInterval(cfg.blockRestartInterval()).setWholeKeyFiltering(cfg.wholeKeyFiltering()).setCacheIndexAndFilterBlocks(cfg.cacheIndexAndFilterBlocks()).setCacheIndexAndFilterBlocksWithHighPriority(cfg.cacheIndexAndFilterBlocksWithHighPriority()).setPinL0FilterAndIndexBlocksInCache(cfg.pinL0FilterAndIndexBlocksInCache()).setPartitionFilters(cfg.partitionFilters()).setMetadataBlockSize(cfg.metadataBlockSize()).setPinTopLevelIndexAndFilter(cfg.pinTopLevelIndexAndFilter()).setChecksumType(cfg.checksumType()).setIndexType(cfg.indexType()).setFormatVersion(cfg.formatVersion());
    }

    private static <T extends RocksObject> T checkInvalid(T opts) {
        if (!opts.isOwningHandle()) {
            throw new IllegalStateException("the instance of options [" + opts + "] has been released, calling any of its functions will lead to undefined behavior.");
        }
        return opts;
    }

    private StorageOptionsFactory() {
    }

    static {
        RocksDB.loadLibrary();
        rocksDBOptionsTable = new ConcurrentHashMap<String, DBOptions>();
        columnFamilyOptionsTable = new ConcurrentHashMap<String, ColumnFamilyOptions>();
        tableFormatConfigTable = new ConcurrentHashMap<String, BlockBasedTableConfig>();
    }
}

