/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.admin;

import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import org.apache.rocketmq.client.impl.mqclient.MQClientAPIExt;
import org.apache.rocketmq.client.impl.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.service.admin.AdminService;
import org.apache.rocketmq.proxy.service.route.TopicRouteHelper;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class DefaultAdminService
implements AdminService {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final MQClientAPIFactory mqClientAPIFactory;

    public DefaultAdminService(MQClientAPIFactory mqClientAPIFactory) {
        this.mqClientAPIFactory = mqClientAPIFactory;
    }

    @Override
    public boolean topicExist(String topic) {
        boolean topicExist;
        try {
            TopicRouteData topicRouteData = this.getTopicRouteDataDirectlyFromNameServer(topic);
            topicExist = topicRouteData != null;
        }
        catch (Throwable e) {
            topicExist = false;
        }
        return topicExist;
    }

    @Override
    public boolean createTopicOnTopicBrokerIfNotExist(String createTopic, String sampleTopic, int wQueueNum, int rQueueNum, boolean examineTopic, int retryCheckCount) {
        TopicRouteData curTopicRouteData;
        block7: {
            curTopicRouteData = new TopicRouteData();
            try {
                curTopicRouteData = this.getTopicRouteDataDirectlyFromNameServer(createTopic);
            }
            catch (Exception e) {
                if (TopicRouteHelper.isTopicNotExistError(e)) break block7;
                log.error("get cur topic route {} failed.", (Object)createTopic, (Object)e);
                return false;
            }
        }
        TopicRouteData sampleTopicRouteData = null;
        try {
            sampleTopicRouteData = this.getTopicRouteDataDirectlyFromNameServer(sampleTopic);
        }
        catch (Exception e) {
            log.error("create topic {} failed.", (Object)createTopic, (Object)e);
            return false;
        }
        if (sampleTopicRouteData == null || sampleTopicRouteData.getBrokerDatas().isEmpty()) {
            return false;
        }
        try {
            return this.createTopicOnBroker(createTopic, wQueueNum, rQueueNum, curTopicRouteData.getBrokerDatas(), sampleTopicRouteData.getBrokerDatas(), examineTopic, retryCheckCount);
        }
        catch (Exception e) {
            log.error("create topic {} failed.", (Object)createTopic, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean createTopicOnBroker(String topic, int wQueueNum, int rQueueNum, List<BrokerData> curBrokerDataList, List<BrokerData> sampleBrokerDataList, boolean examineTopic, int retryCheckCount) throws Exception {
        HashSet curBrokerAddr = new HashSet();
        if (curBrokerDataList != null) {
            for (BrokerData brokerData : curBrokerDataList) {
                curBrokerAddr.add(brokerData.getBrokerAddrs().get(0L));
            }
        }
        TopicConfig topicConfig = new TopicConfig();
        topicConfig.setTopicName(topic);
        topicConfig.setWriteQueueNums(wQueueNum);
        topicConfig.setReadQueueNums(rQueueNum);
        topicConfig.setPerm(6);
        for (BrokerData brokerData : sampleBrokerDataList) {
            String addr = brokerData.getBrokerAddrs() == null ? null : (String)brokerData.getBrokerAddrs().get(0L);
            if (addr == null || curBrokerAddr.contains(addr)) continue;
            try {
                this.getClient().createTopic(addr, "TBW102", topicConfig, Duration.ofSeconds(3L).toMillis());
            }
            catch (Exception e) {
                log.error("create topic on broker failed. topic:{}, broker:{}", new Object[]{topicConfig, addr, e});
            }
        }
        if (examineTopic) {
            void var10_13;
            int n = retryCheckCount;
            while (--var10_13 > 0) {
                if (!this.topicExist(topic)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    protected TopicRouteData getTopicRouteDataDirectlyFromNameServer(String topic) throws Exception {
        return this.getClient().getTopicRouteInfoFromNameServer(topic, Duration.ofSeconds(3L).toMillis());
    }

    protected MQClientAPIExt getClient() {
        return this.mqClientAPIFactory.getClient();
    }
}

