/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics;

import java.util.function.Consumer;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.DoubleUpDownCounter;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentValueType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.SdkObservableInstrument;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.instrument.BoundDoubleUpDownCounter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkDoubleUpDownCounter
extends AbstractInstrument
implements DoubleUpDownCounter {
    private final WriteableMetricStorage storage;

    private SdkDoubleUpDownCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void add(double increment, Attributes attributes, Context context) {
        this.storage.recordDouble(increment, attributes, context);
    }

    @Override
    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    BoundDoubleUpDownCounter bind(Attributes attributes) {
        return new BoundInstrument(this.storage.bind(attributes), attributes);
    }

    static final class BoundInstrument
    implements BoundDoubleUpDownCounter {
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(BoundStorageHandle handle, Attributes attributes) {
            this.handle = handle;
            this.attributes = attributes;
        }

        @Override
        public void add(double increment, Context context) {
            this.handle.recordDouble(increment, this.attributes, context);
        }

        @Override
        public void add(double increment) {
            this.add(increment, Context.current());
        }

        @Override
        public void unbind() {
            this.handle.release();
        }
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements DoubleUpDownCounterBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public DoubleUpDownCounter build() {
            return this.buildSynchronousInstrument(InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.DOUBLE, (x$0, x$1) -> new SdkDoubleUpDownCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return new SdkObservableInstrument(this.meterSharedState, this.registerDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback));
        }
    }
}

