/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.rpc;

import com.alipay.remoting.exception.CodecException;
import com.alipay.remoting.serialization.Serializer;
import com.alipay.sofa.jraft.rhea.serialization.Serializers;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.util.internal.ThrowUtil;
import java.util.concurrent.ConcurrentMap;

public class ProtostuffSerializer
implements Serializer {
    public static final ProtostuffSerializer INSTANCE = new ProtostuffSerializer();
    private static final ConcurrentMap<String, Class<?>> classCache = Maps.newConcurrentMap();
    private final com.alipay.sofa.jraft.rhea.serialization.Serializer delegate = Serializers.getSerializer(1);

    public byte[] serialize(Object obj) throws CodecException {
        return this.delegate.writeObject(obj);
    }

    public <T> T deserialize(byte[] data, String classOfT) throws CodecException {
        Class<?> clazz = (Class<?>)classCache.get(classOfT);
        if (clazz == null) {
            try {
                Class<?> newClazz = Class.forName(classOfT);
                clazz = classCache.putIfAbsent(classOfT, newClazz);
                if (clazz == null) {
                    clazz = newClazz;
                }
            }
            catch (Exception e) {
                ThrowUtil.throwException((Throwable)e);
            }
        }
        return this.delegate.readObject(data, clazz);
    }
}

