/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.RecursionGuard;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinitionBase;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.GetterDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.SetterDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.problems.CircularTypeReferenceProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.IncompatibleInterfaceMethodProblem;
import org.apache.royale.compiler.problems.UnimplementedInterfaceMethodProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IDefinitionSet;

public class InterfaceDefinition
extends TypeDefinitionBase
implements IInterfaceDefinition {
    private IReference[] extendedInterfaces;
    private INamespaceDefinition.ILanguageNamespaceDefinition interfaceNamespace = null;

    public InterfaceDefinition(String name) {
        super(name);
    }

    @Override
    public IInterfaceDefinition.InterfaceClassification getInterfaceClassification() {
        IDefinition parent = this.getParent();
        if (parent instanceof IPackageDefinition) {
            return IInterfaceDefinition.InterfaceClassification.PACKAGE_MEMBER;
        }
        if (parent == null) {
            if (this.inPackageNamespace()) {
                return IInterfaceDefinition.InterfaceClassification.PACKAGE_MEMBER;
            }
            return IInterfaceDefinition.InterfaceClassification.FILE_MEMBER;
        }
        assert (false);
        return null;
    }

    @Override
    public String[] getExtendedInterfacesAsDisplayStrings() {
        if (this.extendedInterfaces == null) {
            return new String[0];
        }
        String[] interfaces = new String[this.extendedInterfaces.length];
        int l = this.extendedInterfaces.length;
        for (int i = 0; i < l; ++i) {
            if (this.extendedInterfaces[i] == null) continue;
            interfaces[i] = this.extendedInterfaces[i].getDisplayString();
        }
        return interfaces;
    }

    public void setExtendedInterfaceReferences(IReference[] extendedInterfaces) {
        this.extendedInterfaces = extendedInterfaces;
    }

    @Override
    public IReference[] getExtendedInterfaceReferences() {
        return this.extendedInterfaces;
    }

    @Override
    public IInterfaceDefinition[] resolveExtendedInterfaces(ICompilerProject project) {
        return ((CompilerProject)project).getCacheForScope(this.getContainedScope()).resolveInterfaces();
    }

    @Override
    public IInterfaceDefinition[] resolveInterfacesImpl(ICompilerProject project) {
        int n;
        int n2 = n = this.extendedInterfaces != null ? this.extendedInterfaces.length : 0;
        if (n == 0) {
            this.addDependencyOnBuiltinType((CompilerProject)project, IASLanguageConstants.BuiltinType.OBJECT, DependencyType.INHERITANCE);
        }
        IInterfaceDefinition[] result = new IInterfaceDefinition[n];
        for (int i = 0; i < n; ++i) {
            TypeDefinitionBase typeDefinition = this.resolveType(this.extendedInterfaces[i], project, DependencyType.INHERITANCE);
            if (!(typeDefinition instanceof IInterfaceDefinition)) {
                typeDefinition = null;
            }
            result[i] = (IInterfaceDefinition)((Object)typeDefinition);
        }
        return this.filterNullInterfaces(result);
    }

    private void addDependencyOnBuiltinType(CompilerProject project, IASLanguageConstants.BuiltinType builtinType, DependencyType dependencyType) {
        this.getContainingASScope().addDependencyOnBuiltinType(project, builtinType, dependencyType);
    }

    @Override
    public boolean isInstanceOf(ITypeDefinition type, ICompilerProject project) {
        if (type == this) {
            return true;
        }
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT).equals(type)) {
            return true;
        }
        if (!(type instanceof IInterfaceDefinition)) {
            return false;
        }
        Iterator<IInterfaceDefinition> iter = this.interfaceIterator(project, false);
        while (iter.hasNext()) {
            IInterfaceDefinition intf = iter.next();
            if (intf != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IInterfaceDefinition> resolveAllInterfaces(ICompilerProject project) {
        HashSet<IInterfaceDefinition> interfaces = new HashSet<IInterfaceDefinition>();
        Iterator<IInterfaceDefinition> iter = this.interfaceIterator(project, false);
        while (iter.hasNext()) {
            IInterfaceDefinition intf = iter.next();
            interfaces.add(intf);
        }
        return interfaces;
    }

    @Override
    public Iterator<IInterfaceDefinition> interfaceIterator(ICompilerProject project, boolean includeThis) {
        return new InterfaceIterator(this, project, includeThis, null);
    }

    public Iterator<IInterfaceDefinition> interfaceIterator(ICompilerProject project, boolean includeThis, Collection<ICompilerProblem> problems) {
        return new InterfaceIterator(this, project, includeThis, problems);
    }

    @Override
    public INamespaceDefinition getProtectedNamespaceReference() {
        return null;
    }

    @Override
    public INamespaceDefinition getStaticProtectedNamespaceReference() {
        return null;
    }

    public INamespaceDefinition.ILanguageNamespaceDefinition getInterfaceNamespaceReference() {
        return this.interfaceNamespace;
    }

    String generateInterfaceURI() {
        String pack = this.getPackageName();
        String shortName = this.getBaseName();
        Object uri = pack != "" ? pack + ":" + shortName : shortName;
        return uri;
    }

    public Set<INamespaceDefinition> getInterfaceNamespaceSet(ICompilerProject project) {
        return this.getInterfaceNamespaceSet(project, InterfaceNamespaceSetOptions.INCLUDE_THIS);
    }

    Set<INamespaceDefinition> getInterfaceNamespaceSet(ICompilerProject project, InterfaceNamespaceSetOptions includeThis) {
        LinkedHashSet<INamespaceDefinition> result = new LinkedHashSet<INamespaceDefinition>();
        Iterator<IInterfaceDefinition> iter = this.interfaceIterator(project, includeThis == InterfaceNamespaceSetOptions.INCLUDE_THIS);
        while (iter.hasNext()) {
            InterfaceDefinition intf = (InterfaceDefinition)iter.next();
            result.add(intf.getInterfaceNamespaceReference());
        }
        return result;
    }

    @Override
    public void setNamespaceReference(INamespaceReference value) {
        super.setNamespaceReference(value);
        this.interfaceNamespace = NamespaceDefinition.createInterfaceNamespaceDefinition(this);
    }

    public void validateClassImplementsAllMethods(ICompilerProject project, ClassDefinition cls, Collection<ICompilerProblem> problems) {
        INamespaceDefinition.IPublicNamespaceDefinition publicNs = NamespaceDefinition.getPublicNamespaceDefinition();
        ASScope classScope = cls.getContainedScope();
        for (IDefinitionSet defSet : this.getContainedScope().getAllLocalDefinitionSets()) {
            int l = defSet.getSize();
            for (int i = 0; i < l; ++i) {
                FunctionDefinition interfMethod;
                IDefinition def = defSet.getDefinition(i);
                if (!(def instanceof FunctionDefinition) || (interfMethod = (FunctionDefinition)def).isImplicit() || interfMethod.getBaseName().equals(this.getBaseName())) continue;
                IDefinition c = classScope.getQualifiedPropertyFromDef(project, (IDefinition)cls, interfMethod.getBaseName(), publicNs, false);
                if (interfMethod instanceof SetterDefinition && c instanceof GetterDefinition) {
                    c = ((GetterDefinition)c).resolveCorrespondingAccessor(project);
                } else if (interfMethod instanceof GetterDefinition && c instanceof SetterDefinition) {
                    c = ((SetterDefinition)c).resolveCorrespondingAccessor(project);
                }
                String ifaceName = this.getBaseName();
                if (c instanceof FunctionDefinition) {
                    FunctionDefinition classMethod = (FunctionDefinition)c;
                    if (classMethod.hasCompatibleSignature(interfMethod, project)) continue;
                    problems.add(new IncompatibleInterfaceMethodProblem(classMethod, interfMethod.getBaseName(), ifaceName, cls.getBaseName()));
                    continue;
                }
                problems.add(new UnimplementedInterfaceMethodProblem(cls, interfMethod.getBaseName(), ifaceName, cls.getBaseName()));
            }
        }
    }

    @Override
    protected void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        sb.append("interface");
        sb.append(' ');
        sb.append(this.getBaseName());
        String[] extendedInterfaces = this.getExtendedInterfacesAsDisplayStrings();
        int n = extendedInterfaces.length;
        if (n > 0) {
            sb.append(' ');
            sb.append("implements");
            sb.append(' ');
            for (int i = 0; i < n; ++i) {
                sb.append(extendedInterfaces[i]);
                if (i >= n - 1) continue;
                sb.append(',');
                sb.append(' ');
            }
        }
    }

    @Override
    public boolean matches(DefinitionBase node) {
        String[] rightNames;
        boolean matches = super.matches(node);
        if (!matches) {
            return false;
        }
        String[] leftNames = ((InterfaceDefinition)node).getExtendedInterfacesAsDisplayStrings();
        if (leftNames.length != (rightNames = this.getExtendedInterfacesAsDisplayStrings()).length) {
            return false;
        }
        HashSet<String> hitTable = new HashSet<String>(Arrays.asList(leftNames));
        for (int i = 0; i < rightNames.length; ++i) {
            if (hitTable.contains(rightNames[i])) continue;
            return false;
        }
        return true;
    }

    public static class InterfaceIterator
    implements Iterator<IInterfaceDefinition> {
        private final ICompilerProject project;
        Set<IInterfaceDefinition> theInterfaces = new HashSet<IInterfaceDefinition>();
        Iterator<IInterfaceDefinition> underlyingIterator = null;

        public InterfaceIterator(IInterfaceDefinition thisInterface, ICompilerProject project, boolean includeThis, Collection<ICompilerProblem> problems) {
            this.project = project;
            this.initFromInterface(Collections.singleton(thisInterface), includeThis, problems);
        }

        public InterfaceIterator(ClassDefinitionBase cls, ICompilerProject project, Collection<ICompilerProblem> problems) {
            this.project = project;
            HashSet<IInterfaceDefinition> clsInterfaces = new HashSet<IInterfaceDefinition>();
            IClassDefinition.IClassIterator classIterator = cls.classIterator(project, true);
            while (classIterator.hasNext()) {
                IClassDefinition nextClass = (IClassDefinition)classIterator.next();
                ClassDefinitionBase classDefinitionBase = (ClassDefinitionBase)nextClass;
                IReference[] refs = nextClass.getImplementedInterfaceReferences();
                InterfaceDefinition[] idefs = classDefinitionBase.resolveImplementedInterfaces(project, problems);
                for (int i = 0; i < refs.length; ++i) {
                    if (idefs[i] == null) continue;
                    clsInterfaces.add(idefs[i]);
                }
            }
            this.initFromInterface(clsInterfaces, true, problems);
        }

        private void initFromInterface(Set<IInterfaceDefinition> thisInterfaces, boolean includeThis, Collection<ICompilerProblem> problems) {
            for (IInterfaceDefinition iface : thisInterfaces) {
                if (includeThis) {
                    this.theInterfaces.add(iface);
                }
                RecursionGuard guard = new RecursionGuard();
                this.analyze(iface, guard, problems);
            }
            this.underlyingIterator = this.theInterfaces.iterator();
        }

        private void analyze(IInterfaceDefinition iface, RecursionGuard guard, Collection<ICompilerProblem> problems) {
            IInterfaceDefinition[] parentIFaces;
            if (guard.isLoop(iface)) {
                if (problems != null) {
                    problems.add(new CircularTypeReferenceProblem(iface, iface.getBaseName()));
                }
                return;
            }
            for (IInterfaceDefinition parentIFace : parentIFaces = iface.resolveExtendedInterfaces(this.project)) {
                RecursionGuard childGuard = new RecursionGuard(guard);
                this.analyze(parentIFace, childGuard, problems);
                if (childGuard.foundLoop) continue;
                this.theInterfaces.add(parentIFace);
            }
        }

        @Override
        public boolean hasNext() {
            return this.underlyingIterator.hasNext();
        }

        @Override
        public IInterfaceDefinition next() {
            return this.underlyingIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static enum InterfaceNamespaceSetOptions {
        INCLUDE_THIS,
        DONT_INCLUDE_THIS;

    }
}

