/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.impl.Waitable;
import java.util.Collection;

class WaitableRace<T>
implements Waitable<T> {
    private final Collection<Waitable<T>> waitables;

    WaitableRace(Collection<Waitable<T>> waitables) {
        this.waitables = waitables;
    }

    @Override
    public boolean isDone() {
        for (Waitable<T> w : this.waitables) {
            if (!w.isDone()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get() {
        assert (this.isDone());
        this.dispose();
        for (Waitable<T> w : this.waitables) {
            if (!w.isDone()) continue;
            return w.get();
        }
        throw new IllegalStateException("At least one element must be ready");
    }

    @Override
    public void dispose() {
        for (Waitable<T> w : this.waitables) {
            w.dispose();
        }
    }
}

