/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypeDeclarationsIR {
    public static Node.TypeDeclarationNode stringType() {
        return new Node.TypeDeclarationNode(Token.STRING_TYPE);
    }

    public static Node.TypeDeclarationNode numberType() {
        return new Node.TypeDeclarationNode(Token.NUMBER_TYPE);
    }

    public static Node.TypeDeclarationNode booleanType() {
        return new Node.TypeDeclarationNode(Token.BOOLEAN_TYPE);
    }

    public static Node.TypeDeclarationNode anyType() {
        return new Node.TypeDeclarationNode(Token.ANY_TYPE);
    }

    public static Node.TypeDeclarationNode voidType() {
        return new Node.TypeDeclarationNode(Token.VOID_TYPE);
    }

    public static Node.TypeDeclarationNode undefinedType() {
        return new Node.TypeDeclarationNode(Token.UNDEFINED_TYPE);
    }

    public static Node.TypeDeclarationNode namedType(String typeName) {
        return TypeDeclarationsIR.namedType(Splitter.on('.').split(typeName));
    }

    public static Node.TypeDeclarationNode namedType(Iterable<String> segments) {
        Iterator<String> segmentsIt = segments.iterator();
        Node node = IR.name(segmentsIt.next());
        while (segmentsIt.hasNext()) {
            node = IR.getprop(node, IR.string(segmentsIt.next()));
        }
        return new Node.TypeDeclarationNode(Token.NAMED_TYPE, node);
    }

    public static Node.TypeDeclarationNode recordType(LinkedHashMap<String, Node.TypeDeclarationNode> properties) {
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(Token.RECORD_TYPE);
        for (Map.Entry<String, Node.TypeDeclarationNode> prop : properties.entrySet()) {
            Node stringKey = IR.stringKey(prop.getKey());
            node.addChildToBack(stringKey);
            if (prop.getValue() == null) continue;
            stringKey.addChildToFront(prop.getValue());
        }
        return node;
    }

    private static Node maybeAddType(Node node, Node.TypeDeclarationNode type) {
        if (type != null) {
            node.setDeclaredTypeExpression(type);
        }
        return node;
    }

    public static Node.TypeDeclarationNode functionType(Node returnType, LinkedHashMap<String, Node.TypeDeclarationNode> requiredParams, LinkedHashMap<String, Node.TypeDeclarationNode> optionalParams, String restName, Node.TypeDeclarationNode restType) {
        Node name;
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(Token.FUNCTION_TYPE, returnType);
        Preconditions.checkNotNull(requiredParams);
        Preconditions.checkNotNull(optionalParams);
        for (Map.Entry<String, Node.TypeDeclarationNode> param : requiredParams.entrySet()) {
            name = IR.name(param.getKey());
            node.addChildToBack(TypeDeclarationsIR.maybeAddType(name, param.getValue()));
        }
        for (Map.Entry<String, Node.TypeDeclarationNode> param : optionalParams.entrySet()) {
            name = IR.name(param.getKey());
            name.putBooleanProp(Node.OPT_ES6_TYPED, true);
            node.addChildToBack(TypeDeclarationsIR.maybeAddType(name, param.getValue()));
        }
        if (restName != null) {
            Node rest = new Node(Token.REST, IR.name(restName));
            node.addChildToBack(TypeDeclarationsIR.maybeAddType(rest, restType));
        }
        return node;
    }

    public static Node.TypeDeclarationNode parameterizedType(Node.TypeDeclarationNode baseType, Iterable<Node.TypeDeclarationNode> typeParameters) {
        if (Iterables.isEmpty(typeParameters)) {
            return baseType;
        }
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(Token.PARAMETERIZED_TYPE, baseType);
        for (Node node2 : typeParameters) {
            node.addChildToBack(node2);
        }
        return node;
    }

    public static Node.TypeDeclarationNode arrayType(Node elementType) {
        return new Node.TypeDeclarationNode(Token.ARRAY_TYPE, elementType);
    }

    public static Node.TypeDeclarationNode unionType(Iterable<Node.TypeDeclarationNode> options) {
        Preconditions.checkArgument(!Iterables.isEmpty(options), "union must have at least one option");
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(Token.UNION_TYPE);
        for (Node node2 : options) {
            node.addChildToBack(node2);
        }
        return node;
    }

    public static Node.TypeDeclarationNode unionType(Node.TypeDeclarationNode ... options) {
        return TypeDeclarationsIR.unionType(Arrays.asList(options));
    }

    public static Node.TypeDeclarationNode optionalParameter(Node.TypeDeclarationNode parameterType) {
        return new Node.TypeDeclarationNode(Token.OPTIONAL_PARAMETER, parameterType);
    }
}

