/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSFontFace;
import org.apache.royale.compiler.css.ICSSNamespaceDefinition;
import org.apache.royale.compiler.css.ICSSNode;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.internal.css.CSSFontFace;
import org.apache.royale.compiler.internal.css.CSSLexer;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSNamespaceDefinition;
import org.apache.royale.compiler.internal.css.CSSNodeBase;
import org.apache.royale.compiler.internal.css.CSSParser;
import org.apache.royale.compiler.internal.css.CSSRule;
import org.apache.royale.compiler.internal.css.CSSTree;
import org.apache.royale.compiler.internal.css.CSSTypedNode;
import org.apache.royale.compiler.problems.CompilerProblemSeverity;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;

public class CSSDocument
extends CSSNodeBase
implements ICSSDocument {
    private static final String DEFAULT_NAMESPACE_SHORT_NAME = "";
    private static final int NOT_SET = -1;
    private final ImmutableList<ICSSRule> rules;
    private final ImmutableList<ICSSNamespaceDefinition> namespaces;
    private final ImmutableList<ICSSFontFace> fontFaces;
    private final ImmutableMap<String, CSSNamespaceDefinition> namespacesLookup;

    public static CSSDocument parse(CharStream input, Collection<ICompilerProblem> problems) {
        return CSSDocument.parse(input, false, problems);
    }

    public static CSSDocument parse(CharStream input, boolean strictFlexCSS, Collection<ICompilerProblem> problems) {
        assert (input != null) : "CSS input can't be null";
        assert (problems != null) : "Problem collection can't be null";
        try {
            CSSLexer lexer = new CSSLexer(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            CSSParser parser = new CSSParser(tokens);
            CSSParser.stylesheet_return stylesheet = parser.stylesheet();
            problems.addAll(lexer.problems);
            problems.addAll(parser.problems);
            if (!CSSDocument.hasErrors(lexer.problems) && !CSSDocument.hasErrors(parser.problems)) {
                CommonTree ast = (CommonTree)stylesheet.getTree();
                if (ast == null) {
                    ast = new CommonTree();
                }
                CommonTreeNodeStream nodes = new CommonTreeNodeStream(ast);
                nodes.setTokenStream(tokens);
                CSSTree treeWalker = new CSSTree(nodes);
                treeWalker.setStrictFlexCSS(strictFlexCSS);
                treeWalker.stylesheet();
                problems.addAll(treeWalker.problems);
                return treeWalker.model;
            }
            return null;
        }
        catch (RecognitionException e) {
            assert (false) : "RecognitionException must be collected as ICompilerProblem.";
            problems.add(new UnexpectedExceptionProblem(e));
            return null;
        }
    }

    protected CSSDocument(List<CSSRule> rules, List<CSSNamespaceDefinition> namespaces, List<CSSFontFace> fontFaces, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.DOCUMENT);
        assert (rules != null) : "Rules can't be null.";
        assert (namespaces != null) : "Namespace definitions can't be null";
        assert (fontFaces != null) : "Font face definitions can't be null";
        this.rules = new ImmutableList.Builder().addAll(rules).build();
        this.namespaces = new ImmutableList.Builder().addAll(namespaces).build();
        this.fontFaces = new ImmutableList.Builder().addAll(fontFaces).build();
        for (CSSRule cSSRule : rules) {
            cSSRule.setParent(this);
        }
        HashMap<String, CSSNamespaceDefinition> namespaceMap = new HashMap<String, CSSNamespaceDefinition>();
        for (CSSNamespaceDefinition namespace : namespaces) {
            String prefix = namespace.getPrefix();
            String key = prefix != null ? prefix : DEFAULT_NAMESPACE_SHORT_NAME;
            namespaceMap.put(key, namespace);
            namespace.setParent(this);
        }
        this.namespacesLookup = ImmutableMap.copyOf(namespaceMap);
        for (CSSFontFace fontFace : fontFaces) {
            fontFace.setParent(this);
        }
        this.children.add(new CSSTypedNode(CSSModelTreeType.NAMESPACE_LIST, this.namespaces));
        this.children.add(new CSSTypedNode(CSSModelTreeType.FONT_FACE_LIST, this.fontFaces));
        this.children.add(new CSSTypedNode(CSSModelTreeType.RULE_LIST, this.rules));
        ArrayList<ICSSNode> arrayList = new ArrayList<ICSSNode>();
        arrayList.addAll((Collection<ICSSNode>)this.namespaces);
        arrayList.addAll((Collection<ICSSNode>)this.fontFaces);
        arrayList.addAll((Collection<ICSSNode>)this.rules);
        int line = -1;
        int column = -1;
        int endLine = -1;
        int endColumn = -1;
        int start = -1;
        int end = -1;
        for (ICSSNode node : arrayList) {
            if (start == -1 || start > node.getStart()) {
                start = node.getStart();
            }
            if (end == -1 || end < node.getStart()) {
                end = node.getEnd();
            }
            if (line == -1 || line > node.getLine()) {
                line = node.getLine();
                column = node.getColumn();
            } else if (line == node.getLine() && column > node.getColumn()) {
                column = node.getColumn();
            }
            if (endLine == -1 || endLine < node.getEndLine()) {
                endLine = node.getEndLine();
                endColumn = node.getEndColumn();
                continue;
            }
            if (endLine != node.getEndLine() || endColumn >= node.getEndColumn()) continue;
            endColumn = node.getEndColumn();
        }
        this.setStart(start);
        this.setEnd(end);
        this.setLine(line);
        this.setColumn(column);
        this.setEndLine(endLine);
        this.setEndColumn(endColumn);
        if (tokenStream != null) {
            this.setSourcePath(tokenStream.getSourceName());
        }
    }

    @Override
    public ImmutableList<ICSSRule> getRules() {
        return this.rules;
    }

    @Override
    public ImmutableList<ICSSNamespaceDefinition> getAtNamespaces() {
        return this.namespaces;
    }

    @Override
    public String toString() {
        return Joiner.on((String)"\n").join((Object)Joiner.on((String)"\n").join(this.namespaces), (Object)Joiner.on((String)"\n").join(this.fontFaces), new Object[]{Joiner.on((String)"\n").join(this.rules)});
    }

    @Override
    public ImmutableList<ICSSFontFace> getFontFaces() {
        return this.fontFaces;
    }

    @Override
    public ICSSNamespaceDefinition getNamespaceDefinition(String prefix) {
        return (ICSSNamespaceDefinition)this.namespacesLookup.get((Object)prefix);
    }

    @Override
    public ICSSNamespaceDefinition getDefaultNamespaceDefinition() {
        return (ICSSNamespaceDefinition)this.namespacesLookup.get((Object)DEFAULT_NAMESPACE_SHORT_NAME);
    }

    private static boolean hasErrors(Collection<ICompilerProblem> problems) {
        CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer(null);
        for (ICompilerProblem problem : problems) {
            CompilerProblemSeverity severity = categorizer.getProblemSeverity(problem);
            if (!CompilerProblemSeverity.ERROR.equals((Object)severity)) continue;
            return true;
        }
        return false;
    }
}

