/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.css.FontFaceSourceType;
import org.apache.royale.compiler.css.ICSSFontFace;
import org.apache.royale.compiler.css.ICSSNode;
import org.apache.royale.compiler.css.ICSSProperty;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSNodeBase;
import org.apache.royale.compiler.internal.css.CSSProperty;
import org.apache.royale.compiler.problems.CSSRequiredDescriptorProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class CSSFontFace
extends CSSNodeBase
implements ICSSFontFace {
    private final CSSFunctionCallPropertyValue source;
    private final ArrayList<ICSSPropertyValue> sources = new ArrayList();
    private final String fontFamily;
    private final String fontStyle;
    private final String fontWeight;
    private final boolean isEmbedAsCFF;
    private final boolean isAdvancedAntiAliasing;
    private final ImmutableList<ICSSProperty> propertyList;
    private final List<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();

    protected CSSFontFace(List<CSSProperty> properties, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.FONT_FACE);
        SourceLocation sourceLocation;
        assert (properties != null) : "Properties can't be null for @font-face.";
        ICSSNode srcValue = null;
        Object fontFamilyValue = null;
        Object fontStyleValue = null;
        Object fontWeightValue = null;
        Object embedAsCFFValue = null;
        Object advancedAAValue = null;
        this.propertyList = properties == null ? ImmutableList.of() : new ImmutableList.Builder().addAll(properties).build();
        if (properties != null) {
            for (CSSProperty property : properties) {
                property.setParent(this);
                String name = property.getName();
                ICSSPropertyValue value = property.getValue();
                if (name.equals("src")) {
                    this.sources.add(value);
                    srcValue = value;
                    continue;
                }
                if (name.equals("fontFamily")) {
                    fontFamilyValue = value;
                    continue;
                }
                if (name.equals("fontStyle")) {
                    fontStyleValue = value;
                    continue;
                }
                if (name.equals("fontWeight")) {
                    fontWeightValue = value;
                    continue;
                }
                if (name.equals("embedAsCFF")) {
                    embedAsCFFValue = value;
                    continue;
                }
                if (!name.equals("advancedAntiAliasing")) continue;
                advancedAAValue = value;
            }
        }
        if (srcValue == null) {
            this.source = null;
            sourceLocation = new SourceLocation(tokenStream.getSourceName(), -1, -1, tree.getLine(), tree.getCharPositionInLine());
            this.problems.add(new CSSRequiredDescriptorProblem(sourceLocation, "@font-face", "src"));
        } else {
            this.source = srcValue instanceof CSSArrayPropertyValue ? (CSSFunctionCallPropertyValue)srcValue.getNthChild(0) : (CSSFunctionCallPropertyValue)srcValue;
        }
        if (fontFamilyValue == null) {
            this.fontFamily = null;
            sourceLocation = new SourceLocation(tokenStream.getSourceName(), -1, -1, tree.getLine(), tree.getCharPositionInLine());
            this.problems.add(new CSSRequiredDescriptorProblem(sourceLocation, "@font-face", "fontFamily"));
        } else {
            this.fontFamily = fontFamilyValue.toString();
        }
        this.fontStyle = fontStyleValue == null ? "normal" : fontStyleValue.toString();
        this.fontWeight = fontWeightValue == null ? "normal" : fontWeightValue.toString();
        this.isEmbedAsCFF = embedAsCFFValue == null || embedAsCFFValue.toString().equalsIgnoreCase("true");
        this.isAdvancedAntiAliasing = advancedAAValue == null || advancedAAValue.toString().equalsIgnoreCase("true");
    }

    public List<ICompilerProblem> getProblems() {
        return this.problems;
    }

    public ArrayList<ICSSPropertyValue> getSources() {
        return this.sources;
    }

    @Override
    public FontFaceSourceType getSourceType() {
        return Enum.valueOf(FontFaceSourceType.class, this.source.name.toUpperCase());
    }

    @Override
    public String getSourceValue() {
        String sourceValue = null;
        if (FontFaceSourceType.URL.equals((Object)this.getSourceType()) || FontFaceSourceType.LOCAL.equals((Object)this.getSourceType())) {
            sourceValue = CSSFunctionCallPropertyValue.getSingleArgumentFromRaw(this.source.rawArguments);
        }
        return sourceValue;
    }

    @Override
    public String getFontFamily() {
        return this.fontFamily;
    }

    @Override
    public String getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public String getFontWeight() {
        return this.fontWeight;
    }

    public boolean getEmbedAsCFF() {
        return this.isEmbedAsCFF;
    }

    @Override
    public ImmutableList<ICSSProperty> getProperties() {
        return this.propertyList;
    }

    @Override
    public boolean getAdvancedAntiAliasing() {
        return this.isAdvancedAntiAliasing;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("@font-face {\n");
        result.append("    src : ").append(this.source).append(";\n");
        result.append("    fontFamily : ").append(this.fontFamily).append(";\n");
        result.append("    embedAsCFF : ").append(this.isEmbedAsCFF);
        result.append("    advancedAntiAliasing : ").append(this.isAdvancedAntiAliasing).append(";\n");
        result.append("    fontStyle : ").append(this.fontStyle).append(";\n");
        result.append("    fontWeight : ").append(this.fontWeight).append(";\n");
        result.append("}\n");
        return result.toString();
    }
}

