/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.LocalizationManager;
import flash.swf.tools.Disassembler;
import flash.swf.types.ActionList;
import flash.tools.ActionLocation;
import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DMessageCounter;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.DSuspendInfo;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.util.FieldFormat;
import flex.tools.debugger.cli.AmbiguousException;
import flex.tools.debugger.cli.DebugCLI;
import flex.tools.debugger.cli.FileInfoCache;
import flex.tools.debugger.cli.FileLocation;
import flex.tools.debugger.cli.NoMatchException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.HashMap;

public class Extensions {
    public static final String m_newline = System.getProperty("line.separator");

    public static void doShowStats(DebugCLI debugCLI) throws IllegalStateException {
        Session session = debugCLI.getSession();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            long l;
            int n;
            PlayerSession playerSession = (PlayerSession)session;
            DMessageCounter dMessageCounter = playerSession.getMessageCounter();
            stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("key16"));
            stringBuilder.append(m_newline);
            for (n = 0; n <= 65; ++n) {
                l = dMessageCounter.getInCount(n);
                if (l <= 0L) continue;
                stringBuilder.append('\n');
                stringBuilder.append(DMessage.inTypeName(n));
                stringBuilder.append(" = ");
                stringBuilder.append(l);
            }
            stringBuilder.append("\n\n");
            stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("key17"));
            stringBuilder.append("\n");
            for (n = 0; n <= 57; ++n) {
                l = dMessageCounter.getOutCount(n);
                if (l <= 0L) continue;
                stringBuilder.append('\n');
                stringBuilder.append(DMessage.outTypeName(n));
                stringBuilder.append(" = ");
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
            debugCLI.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException();
        }
    }

    public static void doShowFuncs(DebugCLI debugCLI) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        FileInfoCache fileInfoCache = debugCLI.getFileCache();
        try {
            if (debugCLI.hasMoreTokens()) {
                string = debugCLI.nextToken();
                int n = string.equals(".") ? debugCLI.propertyGet("$listmodule") : debugCLI.parseFileArg(debugCLI.getActiveIsolateId(), -1, string);
                DModule dModule = (DModule)fileInfoCache.getFile(n, debugCLI.getActiveIsolateId());
                dModule.lineMapping(stringBuilder);
            } else {
                SourceFile[] sourceFileArray = fileInfoCache.getFileList();
                if (sourceFileArray == null) {
                    debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key18"));
                } else {
                    for (int i = 0; i < sourceFileArray.length; ++i) {
                        DModule dModule = (DModule)sourceFileArray[i];
                        dModule.lineMapping(stringBuilder);
                    }
                }
            }
            debugCLI.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key19"));
        }
        catch (ParseException parseException) {
            debugCLI.err(parseException.getMessage());
        }
        catch (AmbiguousException ambiguousException) {
            debugCLI.err(ambiguousException.getMessage());
        }
        catch (NoMatchException noMatchException) {
            debugCLI.err(noMatchException.getMessage());
        }
    }

    public static void doShowProperties(DebugCLI debugCLI) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Session session = debugCLI.getSession();
        for (String iterator : debugCLI.propertyKeys()) {
            int string = debugCLI.propertyGet(iterator);
            stringBuilder.append(iterator);
            stringBuilder.append(" = ");
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        Object object2 = (PlayerSessionManager)Bootstrap.sessionManager();
        stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("key21"));
        stringBuilder.append('\n');
        for (String string : ((PlayerSessionManager)object2).keySet()) {
            object = ((PlayerSessionManager)object2).getPreferenceAsObject(string);
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            stringBuilder.append(object);
            stringBuilder.append('\n');
        }
        if (session != null) {
            object2 = (PlayerSession)session;
            stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("key22"));
            stringBuilder.append('\n');
            for (String string : ((PlayerSession)object2).keySet()) {
                object = ((PlayerSession)object2).getPreferenceAsObject(string);
                stringBuilder.append(string);
                stringBuilder.append(" = ");
                stringBuilder.append(object);
                stringBuilder.append('\n');
            }
        }
        debugCLI.out(stringBuilder.toString());
    }

    public static void doShowBreak(DebugCLI debugCLI) throws NotConnectedException {
        int n = debugCLI.getActiveIsolateId();
        debugCLI.waitTilHalted(n);
        try {
            Session session = debugCLI.getSession();
            StringBuilder stringBuilder = new StringBuilder();
            if (session.getWorkerSession(n).isSuspended()) {
                stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("stopped"));
                stringBuilder.append(' ');
                Extensions.appendBreakInfo(debugCLI, stringBuilder, true, n);
            } else {
                stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("key24"));
            }
            debugCLI.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key25"));
        }
    }

    public static void appendBreakInfo(DebugCLI debugCLI, StringBuilder stringBuilder, boolean bl, int n) throws NotConnectedException {
        HashMap<String, Object> hashMap;
        Session session = debugCLI.getSession();
        FileInfoCache fileInfoCache = debugCLI.getFileCache();
        int n2 = session.suspendReason();
        int n3 = ((PlayerSession)session).getSuspendOffset();
        int n4 = ((PlayerSession)session).getSuspendActionIndex();
        SwfInfo swfInfo = null;
        try {
            swfInfo = fileInfoCache.getSwfs(n)[n4];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (swfInfo != null) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("swfName", FileInfoCache.nameOfSwf(swfInfo));
            stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("key35", hashMap));
            stringBuilder.append(' ');
        }
        hashMap = new HashMap();
        hashMap.put("address", "0x" + FieldFormat.formatLongToHex(new StringBuilder(), n3, 8) + " (" + n3 + ")");
        stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("atAddress", hashMap));
        if (bl) {
            hashMap = new HashMap();
            StringBuilder stringBuilder2 = new StringBuilder();
            debugCLI.appendReason(stringBuilder2, n2);
            hashMap.put("fault", stringBuilder2.toString());
            stringBuilder.append(' ');
            stringBuilder.append(Extensions.getLocalizationManager().getLocalizedTextString("haltedDueToFault", hashMap));
        }
    }

    public static void doShowVariable(DebugCLI debugCLI) throws PlayerDebugException {
        int n = debugCLI.getActiveIsolateId();
        debugCLI.waitTilHalted(n);
        try {
            Session session = debugCLI.getSession();
            long l = debugCLI.nextLongToken();
            String string = debugCLI.hasMoreTokens() ? debugCLI.nextToken() : null;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            Value value = ((PlayerSession)session).getValue(l, string, n);
            debugCLI.m_exprCache.appendVariableValue(stringBuilder, value, n);
            debugCLI.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key26"));
        }
    }

    public static void doDisassemble(DebugCLI debugCLI) throws PlayerDebugException {
        int n = debugCLI.propertyGet("$listmodule");
        int n2 = debugCLI.propertyGet("$listline");
        int n3 = debugCLI.propertyGet("$listworker");
        String string = null;
        int n4 = n;
        int n5 = n2;
        String string2 = null;
        int n6 = n2;
        boolean bl = false;
        int n7 = 0;
        try {
            Object object;
            FileInfoCache fileInfoCache = debugCLI.getFileCache();
            Session session = debugCLI.getSession();
            int n8 = debugCLI.getActiveIsolateId();
            if (debugCLI.hasMoreTokens()) {
                string = debugCLI.nextToken();
                if (string.equals("-")) {
                    n5 = n6 = n5 - 1;
                } else {
                    boolean bl2 = false;
                    object = debugCLI.parseLocationArg(n, n2, string, false);
                    if (((FileLocation[])object).length == 1) {
                        n4 = object[0].getModule();
                        n6 = n5 = object[0].getLine();
                        boolean bl3 = bl = object[0].getWasFunc() != 0;
                    }
                    if (debugCLI.hasMoreTokens()) {
                        string2 = debugCLI.nextToken();
                        n6 = debugCLI.parseLineArg(n4, string2);
                    }
                }
            } else if (fileInfoCache.getFile(n, n3) == null) {
                DSuspendInfo dSuspendInfo = ((PlayerSession)session).getSuspendInfoIsolate(n8);
                int n9 = dSuspendInfo.getOffset();
                int n10 = dSuspendInfo.getActionIndex();
                int n11 = dSuspendInfo.getNextOffset();
                if (dSuspendInfo.getReason() == 0) {
                    throw new SuspendedException();
                }
                SwfInfo swfInfo = fileInfoCache.getSwfs(n8)[n10];
                Extensions.outputAssembly(debugCLI, (DSwfInfo)swfInfo, n9, n11);
                throw new AmbiguousException(Extensions.getLocalizationManager().getLocalizedTextString("key27"));
            }
            if (debugCLI.hasMoreTokens()) {
                debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key28"));
            } else {
                SourceFile sourceFile = fileInfoCache.getFile(n4);
                n7 = sourceFile.getLineCount();
                if (n5 > n7 && string != null) {
                    throw new IndexOutOfBoundsException();
                }
                if (string2 == null) {
                    n6 = n5;
                }
                if (n5 < 1) {
                    n6 += -(n5 - 1);
                    n5 = 1;
                }
                if (n6 > n7) {
                    n6 = n7;
                }
                if (n5 > n6) {
                    throw new IndexOutOfBoundsException();
                }
                object = (DSwfInfo)fileInfoCache.swfForFile(sourceFile, debugCLI.getActiveIsolateId());
                ActionLocation actionLocation = null;
                ActionLocation actionLocation2 = null;
                if (object == null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("arg3", sourceFile.getName());
                    debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key29", hashMap));
                } else if (bl) {
                    int n12 = sourceFile.getOffsetForLine(n5);
                    actionLocation = ((DSwfInfo)object).locate(n12);
                    if (actionLocation.function == null) {
                        debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key30"));
                    } else {
                        ActionList actionList = new ActionList(true);
                        actionList.setActionOffset(0, actionLocation.function);
                        actionLocation.actions = actionList;
                        actionLocation.at = 0;
                        actionLocation2 = new ActionLocation();
                        actionLocation2.actions = actionList;
                        actionLocation2.at = 0;
                        Extensions.outputAssembly(debugCLI, (SwfInfo)object, actionLocation, actionLocation2);
                    }
                } else {
                    ActionLocation actionLocation3 = null;
                    for (int i = n5; i <= n6; ++i) {
                        int n13 = sourceFile.getOffsetForLine(i);
                        if (n13 != 0) {
                            actionLocation = ((DSwfInfo)object).locate(n13);
                            actionLocation2 = ((DSwfInfo)object).locateSourceLineEnd(actionLocation);
                            if (actionLocation3 != null) {
                                ++actionLocation3.at;
                                if (actionLocation3.actions != actionLocation.actions && actionLocation3.actions.size() != actionLocation3.at) {
                                    var21_38 = Integer.toHexString(actionLocation3.actions.getOffset(actionLocation3.at));
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    hashMap.put("arg4", var21_38);
                                    debugCLI.out(Extensions.getLocalizationManager().getLocalizedTextString("key31", hashMap));
                                    ActionLocation actionLocation4 = ((DSwfInfo)object).locateSourceLineEnd(actionLocation3);
                                    Extensions.outputAssembly(debugCLI, (SwfInfo)object, actionLocation3, actionLocation4);
                                } else if (actionLocation3.at < actionLocation.at) {
                                    var21_38 = new ActionLocation(actionLocation);
                                    --((ActionLocation)var21_38).at;
                                    Extensions.outputAssembly(debugCLI, (SwfInfo)object, actionLocation3, (ActionLocation)var21_38);
                                }
                            }
                            actionLocation3 = actionLocation2;
                        }
                        debugCLI.outputSource(n4, i, sourceFile.getLine(i));
                        if (n13 == 0) continue;
                        Extensions.outputAssembly(debugCLI, (SwfInfo)object, actionLocation, actionLocation2);
                    }
                    debugCLI.propertyPut("$listmodule", n4);
                    debugCLI.propertyPut("$listline", n6 + 1);
                    debugCLI.m_repeatLine = "disassemble";
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string3 = "#" + n4;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("arg5", Integer.toString(n5));
            hashMap.put("arg6", string3);
            hashMap.put("arg7", Integer.toString(n7));
            debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key32", hashMap));
        }
        catch (AmbiguousException ambiguousException) {
            debugCLI.err(ambiguousException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key33"));
        }
        catch (ParseException parseException) {
            debugCLI.err(parseException.getMessage());
        }
        catch (NoMatchException noMatchException) {
            debugCLI.err(noMatchException.getMessage());
        }
        catch (SuspendedException suspendedException) {
            debugCLI.err(Extensions.getLocalizationManager().getLocalizedTextString("key34"));
        }
    }

    private static LocalizationManager getLocalizationManager() {
        return DebugCLI.getLocalizationManager();
    }

    public static ActionLocation outputAssembly(DebugCLI debugCLI, DSwfInfo dSwfInfo, int n, int n2) {
        ActionLocation actionLocation = dSwfInfo.locate(n);
        ActionLocation actionLocation2 = n2 > -1 ? dSwfInfo.locate(n2) : dSwfInfo.locateSourceLineEnd(actionLocation);
        return Extensions.outputAssembly(debugCLI, (SwfInfo)dSwfInfo, actionLocation, actionLocation2);
    }

    public static ActionLocation outputAssembly(DebugCLI debugCLI, SwfInfo swfInfo, ActionLocation actionLocation, ActionLocation actionLocation2) {
        if (actionLocation.actions != actionLocation2.actions) {
            actionLocation2.at = actionLocation.actions.size() - 1;
        }
        Disassembler.disassemble(actionLocation.actions, actionLocation.pool, actionLocation.at, actionLocation2.at, new PrintWriter(debugCLI.getOut()));
        return actionLocation2;
    }
}

