/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.ITernaryOperatorNode;

public class TernaryOperatorNode
extends BinaryOperatorNodeBase
implements ITernaryOperatorNode {
    private ExpressionNodeBase conditionalNode;

    public TernaryOperatorNode(IASToken op, ExpressionNodeBase conditionalNode, ExpressionNodeBase leftOperandNode, ExpressionNodeBase rightOperandNode) {
        super(op, null, null);
        this.leftOperandNode = leftOperandNode;
        this.rightOperandNode = rightOperandNode;
        this.conditionalNode = conditionalNode;
        ExpressionNodeBase lastChildren = rightOperandNode != null ? rightOperandNode : (leftOperandNode != null ? leftOperandNode : conditionalNode);
        if (conditionalNode != null) {
            if (conditionalNode.getStart() == -1) {
                conditionalNode.fillInOffsets();
            }
            this.span(conditionalNode, lastChildren);
        }
    }

    protected TernaryOperatorNode(TernaryOperatorNode other) {
        super(other);
        this.conditionalNode = other.conditionalNode != null ? other.conditionalNode.copy() : null;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.TernaryExpressionID;
    }

    @Override
    public int getChildCount() {
        if (this.conditionalNode == null) {
            return 0;
        }
        if (this.leftOperandNode == null) {
            return 1;
        }
        if (this.rightOperandNode == null) {
            return 2;
        }
        return 3;
    }

    @Override
    public IASNode getChild(int i) {
        switch (i) {
            case 0: {
                return this.conditionalNode;
            }
            case 1: {
                return this.leftOperandNode;
            }
            case 2: {
                return this.rightOperandNode;
            }
        }
        return null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.conditionalNode != null) {
            this.conditionalNode.setParent(this);
        }
        super.setChildren(fillInOffsets);
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        ITypeDefinition rightType;
        ITypeDefinition leftType = this.getLeftOperandNode().resolveType(project);
        ITypeDefinition commonType = SemanticUtils.resolveCommonType(leftType, rightType = this.getRightOperandNode().resolveType(project), project);
        if (commonType != null) {
            return commonType;
        }
        if (leftType == rightType) {
            return leftType;
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }

    @Override
    protected TernaryOperatorNode copy() {
        return new TernaryOperatorNode(this);
    }

    @Override
    public IOperatorNode.OperatorType getOperator() {
        return IOperatorNode.OperatorType.CONDITIONAL;
    }

    @Override
    public IExpressionNode getConditionalNode() {
        return this.conditionalNode;
    }
}

