/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as.metadata;

import antlr.Token;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.parsing.TokenBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.QualifiedNameExpressionNode;
import org.apache.royale.compiler.internal.tree.as.metadata.BaseDefinitionMetaTagNode;
import org.apache.royale.compiler.tree.as.ICommonClassNode;
import org.apache.royale.compiler.tree.metadata.IStyleTagNode;
import org.apache.royale.compiler.workspaces.IWorkspace;
import org.apache.royale.utils.CheapArray;

public final class StyleTagNode
extends BaseDefinitionMetaTagNode
implements IStyleTagNode {
    private IdentifierNode arrayType;
    private IdentifierNode type;
    private Object values;
    private Object states;
    private static final String[] EMPTY_LIST = new String[0];

    public StyleTagNode() {
        super("Style");
        this.init();
    }

    private void init() {
        this.values = CheapArray.create(3);
        this.states = CheapArray.create(3);
    }

    @Override
    public void normalize(boolean fillInOffsets) {
        super.normalize(fillInOffsets);
        this.values = CheapArray.optimize(this.values, EMPTY_LIST);
        this.states = CheapArray.optimize(this.states, EMPTY_LIST);
    }

    public void setArrayType(IdentifierNode arrayType) {
        this.arrayType = arrayType;
        this.arrayType.setParent(this);
        this.addToMap("arrayType", this.getArrayTypeName());
    }

    public void setType(Token type) {
        this.type = new QualifiedNameExpressionNode((TokenBase)type);
        this.type.setParent(this);
        this.addToMap("type", this.getTypeName());
    }

    public void setIsInheritable(String doesInherit) {
        this.addToMap("inherit", doesInherit);
    }

    public void setFormat(String format) {
        this.addToMap("format", format);
    }

    public void addValue(String value) {
        this.addToList("enumeration", value, this.values);
    }

    public void addState(String state) {
        this.addToList("states", state, this.states);
    }

    private void addToList(String key, String value, Object array) {
        CheapArray.add(value, array);
        Object string = this.getValue(key);
        if (((String)string).length() > 0) {
            string = (String)string + ",";
        }
        string = (String)string + value;
        this.addToMap(key, value);
    }

    public void parseValues(String valueString) {
        this.parseList("enumeration", valueString, this.values);
    }

    public void parseStates(String statesString) {
        this.parseList("states", statesString, this.states);
    }

    private void parseList(String key, String value, Object list) {
        if (value != null) {
            String[] strings = value.split(",");
            for (int i = 0; i < strings.length; ++i) {
                CheapArray.add(strings[i].trim(), list);
            }
        }
        this.addToMap(key, value);
    }

    private String getArrayTypeName() {
        if (this.arrayType != null) {
            return this.arrayType.getName();
        }
        return "";
    }

    public IdentifierNode getArrayTypeNode() {
        return this.arrayType;
    }

    @Override
    public String getFormat() {
        return this.getValue("format");
    }

    @Override
    public String getTypeName() {
        if (this.type != null) {
            return this.type.getName();
        }
        return "";
    }

    @Override
    public boolean hasThemes() {
        return !this.getValue("theme").isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StyleTagNode) {
            StyleTagNode other = (StyleTagNode)obj;
            if (!this.equals(this.nameNode, other.nameNode)) {
                return false;
            }
            if (!this.equals(this.type, other.type)) {
                return false;
            }
            if (!this.equals(this.arrayType, other.arrayType)) {
                return false;
            }
            if (other.getAbsoluteStart() != this.getAbsoluteStart()) {
                return false;
            }
            if (other.getAbsoluteEnd() != this.getAbsoluteEnd()) {
                return false;
            }
            if (this.getFormat().compareTo(other.getFormat()) != 0) {
                return false;
            }
            if (other.getValue("enumeration").compareTo(this.getValue("enumeration")) != 0) {
                return false;
            }
            return other.getValue("states").compareTo(this.getValue("states")) == 0;
        }
        return false;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.addChildInOrder(this.arrayType, fillInOffsets);
        this.addChildInOrder(this.type, fillInOffsets);
    }

    @Override
    protected int getInitialChildCount() {
        return 0;
    }

    @Override
    public IDefinition getDefinition() {
        ICommonClassNode decoratedClassNode = (ICommonClassNode)this.getAncestorOfType(ICommonClassNode.class);
        if (decoratedClassNode == null) {
            return null;
        }
        IWorkspace workspace = this.getWorkspace();
        IClassDefinition decoratedClassDefinition = decoratedClassNode.getDefinition();
        assert (decoratedClassDefinition != null);
        return decoratedClassDefinition.getStyleDefinition(workspace, this.getName());
    }
}

