/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter;

import java.util.ArrayList;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.as.IASNode;

public class TokenQuery {
    public static final int TOKEN_TYPE_WHITESPACE = 999999;
    private IASToken[] allTokens;

    public TokenQuery(IASToken[] tokens) {
        this.allTokens = tokens;
    }

    public IASToken[] getTokens() {
        return this.allTokens;
    }

    public IASToken[] getTokens(IASNode node) {
        return this.getTokens(node, false, false);
    }

    public IASToken[] getTokens(IASNode node, boolean skipComments, boolean skipWhitespace) {
        ArrayList<IASToken> result = new ArrayList<IASToken>();
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() < node.getAbsoluteStart()) continue;
            if (token.getAbsoluteStart() >= node.getAbsoluteEnd()) break;
            if (skipComments && this.isComment(token) || skipWhitespace && this.isWhitespace(token)) continue;
            result.add(token);
        }
        return result.toArray(new IASToken[0]);
    }

    public IASToken getTokenBefore(ISourceLocation sourceLocation) {
        return this.getTokenBefore(sourceLocation, false, false);
    }

    public IASToken getTokenBefore(ISourceLocation sourceLocation, boolean skipComments, boolean skipWhitespace) {
        IASToken result = null;
        for (IASToken token : this.allTokens) {
            if (skipComments && this.isComment(token) || skipWhitespace && this.isWhitespace(token)) continue;
            if (token.getAbsoluteStart() >= sourceLocation.getAbsoluteStart()) {
                return result;
            }
            result = token;
        }
        return result;
    }

    public IASToken getTokenAfter(ISourceLocation sourceLocation) {
        return this.getTokenAfter(sourceLocation, false, false);
    }

    public IASToken getTokenAfter(ISourceLocation sourceLocation, boolean skipComments, boolean skipWhitespace) {
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() < sourceLocation.getAbsoluteEnd() || skipComments && this.isComment(token) || skipWhitespace && this.isWhitespace(token)) continue;
            return token;
        }
        return null;
    }

    public IASToken getFirstToken(IASNode node) {
        return this.getFirstToken(node, false, false);
    }

    public IASToken getFirstToken(IASNode node, boolean skipComments, boolean skipWhitespace) {
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() < node.getAbsoluteStart() || skipComments && this.isComment(token) || skipWhitespace && this.isWhitespace(token)) continue;
            return token;
        }
        return null;
    }

    public IASToken getLastToken(IASNode node) {
        return this.getLastToken(node, false, false);
    }

    public IASToken getLastToken(IASNode node, boolean skipComments, boolean skipWhitespace) {
        IASToken result = null;
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() >= node.getAbsoluteStart()) {
                if (skipComments && this.isComment(token) || skipWhitespace && this.isWhitespace(token)) continue;
                result = token;
                continue;
            }
            if (result != null) break;
        }
        return result;
    }

    public IASToken getPreviousTokenOfType(ISourceLocation before, int type) {
        IASToken result = null;
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() >= before.getAbsoluteStart()) {
                return result;
            }
            if (token.getType() != type) continue;
            result = token;
        }
        return result;
    }

    public IASToken getNextTokenOfType(ISourceLocation after, int type) {
        for (IASToken token : this.allTokens) {
            if (token.getType() != type || token.getAbsoluteStart() < after.getAbsoluteEnd()) continue;
            return token;
        }
        return null;
    }

    public IASToken[] getCommentsInside(IASNode node) {
        IASToken[] tokensInside;
        ArrayList<IASToken> result = new ArrayList<IASToken>();
        for (IASToken token : tokensInside = this.getTokens(node)) {
            if (!this.isComment(token)) continue;
            result.add(token);
        }
        return result.toArray(new IASToken[0]);
    }

    public boolean isComment(IASToken token) {
        return token.getType() == 4 || token.getType() == 5 || token.getType() == 8 || token.getType() == 28;
    }

    public IASToken getCommentBefore(ISourceLocation before) {
        IASToken result = null;
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() >= before.getAbsoluteStart()) {
                return result;
            }
            if (!this.isComment(token)) continue;
            result = token;
        }
        return result;
    }

    public IASToken getCommentAfter(ISourceLocation after) {
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() < after.getAbsoluteEnd() || !this.isComment(token)) continue;
            return token;
        }
        return null;
    }

    public boolean isWhitespace(IASToken token) {
        return token.getType() == 999999;
    }

    public IASToken getWhitespaceBefore(ISourceLocation before) {
        IASToken result = null;
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() >= before.getAbsoluteStart()) {
                return result;
            }
            if (!this.isWhitespace(token)) continue;
            result = token;
        }
        return result;
    }

    public IASToken getWhitespaceAfter(ISourceLocation after) {
        for (IASToken token : this.allTokens) {
            if (token.getAbsoluteStart() < after.getAbsoluteEnd() || !this.isWhitespace(token)) continue;
            return token;
        }
        return null;
    }

    public IASToken getSignificantTokenBefore(ISourceLocation before) {
        return this.getTokenBefore(before, true, true);
    }

    public IASToken getSignificantTokenAfter(ISourceLocation after) {
        return this.getTokenAfter(after, true, true);
    }
}

