/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoConstructorReturnTypeRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!functionNode.isConstructor()) {
            return;
        }
        IExpressionNode returnTypeNode = functionNode.getReturnTypeNode();
        if (returnTypeNode == null) {
            return;
        }
        problems.add(new NoConstructorReturnTypeLinterProblem(functionNode));
    }

    public static class NoConstructorReturnTypeLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Constructor '${functionName}' must not specify '${returnType}' return type";
        public String functionName;
        public String returnType;

        public NoConstructorReturnTypeLinterProblem(IFunctionNode node) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.functionName = node.getName();
            this.returnType = node.getReturnType();
        }
    }
}

