/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.rhino.Node;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;

final class PerformanceTrackerCodeSizeEstimator
extends CodeConsumer {
    private int size = 0;
    private char lastChar = '\u0000';
    private final ByteArrayOutputStream output;
    private final GZIPOutputStream stream;
    private final boolean trackGzSize;

    static PerformanceTrackerCodeSizeEstimator estimate(Node jsRoot, boolean trackGzSize) {
        PerformanceTrackerCodeSizeEstimator estimator = new PerformanceTrackerCodeSizeEstimator(trackGzSize);
        CodeGenerator.forCostEstimation(estimator).add(jsRoot);
        return estimator;
    }

    private PerformanceTrackerCodeSizeEstimator(boolean trackGzSize) {
        this.trackGzSize = trackGzSize;
        if (trackGzSize) {
            try {
                this.output = new ByteArrayOutputStream();
                this.stream = new GZIPOutputStream(this.output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.output = null;
            this.stream = null;
        }
    }

    @Override
    void append(String str) {
        int len = str.length();
        if (len > 0) {
            this.size += len;
            this.lastChar = str.charAt(len - 1);
            if (this.trackGzSize) {
                try {
                    this.stream.write(str.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    char getLastChar() {
        return this.lastChar;
    }

    int getCodeSize() {
        return this.size;
    }

    int getZippedCodeSize() {
        if (this.trackGzSize) {
            try {
                this.stream.finish();
                this.stream.close();
                return this.output.size();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return 0;
    }
}

