/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;

public final class RewriteObjectSpread
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD);
    private final boolean addTypes;

    public RewriteObjectSpread(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.addTypes = compiler.hasTypeCheckingRun();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case OBJECTLIT: {
                this.visitObject(n);
                break;
            }
        }
    }

    private void visitObject(Node obj) {
        for (Node child : obj.children()) {
            if (!child.isSpread()) continue;
            this.visitObjectWithSpread(obj);
            return;
        }
    }

    private void visitObjectWithSpread(Node obj) {
        JSType simpleObjectType;
        Preconditions.checkArgument(obj.isObjectLit());
        JSType resultType = simpleObjectType = Es6ToEs3Util.createType(this.addTypes, this.compiler.getTypeRegistry(), JSTypeNative.EMPTY_OBJECT_LITERAL_TYPE);
        Node result = Es6ToEs3Util.withType(IR.call(NodeUtil.newQName(this.compiler, "Object.assign"), new Node[0]), resultType);
        result.addChildToBack(Es6ToEs3Util.withType(IR.objectlit(new Node[0]), simpleObjectType));
        Node trailingObjectLiteral = null;
        for (Node child : obj.children()) {
            if (child.isSpread()) {
                Node spreaded = child.removeFirstChild();
                result.addChildToBack(spreaded);
                trailingObjectLiteral = null;
                continue;
            }
            if (trailingObjectLiteral == null) {
                trailingObjectLiteral = Es6ToEs3Util.withType(IR.objectlit(new Node[0]), simpleObjectType);
                result.addChildToBack(trailingObjectLiteral);
            }
            trailingObjectLiteral.addChildToBack(child.detach());
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        obj.replaceWith(result);
        this.compiler.reportChangeToEnclosingScope(result);
    }
}

