/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MachineProbe {
    DFA dfa;

    public MachineProbe(DFA dfa) {
        this.dfa = dfa;
    }

    List<DFAState> getAnyDFAPathToTarget(DFAState targetState) {
        HashSet<DFAState> visited = new HashSet<DFAState>();
        return this.getAnyDFAPathToTarget(this.dfa.startState, targetState, visited);
    }

    public List<DFAState> getAnyDFAPathToTarget(DFAState startState, DFAState targetState, Set<DFAState> visited) {
        ArrayList<DFAState> dfaStates = new ArrayList<DFAState>();
        visited.add(startState);
        if (startState.equals(targetState)) {
            dfaStates.add(targetState);
            return dfaStates;
        }
        for (int i = 0; i < startState.getNumberOfTransitions(); ++i) {
            List<DFAState> path;
            Transition e = startState.getTransition(i);
            if (visited.contains(e.target) || (path = this.getAnyDFAPathToTarget((DFAState)e.target, targetState, visited)) == null) continue;
            dfaStates.add(startState);
            dfaStates.addAll(path);
            return dfaStates;
        }
        return null;
    }

    public List<IntSet> getEdgeLabels(DFAState targetState) {
        List<DFAState> dfaStates = this.getAnyDFAPathToTarget(targetState);
        ArrayList<IntSet> labels = new ArrayList<IntSet>();
        for (int i = 0; i < dfaStates.size() - 1; ++i) {
            DFAState d = dfaStates.get(i);
            DFAState nextState = dfaStates.get(i + 1);
            for (int j = 0; j < d.getNumberOfTransitions(); ++j) {
                Transition e = d.getTransition(j);
                if (e.target.stateNumber != nextState.stateNumber) continue;
                labels.add(e.label.getSet());
            }
        }
        return labels;
    }

    public String getInputSequenceDisplay(Grammar g, List<IntSet> labels) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (IntSet label : labels) {
            tokens.add(label.toString(g));
        }
        return ((Object)tokens).toString();
    }

    public List<Token> getGrammarLocationsForInputSequence(List<Set<NFAState>> nfaStates, List<IntSet> labels) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        block0: for (int i = 0; i < nfaStates.size() - 1; ++i) {
            Set<NFAState> cur = nfaStates.get(i);
            Set<NFAState> next = nfaStates.get(i + 1);
            IntSet label = labels.get(i);
            for (NFAState p : cur) {
                for (int j = 0; j < p.getNumberOfTransitions(); ++j) {
                    Transition t = p.transition(j);
                    if (t.isEpsilon() || t.label.getSet().and(label).isNil() || !next.contains(t.target) || p.associatedASTNode == null) continue;
                    Token oldtoken = p.associatedASTNode.token;
                    CommonToken token = new CommonToken(oldtoken.getType(), oldtoken.getText());
                    token.setLine(oldtoken.getLine());
                    token.setCharPositionInLine(oldtoken.getCharPositionInLine());
                    tokens.add(token);
                    continue block0;
                }
            }
        }
        return tokens;
    }
}

