/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.ColorModelBuilder;
import org.apache.sis.image.internal.shared.ColorModelFactory;
import org.apache.sis.image.internal.shared.SampleModelBuilder;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.geotiff.DataCube;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.base.Compression;
import org.apache.sis.storage.geotiff.base.Predictor;
import org.apache.sis.storage.geotiff.base.Tags;
import org.apache.sis.storage.geotiff.reader.GridGeometryBuilder;
import org.apache.sis.storage.geotiff.reader.ImageMetadataBuilder;
import org.apache.sis.storage.geotiff.reader.Type;
import org.apache.sis.storage.modifier.CoverageModifier;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

final class ImageFileDirectory
extends DataCube {
    private static final byte TILE = 1;
    private static final byte STRIP = 2;
    private static final byte JPEG = 3;
    private static final byte SIGNED = 1;
    private static final byte UNSIGNED = 0;
    private static final byte FLOAT = 3;
    private static final int VISIBLE_BAND = 0;
    private final int index;
    private GenericName identifier;
    private ImageMetadataBuilder metadata;
    boolean hasDeferredEntries;
    private boolean isValidated;
    private int subfileType;
    private long imageWidth = -1L;
    private long imageHeight = -1L;
    private int tileWidth = -1;
    private int tileHeight = -1;
    private Vector tileOffsets;
    private Vector tileByteCounts;
    private byte tileTagFamily;
    private boolean isPlanar;
    private byte sampleFormat;
    private boolean isBitOrderReversed;
    private short bitsPerSample;
    private short samplesPerPixel;
    private Vector extraSamples;
    private byte photometricInterpretation = (byte)-1;
    private Vector colorMap;
    private Vector minValues;
    private Vector maxValues;
    private boolean isMinSpecified;
    private boolean isMaxSpecified;
    private double noData = Double.NaN;
    private Compression compression;
    private Predictor predictor;
    private GridGeometryBuilder referencing;
    private GridGeometry gridGeometry;
    private List<SampleDimension> sampleDimensions;
    private SampleModel sampleModel;
    private ColorModel colorModel;

    private GridGeometryBuilder referencing() {
        if (this.referencing == null) {
            this.referencing = new GridGeometryBuilder();
        }
        return this.referencing;
    }

    ImageFileDirectory(Reader reader, int index) {
        super(reader);
        this.index = index;
        this.metadata = new ImageMetadataBuilder();
    }

    private ChannelDataInput input() {
        return this.reader.input;
    }

    private Charset encoding() {
        return this.reader.store.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.identifier == null) {
                if (this.isReducedResolution()) {
                    return Optional.empty();
                }
                GenericName name = this.reader.store.createLocalName(String.valueOf(this.index + 1));
                name = name.toFullyQualifiedName();
                CoverageModifier.Source source = new CoverageModifier.Source((DataStore)this.reader.store, this.index, this.getDataType());
                this.identifier = this.reader.store.customizer.customize(source, name);
                if (this.identifier == null) {
                    this.identifier = name;
                }
            }
            return Optional.of(this.identifier);
        }
    }

    final void setOverviewIdentifier(NameSpace base, int overview) {
        this.identifier = this.reader.store.nameFactory.createLocalName(base, (CharSequence)("overview-" + overview));
    }

    Object addEntry(short tag, Type type, long count) throws Exception {
        block0 : switch (tag) {
            case 284: {
                int value = type.readAsInt(this.input(), count);
                switch (value) {
                    case 1: {
                        this.isPlanar = false;
                        break block0;
                    }
                    case 2: {
                        this.isPlanar = true;
                        break block0;
                    }
                }
                return value;
            }
            case 256: {
                this.imageWidth = type.readAsUnsignedLong(this.input(), count);
                break;
            }
            case 257: {
                this.imageHeight = type.readAsUnsignedLong(this.input(), count);
                break;
            }
            case 322: {
                this.setTileTagFamily((byte)1);
                this.tileWidth = type.readAsInt(this.input(), count);
                break;
            }
            case 323: {
                this.setTileTagFamily((byte)1);
                this.tileHeight = type.readAsInt(this.input(), count);
                break;
            }
            case 278: {
                this.setTileTagFamily((byte)2);
                this.tileHeight = type.readAsInt(this.input(), count);
                break;
            }
            case 324: {
                this.setTileTagFamily((byte)1);
                this.tileOffsets = type.readAsVector(this.input(), count);
                break;
            }
            case 273: {
                this.setTileTagFamily((byte)2);
                this.tileOffsets = type.readAsVector(this.input(), count);
                break;
            }
            case 325: {
                this.setTileTagFamily((byte)1);
                this.tileByteCounts = type.readAsVector(this.input(), count);
                break;
            }
            case 279: {
                this.setTileTagFamily((byte)2);
                this.tileByteCounts = type.readAsVector(this.input(), count);
                break;
            }
            case 513: {
                this.setTileTagFamily((byte)3);
                this.tileOffsets = type.readAsVector(this.input(), count);
                break;
            }
            case 514: {
                this.setTileTagFamily((byte)3);
                this.tileByteCounts = type.readAsVector(this.input(), count);
                break;
            }
            case 259: {
                int value = type.readAsInt(this.input(), count);
                this.compression = Compression.valueOf(value);
                if (this.compression != Compression.UNKNOWN) break;
                return value;
            }
            case 317: {
                int value = type.readAsInt(this.input(), count);
                this.predictor = Predictor.valueOf(value);
                if (this.predictor != Predictor.UNKNOWN) break;
                return value;
            }
            case 266: {
                int value = type.readAsInt(this.input(), count);
                switch (value) {
                    case 1: {
                        this.isBitOrderReversed = false;
                        break block0;
                    }
                    case 2: {
                        this.isBitOrderReversed = true;
                        break block0;
                    }
                }
                return value;
            }
            case 339: {
                int value = type.readAsInt(this.input(), count);
                switch (value) {
                    default: {
                        return value;
                    }
                    case 1: {
                        this.sampleFormat = 0;
                        break block0;
                    }
                    case 2: {
                        this.sampleFormat = 1;
                        break block0;
                    }
                    case 3: {
                        this.sampleFormat = (byte)3;
                        break block0;
                    }
                    case 4: 
                }
                this.warning(Level.WARNING, (short)25, this.filename());
                break;
            }
            case 258: {
                Vector values = type.readAsVector(this.input(), count);
                this.bitsPerSample = values.shortValue(0);
                int length = values.size();
                for (int i = 1; i < length; ++i) {
                    if (values.shortValue(i) == this.bitsPerSample) continue;
                    throw new DataStoreContentException(this.reader.resources().getString((short)3, "BitsPerSample", this.filename(), values));
                }
                break;
            }
            case 277: {
                this.samplesPerPixel = type.readAsShort(this.input(), count);
                break;
            }
            case 338: {
                this.extraSamples = type.readAsVector(this.input(), count);
                break;
            }
            case 262: {
                short value = type.readAsShort(this.input(), count);
                if (value < 0 || value > 127) {
                    return value;
                }
                this.photometricInterpretation = (byte)value;
                break;
            }
            case 320: {
                this.colorMap = type.readAsVector(this.input(), count);
                break;
            }
            case 280: 
            case 340: {
                this.minValues = ImageFileDirectory.extremum(this.minValues, type.readAsVector(this.input(), count), false);
                this.isMinSpecified = true;
                break;
            }
            case 281: 
            case 341: {
                this.maxValues = ImageFileDirectory.extremum(this.maxValues, type.readAsVector(this.input(), count), true);
                this.isMaxSpecified = true;
                break;
            }
            case 254: {
                this.subfileType = type.readAsInt(this.input(), count);
                break;
            }
            case 255: {
                int value = type.readAsInt(this.input(), count);
                switch (value) {
                    default: {
                        return value;
                    }
                    case 1: {
                        this.subfileType &= 0xFFFFFFFE;
                        break block0;
                    }
                    case 2: {
                        this.subfileType |= 1;
                        break block0;
                    }
                    case 3: 
                }
                this.subfileType |= 2;
                break;
            }
            case -30801: {
                this.referencing().keyDirectory = type.readAsVector(this.input(), count);
                break;
            }
            case -30800: {
                this.referencing().numericParameters = type.readAsVector(this.input(), count);
                break;
            }
            case -30799: {
                this.referencing().setAsciiParameters(type.readAsStrings(this.input(), count, this.encoding()));
                break;
            }
            case 274: {
                break;
            }
            case -31272: {
                int n;
                Vector m = type.readAsVector(this.input(), count);
                switch (m.size()) {
                    case 6: 
                    case 9: {
                        n = 3;
                        break;
                    }
                    case 12: 
                    case 16: {
                        n = 4;
                        break;
                    }
                    default: {
                        return m;
                    }
                }
                this.referencing().setGridToCRS(m, n);
                break;
            }
            case -31986: {
                Vector m = type.readAsVector(this.input(), count);
                int size = m.size();
                if (size < 2 || size > 3) {
                    return m;
                }
                this.referencing().setScaleFactors(m);
                break;
            }
            case -31614: {
                this.referencing().modelTiePoints = type.readAsVector(this.input(), count);
                break;
            }
            case 269: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.addSeries(value);
                }
                break;
            }
            case 285: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.addPage(value);
                }
                break;
            }
            case 297: {
                Vector v = type.readAsVector(this.input(), count);
                int n = v.size();
                if (n < 1) break;
                this.metadata.addPage(v.intValue(0), n >= 2 ? v.intValue(1) : 0);
                break;
            }
            case 270: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.addTitle(Strings.singleLine((String)" ", (CharSequence)value));
                }
                break;
            }
            case 315: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.addAuthor(value);
                }
                break;
            }
            case -32104: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.parseLegalNotice(null, value);
                }
                break;
            }
            case 306: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.addCitationDate(this.reader.store.getDateFormat().parse(value).toInstant(), DateType.CREATION, MetadataBuilder.Scope.RESOURCE);
                }
                break;
            }
            case 316: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.addHostComputer(value);
                }
                break;
            }
            case 305: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.addSoftwareReference(value);
                }
                break;
            }
            case 271: {
                break;
            }
            case 272: {
                for (String value : type.readAsStrings(this.input(), count, this.encoding())) {
                    this.metadata.addInstrument(null, value);
                }
                break;
            }
            case 282: 
            case 283: {
                this.metadata.setResolution(type.readAsDouble(this.input(), count));
                break;
            }
            case 296: {
                return this.metadata.setResolutionUnit(type.readAsInt(this.input(), count));
            }
            case 263: {
                return this.metadata.setThreshholding(type.readAsShort(this.input(), count));
            }
            case 264: 
            case 265: {
                this.metadata.setCellSize(type.readAsShort(this.input(), count), tag == 264);
                break;
            }
            case 288: 
            case 289: 
            case 290: 
            case 291: {
                this.warning(Level.FINE, (short)7, Tags.name(tag));
                break;
            }
            case -23424: 
            case -14627: {
                this.metadata.addXML(this.reader.readXML(type, count, tag));
                break;
            }
            case -23423: {
                this.noData = type.readAsDouble(this.input(), count);
            }
        }
        return null;
    }

    private void setTileTagFamily(byte family) throws DataStoreContentException {
        if (this.tileTagFamily != family && this.tileTagFamily != 0) {
            throw new DataStoreContentException(this.reader.resources().getString((short)8, this.filename()));
        }
        this.tileTagFamily = family;
    }

    private static Vector extremum(Vector a, Vector b, boolean max) {
        if (a != null) {
            int s = b.size();
            int i = a.size();
            if (i > s) {
                i = s;
                Vector t = a;
                a = b;
                b = t;
            }
            while (--i >= 0) {
                double va = a.doubleValue(i);
                double vb = b.doubleValue(i);
                if (!Double.isNaN(vb) && !(max ? va > vb : va < vb)) continue;
                b.set(i, (Number)va);
            }
        }
        return b;
    }

    private long pixelToByteCount(long value) {
        return (value = Math.multiplyExact(value, this.samplesPerPixel * this.bitsPerSample)) % 8L == 0L ? value / 8L : 0L;
    }

    private int computeTileSize(int knownSize) {
        int n = this.tileByteCounts.size();
        if (n != 0) {
            long count = this.tileByteCounts.longValue(0);
            int i = 0;
            do {
                if (++i != n) continue;
                long length = this.pixelToByteCount(knownSize);
                if (length == 0L || count % length != 0L) break;
                return Math.toIntExact(count / length);
            } while (this.tileByteCounts.longValue(i) == (long)n);
        }
        return -1;
    }

    final boolean validateMandatoryTags() throws DataStoreContentException {
        int actualCount;
        int missing;
        short byteCountsTag;
        short offsetsTag;
        if (this.isValidated) {
            return false;
        }
        if (this.imageWidth < 0L) {
            throw this.missingTag((short)256);
        }
        if (this.imageHeight < 0L) {
            throw this.missingTag((short)257);
        }
        switch (this.tileTagFamily) {
            case 2: 
            case 3: {
                if (this.tileWidth < 0) {
                    this.tileWidth = Math.toIntExact(this.imageWidth);
                }
                if (this.tileHeight < 0) {
                    this.tileHeight = Math.toIntExact(this.imageHeight);
                }
                offsetsTag = 273;
                byteCountsTag = 279;
                break;
            }
            case 1: {
                offsetsTag = 324;
                byteCountsTag = 325;
                break;
            }
            default: {
                throw new DataStoreContentException(this.reader.resources().getString((short)8, this.filename()));
            }
        }
        if (this.tileOffsets == null) {
            throw this.missingTag(offsetsTag);
        }
        if (this.samplesPerPixel == 0) {
            this.samplesPerPixel = 1;
            this.missingTag((short)277, 1, false, false);
        }
        if (this.bitsPerSample == 0) {
            this.bitsPerSample = 1;
            this.missingTag((short)258, 1, false, false);
        }
        if (this.colorMap != null) {
            this.ensureSameLength((short)320, (short)258, this.colorMap.size(), 3 * (1 << this.bitsPerSample));
        }
        if (this.sampleFormat != 3) {
            long maxValue;
            long minValue;
            if (this.sampleFormat == 0) {
                minValue = 0L;
                maxValue = -1L;
            } else {
                minValue = Long.MIN_VALUE;
                maxValue = Long.MAX_VALUE;
            }
            int shift = 64 - this.bitsPerSample;
            if (shift >= 0 && shift < 64 && (minValue >>>= shift) < (maxValue >>>= shift)) {
                this.minValues = ImageFileDirectory.extremum(this.minValues, Vector.createSequence((Number)minValue, (Number)0, (int)this.samplesPerPixel), false);
                this.maxValues = ImageFileDirectory.extremum(this.maxValues, Vector.createSequence((Number)maxValue, (Number)0, (int)this.samplesPerPixel), true);
            }
        }
        int n = missing = !this.isPlanar && this.compression.equals((Object)Compression.NONE) ? 0 : 8;
        if (this.tileWidth < 0) {
            missing |= 1;
        }
        if (this.tileHeight < 0) {
            missing |= 2;
        }
        if (this.tileByteCounts == null) {
            missing |= 4;
        }
        switch (missing) {
            case 0: 
            case 8: {
                break;
            }
            case 1: {
                this.tileWidth = this.computeTileSize(this.tileHeight);
                this.missingTag((short)322, this.tileWidth, true, true);
                break;
            }
            case 2: {
                this.tileHeight = this.computeTileSize(this.tileWidth);
                this.missingTag((short)323, this.tileHeight, true, true);
                break;
            }
            case 4: {
                long tileByteCount = this.pixelToByteCount(Math.multiplyExact(this.tileWidth, this.tileHeight));
                if (tileByteCount == 0L) {
                    throw this.missingTag(byteCountsTag);
                }
                long[] tileByteCountArray = new long[this.tileOffsets.size()];
                Arrays.fill(tileByteCountArray, tileByteCount);
                this.tileByteCounts = Vector.create((Object)tileByteCountArray, (boolean)true);
                this.missingTag(byteCountsTag, tileByteCount, true, true);
                break;
            }
            default: {
                short tag;
                switch (Integer.lowestOneBit(missing)) {
                    case 1: {
                        tag = 322;
                        break;
                    }
                    case 2: {
                        tag = 323;
                        break;
                    }
                    default: {
                        tag = byteCountsTag;
                    }
                }
                throw this.missingTag(tag);
            }
        }
        this.ensureSameLength(byteCountsTag, offsetsTag, this.tileByteCounts.size(), this.tileOffsets.size());
        long expectedCount = this.getNumTiles();
        if (this.isPlanar) {
            expectedCount = Math.multiplyExact(expectedCount, (int)this.samplesPerPixel);
        }
        if ((long)(actualCount = Math.min(this.tileOffsets.size(), this.tileByteCounts.size())) != expectedCount) {
            throw new DataStoreContentException(this.reader.resources().getString((short)18, this.filename(), expectedCount, actualCount));
        }
        if (this.referencing != null && !this.referencing.validateMandatoryTags()) {
            this.listeners.warning((Exception)this.missingTag((short)-31614));
        }
        this.isValidated = true;
        return true;
    }

    protected Metadata createMetadata() throws DataStoreException {
        ImageMetadataBuilder metadata = this.metadata;
        if (metadata == null) {
            return super.createMetadata();
        }
        this.metadata = null;
        CoverageModifier.Source source = this.source();
        if (source != null && metadata.getTitle() == null) {
            metadata.addTitle((CharSequence)Vocabulary.formatInternational((short)261, (Object)(this.index + 1)));
        }
        metadata.addIdentifier(this.getIdentifier().orElse(null), MetadataBuilder.Scope.RESOURCE);
        metadata.newCoverage(source != null && this.reader.store.customizer.isElectromagneticMeasurement(source));
        List<SampleDimension> sampleDimensions = this.getSampleDimensions();
        for (int band = 0; band < this.samplesPerPixel; ++band) {
            metadata.addNewBand(sampleDimensions.get(band));
            metadata.setBitPerSample(this.bitsPerSample);
            if (metadata.hasSampleValueRange()) continue;
            if (this.isMinSpecified) {
                metadata.addMinimumSampleValue(ImageFileDirectory.extremum(this.minValues, band).doubleValue());
            }
            if (!this.isMaxSpecified) continue;
            metadata.addMaximumSampleValue(ImageFileDirectory.extremum(this.maxValues, band).doubleValue());
        }
        if (this.referencing != null) {
            GridGeometry gridGeometry = this.getGridGeometry();
            if (gridGeometry.isDefined(2)) {
                metadata.addExtent(gridGeometry.getEnvelope(), this.listeners);
            }
            this.referencing.completeMetadata(gridGeometry, metadata);
        }
        if (this.reader.store.hidden) {
            this.reader.store.setFormatInfo(metadata);
        }
        if (this.compression != null) {
            metadata.addCompression(CharSequences.upperCaseToSentence((CharSequence)this.compression.name()));
        }
        metadata.finish(this.reader.store, this.listeners);
        DefaultMetadata md = metadata.build();
        return source != null ? this.reader.store.customizer.customize(source, md) : md;
    }

    final boolean isReducedResolution() {
        return (this.subfileType & 1) != 0;
    }

    final void initReducedResolution(ImageFileDirectory fullResolution, double[] scales) throws DataStoreException, TransformException {
        if (this.referencing == null) {
            this.gridGeometry = new GridGeometry(fullResolution.getGridGeometry(), this.getExtent(), (MathTransform)MathTransforms.scale((double[])scales));
        }
        if (this.samplesPerPixel == fullResolution.samplesPerPixel) {
            this.sampleDimensions = fullResolution.getSampleDimensions();
        }
    }

    private CoverageModifier.Source source() {
        return this.isReducedResolution() ? null : new CoverageModifier.Source((DataStore)this.reader.store, this.index, this.getDataType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGeometry getGridGeometry() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            GridGeometry domain = this.gridGeometry;
            if (domain == null) {
                if (this.referencing != null) {
                    try {
                        domain = this.referencing.build(this.reader.store.listeners(), this.imageWidth, this.imageHeight);
                    }
                    catch (FactoryException e) {
                        throw new DataStoreContentException(this.reader.resources().getString((short)26, this.filename()), (Throwable)e);
                    }
                } else {
                    domain = new GridGeometry(this.getExtent(), null, null);
                }
                CoverageModifier.Source source = this.source();
                this.gridGeometry = source != null ? this.reader.store.customizer.customize(source, domain) : domain;
            }
            return domain;
        }
    }

    final GridExtent getExtent() {
        return new GridExtent(this.imageWidth, this.imageHeight);
    }

    private Optional<NumberRange<?>> getValidValues(int band, double exclude) {
        Number max;
        Number min = ImageFileDirectory.extremum(this.minValues, band);
        if (min != null && (max = ImageFileDirectory.extremum(this.maxValues, band)) != null) {
            return Optional.of(NumberRange.createBestFit((this.sampleFormat == 3 ? 1 : 0) != 0, (Number)min, (min.doubleValue() != exclude ? 1 : 0) != 0, (Number)max, (max.doubleValue() != exclude ? 1 : 0) != 0));
        }
        return Optional.empty();
    }

    private static Number extremum(Vector values, int band) {
        return values == null ? (Number)null : (Number)values.get(Math.min(band, values.size() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.sampleDimensions == null) {
                Number fill = this.sampleFormat != 3 ? (Number)this.getFillValue(true) : (Number)null;
                DataType dataType = this.getDataType();
                Object[] dimensions = new SampleDimension[this.samplesPerPixel];
                SampleDimension.Builder builder = new SampleDimension.Builder();
                boolean isIndexValid = !this.isReducedResolution();
                for (int band = 0; band < dimensions.length; ++band) {
                    SampleDimension sd;
                    Optional<NumberRange<?>> sampleRange;
                    short nameKey = 0;
                    block2 : switch (this.photometricInterpretation) {
                        case 0: 
                        case 1: {
                            nameKey = 250;
                            break;
                        }
                        case 3: {
                            nameKey = 30;
                            break;
                        }
                        case 2: {
                            switch (band) {
                                case 0: {
                                    nameKey = 167;
                                    break block2;
                                }
                                case 1: {
                                    nameKey = 96;
                                    break block2;
                                }
                                case 2: {
                                    nameKey = 18;
                                }
                            }
                        }
                    }
                    if (nameKey != 0) {
                        builder.setName((CharSequence)Vocabulary.formatInternational((short)nameKey));
                    } else {
                        builder.setName(band + 1);
                    }
                    if (fill != null) {
                        builder.setBackground(fill);
                        sampleRange = this.getValidValues(band, fill.doubleValue());
                        sampleRange.ifPresent(range -> {
                            if (!range.containsAny(fill)) {
                                builder.addQuantitative(null, range, null, null);
                                builder.addQualitative(null, fill, fill);
                            }
                        });
                    } else {
                        sampleRange = null;
                    }
                    if (isIndexValid) {
                        CoverageModifier.BandSource source = new CoverageModifier.BandSource(this, this.reader.store, this.index, band, this.samplesPerPixel, dataType){
                            final /* synthetic */ ImageFileDirectory this$0;
                            {
                                this.this$0 = this$0;
                                super(store, coverageIndex, bandIndex, numBands, dataType);
                            }

                            public Optional<NumberRange<?>> getSampleRange() {
                                if (sampleRange != null) {
                                    return sampleRange;
                                }
                                return this.this$0.getValidValues(this.getBandIndex(), Double.NaN);
                            }
                        };
                        sd = this.reader.store.customizer.customize(source, builder);
                    } else {
                        sd = builder.build();
                    }
                    dimensions[band] = sd;
                    builder.clear();
                }
                this.sampleDimensions = UnmodifiableArrayList.wrap((Object[])dimensions);
            }
            return this.sampleDimensions;
        }
    }

    protected SampleModel getSampleModel(int[] bands) throws DataStoreContentException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        if (bands != null) {
            return null;
        }
        if (this.sampleModel == null) {
            RuntimeException error = null;
            DataType type = this.getDataType();
            if (type != null) {
                try {
                    Dimension size = new Dimension(this.tileWidth, this.tileHeight);
                    int[] numBits = new int[this.samplesPerPixel];
                    Arrays.fill(numBits, (int)this.bitsPerSample);
                    this.sampleModel = new SampleModelBuilder(type, size, numBits, this.isPlanar).build();
                }
                catch (RasterFormatException | IllegalArgumentException e) {
                    error = e;
                }
            }
            if (this.sampleModel == null) {
                Object message = type;
                if (message == null) {
                    String format;
                    switch (this.sampleFormat) {
                        case 1: {
                            format = "int";
                            break;
                        }
                        case 0: {
                            format = "unsigned";
                            break;
                        }
                        case 3: {
                            format = "float";
                            break;
                        }
                        default: {
                            format = "unknown";
                        }
                    }
                    message = format + " " + this.bitsPerSample + " bits";
                }
                throw new DataStoreContentException(Errors.format((short)200, (Object)message), (Throwable)error);
            }
        }
        return this.sampleModel;
    }

    @Override
    final long getScanlineStride(int pixelStride) {
        return Math.multiplyFull(pixelStride, this.tileWidth);
    }

    @Override
    protected int getNumBands() {
        return this.samplesPerPixel;
    }

    protected int[] getTileSize() {
        return new int[]{this.tileWidth, this.tileHeight};
    }

    @Override
    final long getNumTiles() {
        return Math.multiplyExact(JDK18.ceilDiv((long)this.imageWidth, (long)this.tileWidth), JDK18.ceilDiv((long)this.imageHeight, (long)this.tileHeight));
    }

    private DataType getDataType() {
        switch (this.sampleFormat) {
            case 1: {
                if (this.bitsPerSample < 8) {
                    return DataType.BYTE;
                }
                if (this.bitsPerSample <= 16) {
                    return DataType.SHORT;
                }
                if (this.bitsPerSample > 32) break;
                return DataType.INT;
            }
            case 0: {
                if (this.bitsPerSample <= 8) {
                    return DataType.BYTE;
                }
                if (this.bitsPerSample <= 16) {
                    return DataType.USHORT;
                }
                if (this.bitsPerSample > 32) break;
                return DataType.UINT;
            }
            case 3: {
                if (this.bitsPerSample == 32) {
                    return DataType.FLOAT;
                }
                if (this.bitsPerSample != 64) break;
                return DataType.DOUBLE;
            }
        }
        return null;
    }

    protected ColorModel getColorModel(int[] bands) throws DataStoreContentException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        if (bands != null) {
            return null;
        }
        if (this.colorModel == null) {
            int alphaBand = -1;
            boolean isAlphaPremultiplied = false;
            if (this.extraSamples != null) {
                int n = this.extraSamples.size();
                block11: for (int i = 0; i < n; ++i) {
                    switch (this.extraSamples.intValue(i)) {
                        case 1: {
                            isAlphaPremultiplied = true;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            continue block11;
                        }
                    }
                    alphaBand = i;
                    break;
                }
            }
            short missing = 0;
            switch (this.photometricInterpretation) {
                default: {
                    this.unsupportedTagValue((short)262, this.photometricInterpretation);
                    break;
                }
                case -1: {
                    missing = 262;
                    break;
                }
                case 0: {
                    this.createSingleBandColorModel(Color.WHITE, Color.BLACK);
                    break;
                }
                case 1: {
                    this.createSingleBandColorModel(Color.BLACK, Color.WHITE);
                    break;
                }
                case 2: {
                    if (alphaBand >= 0) {
                        alphaBand += 3;
                    }
                    ColorModelBuilder builder = new ColorModelBuilder().bitsPerSample((int)this.bitsPerSample).alphaBand(alphaBand).alphaPremultiplied(isAlphaPremultiplied);
                    if (this.getSampleModel(null) instanceof SinglePixelPackedSampleModel) {
                        this.colorModel = builder.createPackedRGB();
                        break;
                    }
                    this.colorModel = builder.createBandedRGB();
                    break;
                }
                case 3: {
                    if (this.colorMap == null) {
                        missing = 320;
                        break;
                    }
                    int gi = this.colorMap.size() / 3;
                    int bi = gi * 2;
                    int[] ARGB = new int[gi];
                    for (int i = 0; i < ARGB.length; ++i) {
                        ARGB[i] = 0xFF000000 | (this.colorMap.intValue(i) & 0xFF00) << 8 | this.colorMap.intValue(gi++) & 0xFF00 | (this.colorMap.intValue(bi++) & 0xFF00) >>> 8;
                    }
                    int transparent = Double.isFinite(this.noData) ? (int)Math.round(this.noData) : -1;
                    this.colorModel = ColorModelFactory.createIndexColorModel(null, (int)0, (int)this.samplesPerPixel, (int)0, (int[])ARGB, (boolean)true, (int)transparent);
                    break;
                }
            }
            if (missing != 0) {
                this.missingTag(missing, "GrayScale", false, true);
            }
            if (this.colorModel == null) {
                this.createSingleBandColorModel(Color.BLACK, Color.WHITE);
            }
        }
        return this.colorModel;
    }

    private void createSingleBandColorModel(Color zero, Color high) throws DataStoreContentException {
        double min = 0.0;
        double max = Numerics.bitmask((int)this.bitsPerSample);
        switch (this.sampleFormat) {
            default: {
                break;
            }
            case 3: {
                max = 1.0;
                break;
            }
            case 1: {
                min = -(max /= 2.0);
            }
        }
        if (this.minValues != null) {
            min = Math.max(min, this.minValues.doubleValue(0));
        }
        if (this.maxValues != null) {
            max = Math.min(max, this.maxValues.doubleValue(0) + 1.0);
        }
        this.colorModel = ColorModelFactory.createColorScale((int)this.getSampleModel(null).getDataType(), (int)this.samplesPerPixel, (int)0, (double)min, (double)max, (Color[])new Color[]{zero, high});
    }

    @Override
    Number getReplaceableFillValue() {
        return this.sampleFormat == 3 ? Double.valueOf(this.noData) : null;
    }

    protected Number[] getFillValues(int[] bands) {
        Number fill;
        if (this.sampleFormat == 3) {
            fill = Double.NaN;
        } else {
            fill = this.getFillValue(false);
            if (fill == null) {
                return null;
            }
        }
        Object[] values = new Number[bands != null ? bands.length : this.getNumBands()];
        Arrays.fill(values, fill);
        return values;
    }

    private Number getFillValue(boolean acceptZero) {
        if (Double.isFinite(this.noData) && (acceptZero || this.noData != 0.0)) {
            long min;
            long max;
            switch (this.sampleFormat) {
                case 0: {
                    max = 1L << this.bitsPerSample;
                    min = 0L;
                    break;
                }
                case 1: {
                    max = 1L << this.bitsPerSample - 1;
                    min = max ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                default: {
                    return this.noData;
                }
            }
            long value = Math.round(this.noData);
            if (value >= min && value <= max && (acceptZero || value != 0L)) {
                return Numbers.narrowestNumber((Number)value);
            }
        }
        return null;
    }

    @Override
    Vector getTileArrayInfo(boolean length) {
        return length ? this.tileByteCounts : this.tileOffsets;
    }

    @Override
    boolean isBitOrderReversed() {
        return this.isBitOrderReversed;
    }

    @Override
    Compression getCompression() {
        return this.compression;
    }

    @Override
    Predictor getPredictor() {
        return this.predictor != null ? this.predictor : Predictor.NONE;
    }

    private void warning(Level level, short key, Object ... parameters) {
        LogRecord record = this.reader.resources().createLogRecord(level, key, parameters);
        record.setSourceClassName(GeoTiffStore.class.getName());
        record.setSourceMethodName("components()");
        this.listeners.warning(record);
    }

    private void ensureSameLength(short tag1, short tag2, int actual, int expected) {
        if (actual != expected) {
            this.warning(Level.WARNING, (short)11, Tags.name(tag1), Tags.name(tag2), actual, expected);
        }
    }

    private void missingTag(short missing, Object value, boolean computed, boolean warning) {
        this.warning(warning ? Level.WARNING : Level.FINE, computed ? (short)2 : 4, Tags.name(missing), value);
    }

    private void unsupportedTagValue(short tag, Object value) {
        this.warning(Level.WARNING, (short)29, Tags.name(tag), value);
    }

    private DataStoreContentException missingTag(short missing) {
        return new DataStoreContentException(this.reader.resources().getString((short)13, this.filename(), Tags.name(missing)));
    }
}

