/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SeekableByteChannel;
import org.apache.sis.io.stream.Markable;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelData
implements Markable {
    static final int BIT_OFFSET_SIZE = 3;
    public final String filename;
    public final ByteBuffer buffer;
    private long channelOffset;
    long bufferOffset;
    long bitPosition;
    private Mark mark;

    ChannelData(String filename, Channel channel, ByteBuffer buffer) throws IOException {
        this.filename = filename;
        this.buffer = buffer;
        if (channel instanceof SeekableByteChannel) {
            this.channelOffset = ((SeekableByteChannel)channel).position();
        }
    }

    ChannelData(ChannelData other, ByteBuffer buffer, boolean replacing) {
        this.filename = other.filename;
        this.channelOffset = other.channelOffset;
        this.bufferOffset = other.bufferOffset;
        this.bitPosition = other.bitPosition;
        this.buffer = buffer;
        if (replacing) {
            this.mark = other.mark;
        }
    }

    ChannelData(String filename, ByteBuffer data) {
        this.filename = filename;
        this.buffer = data.asReadOnlyBuffer();
        this.buffer.order(data.order());
    }

    public abstract Channel channel();

    public final long length() throws IOException {
        long length;
        Channel channel = this.channel();
        if (channel instanceof SeekableByteChannel && (length = Math.subtractExact(((SeekableByteChannel)channel).size(), this.channelOffset)) >= 0L) {
            return Math.max(length, Math.addExact(this.bufferOffset, (long)this.buffer.limit()));
        }
        return -1L;
    }

    public final int getBitOffset() {
        if (this.bitPosition >>> 3 == this.bufferOffset + (long)this.buffer.position()) {
            return (int)(this.bitPosition & 7L);
        }
        this.bitPosition = 0L;
        return 0;
    }

    public final void setBitOffset(int bitOffset) {
        ArgumentChecks.ensureBetween((String)"bitOffset", (int)0, (int)7, (int)bitOffset);
        this.bitPosition = this.position() << 3 | (long)bitOffset;
    }

    public abstract void skipRemainingBits();

    @Override
    public abstract long getStreamPosition();

    final long position() {
        return Math.addExact(this.bufferOffset, (long)this.buffer.position());
    }

    public final long getFlushedPosition() {
        return this.bufferOffset;
    }

    public final void flushBefore(long position) throws IOException {
        long currentPosition = this.getStreamPosition();
        if (position > currentPosition) {
            throw new IndexOutOfBoundsException(Errors.format((short)204, (Object)"position", (Object)this.bufferOffset, (Object)currentPosition, (Object)position));
        }
        if (this.buffer.isReadOnly()) {
            return;
        }
        long count = Math.subtractExact(position, this.bufferOffset);
        if (count > 0L) {
            this.flushNBytes((int)Math.min(count, (long)this.buffer.limit()));
        }
        Mark lastValid = null;
        Mark m = this.mark;
        while (m != null) {
            if (m.position >= position) {
                lastValid = m;
            }
            m = m.next;
        }
        if (lastValid != null) {
            lastValid.next = null;
        } else {
            this.mark = null;
        }
    }

    abstract void flushNBytes(int var1) throws IOException;

    public abstract void seek(long var1) throws IOException;

    @Override
    public final void mark() {
        this.mark = new Mark(this.position(), (byte)this.getBitOffset(), this.mark);
    }

    @Override
    public final void reset() throws IOException {
        Mark m = this.mark;
        if (m == null) {
            throw new IOException(Resources.format((short)63));
        }
        this.mark = m.next;
        this.seek(m.position);
        this.setBitOffset(m.bitOffset);
    }

    @Override
    public final void reset(long position) throws IOException {
        Mark lastValid = null;
        while (this.mark != null && this.mark.position >= position) {
            boolean found;
            boolean bl = found = this.mark.position == position;
            if (found) {
                lastValid = this.mark;
            }
            this.mark = this.mark.next;
            if (!found) continue;
            break;
        }
        this.seek(position);
        if (lastValid != null) {
            this.setBitOffset(lastValid.bitOffset);
        }
    }

    public final boolean rewind() throws IOException {
        Channel channel = this.channel();
        if (channel instanceof SeekableByteChannel) {
            ((SeekableByteChannel)channel).position(this.channelOffset);
            this.buffer.clear().limit(0);
            this.bufferOffset = 0L;
            this.bitPosition = 0L;
            this.mark = null;
            return true;
        }
        return false;
    }

    final void copyTo(ChannelData takeOver) {
        assert (takeOver.channel() == this.channel());
        takeOver.bufferOffset = this.bufferOffset;
        takeOver.channelOffset = this.channelOffset;
        takeOver.bitPosition = this.bitPosition;
        takeOver.mark = this.mark;
        this.mark = null;
    }

    public final void refresh(long position) {
        this.buffer.limit(0);
        this.bufferOffset = position;
        this.bitPosition = 0L;
        this.mark = null;
    }

    public final void relocateOrigin() {
        long position = this.getStreamPosition();
        this.channelOffset = this.toSeekableByteChannelPosition(position);
        this.bufferOffset = Math.subtractExact(this.bufferOffset, position);
    }

    final long toSeekableByteChannelPosition(long position) {
        return Math.addExact(this.channelOffset, position);
    }

    final void moveBufferForward(int count) {
        this.bufferOffset = Math.addExact(this.bufferOffset, (long)count);
    }

    protected void onEmptyTransfer() throws IOException {
        if (this.buffer.capacity() == 0) {
            throw new IOException(Errors.format((short)177, (Object)"buffer"));
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append(this.getClass().getSimpleName()).append("[\u201c").append(this.filename).append('\u201d');
        if (this.buffer != null) {
            b.append(" at ").append(this.getStreamPosition());
        }
        return b.append(']').toString();
    }

    private static final class Mark {
        final long position;
        final byte bitOffset;
        Mark next;

        Mark(long position, byte bitOffset, Mark next) {
            this.position = position;
            this.bitOffset = bitOffset;
            this.next = next;
        }
    }
}

