/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.ImagingOpException;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.sis.image.ErrorHandler;

enum ErrorAction implements ErrorHandler
{
    THROW,
    LOG;


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ErrorHandler.Report details) {
        ErrorHandler.Report report = details;
        synchronized (report) {
            LogRecord record = details.getDescription();
            if (record != null) {
                if (this == LOG) {
                    String loggerName = record.getLoggerName();
                    if (loggerName == null) {
                        loggerName = "org.apache.sis.raster";
                        record.setLoggerName(loggerName);
                    }
                    Logger.getLogger(loggerName).log(record);
                } else {
                    Throwable ex = record.getThrown();
                    if (ex instanceof Error) {
                        throw (Error)ex;
                    }
                    if (ex instanceof ImagingOpException) {
                        throw (ImagingOpException)ex;
                    }
                    String message = new SimpleFormatter().formatMessage(record);
                    throw (ImagingOpException)new ImagingOpException(message).initCause(ex);
                }
            }
        }
    }
}

