/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Objects;
import org.apache.sis.image.MultiSourcePrefetch;
import org.apache.sis.image.WritableComputedImage;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.util.Disposable;

abstract class MultiSourceImage
extends WritableComputedImage {
    private final ColorModel colorModel;
    private final int minX;
    private final int minY;
    private final int width;
    private final int height;
    private final int minTileX;
    private final int minTileY;
    final boolean parallel;

    MultiSourceImage(RenderedImage[] sources, Rectangle bounds, Point minTile, SampleModel sampleModel, ColorModel colorModel, boolean parallel) {
        super(sampleModel, sources);
        this.colorModel = colorModel;
        this.minX = bounds.x;
        this.minY = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
        this.minTileX = minTile.x;
        this.minTileY = minTile.y;
        this.parallel = parallel;
        MultiSourceImage.ensureCompatible(sampleModel, colorModel);
    }

    @Override
    public final ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getMinX() {
        return this.minX;
    }

    @Override
    public final int getMinY() {
        return this.minY;
    }

    @Override
    public final int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public final int getMinTileY() {
        return this.minTileY;
    }

    final Point tileToPixel(int tileX, int tileY) {
        return new Point(Math.toIntExact(((long)tileX - (long)this.minTileX) * (long)this.getTileWidth() + (long)this.minX), Math.toIntExact(((long)tileY - (long)this.minTileY) * (long)this.getTileHeight() + (long)this.minY));
    }

    @Override
    protected Disposable prefetch(Rectangle tiles) {
        Rectangle aoi = ImageUtilities.tilesToPixels(this, tiles);
        return new MultiSourcePrefetch(this.getSourceArray(), aoi).run(this.parallel);
    }

    public int hashCode() {
        return this.hashCodeBase() + 37 * Objects.hashCode(this.colorModel);
    }

    public boolean equals(Object object) {
        if (this.equalsBase(object)) {
            MultiSourceImage other = (MultiSourceImage)object;
            return this.parallel == other.parallel && this.minTileX == other.minTileX && this.minTileY == other.minTileY && this.getBounds().equals(other.getBounds()) && Objects.equals(this.colorModel, other.colorModel);
        }
        return false;
    }
}

