/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.net.URI;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.coordinate.DefaultCoordinateMetadata;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.MathTransformParser;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.io.wkt.VerticalInfo;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.pending.geoapi.referencing.MissingMethods;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.internal.Epoch;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.internal.PositionalAccuracyConstant;
import org.apache.sis.referencing.internal.VerticalDatumTypes;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.EllipsoidalHeightCombiner;
import org.apache.sis.referencing.internal.shared.ReferencingFactoryContainer;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

class GeodeticObjectParser
extends MathTransformParser
implements Comparator<CoordinateSystemAxis> {
    private static final String[] ToWGS84;
    private static final String[] UNIT_SYMBOLS_TO_IGNORE;
    private final boolean usesCommonUnits;
    private final boolean ignoreAxes;
    private final Transliterator transliterator;
    private final Map<String, Object> properties = new HashMap<String, Object>(4);
    private final Map<CoordinateSystemAxis, Integer> axisOrder = new IdentityHashMap<CoordinateSystemAxis, Integer>(4);
    private transient VerticalCRS verticalCRS;
    private transient VerticalInfo verticalElements;

    public GeodeticObjectParser(Map<String, ?> defaultProperties, ObjectFactory factories, MathTransformFactory mtFactory) {
        super(null, Collections.emptyMap(), Symbols.getDefault(), null, null, null, new ReferencingFactoryContainer(defaultProperties, (CRSFactory)factories, (CSFactory)factories, (DatumFactory)factories, null, mtFactory), (Locale)defaultProperties.get("locale"));
        this.transliterator = Transliterator.DEFAULT;
        this.usesCommonUnits = false;
        this.ignoreAxes = false;
    }

    GeodeticObjectParser(URI sourceFile, Map<String, StoredTree> fragments, Symbols symbols, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Convention convention, Transliterator transliterator, Locale errorLocale, ReferencingFactoryContainer factories) {
        super(sourceFile, fragments, symbols, numberFormat, dateFormat, unitFormat, factories, errorLocale);
        this.transliterator = transliterator;
        this.usesCommonUnits = convention.usesCommonUnits();
        this.ignoreAxes = convention == Convention.WKT1_IGNORE_AXES;
    }

    @Override
    String getPublicFacade() {
        return "org.apache.sis.referencing.factory.GeodeticObjectFactory";
    }

    void completeRoot(Map<String, Object> properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final Object createFromWKT(String text, ParsePosition position) throws ParseException {
        Object object;
        block10: {
            try {
                object = super.createFromWKT(text, position);
                if (this.verticalElements == null) break block10;
                Throwable ex = null;
                try {
                    this.verticalElements = this.verticalElements.resolve(CommonCRS.Vertical.MEAN_SEA_LEVEL.crs());
                }
                catch (UnsupportedOperationException e) {
                    ex = e;
                }
                if (this.verticalElements != null) {
                    try {
                        this.verticalElements = this.verticalElements.complete(this.factories.getCRSFactory(), this.factories.getCSFactory());
                    }
                    catch (FactoryException e) {
                        if (ex == null) {
                            ex = e;
                        }
                        ex.addSuppressed(e);
                    }
                }
                if (this.verticalElements != null) {
                    this.warning(null, (String)null, Errors.formatInternational((short)6, (Object[])new Object[]{"VerticalExtent", this.verticalElements.unit}), (Exception)ex);
                }
            }
            finally {
                this.verticalElements = null;
                this.verticalCRS = null;
                this.axisOrder.clear();
                this.properties.clear();
            }
        }
        return object;
    }

    private static PrimeMeridian greenwich() {
        return CommonCRS.WGS84.primeMeridian();
    }

    @Override
    final Object buildFromTree(Element element) throws ParseException {
        Object object = this.parseCoordinateReferenceSystem(element, false);
        if (null == object && null == (object = this.parseCoordinateMetadata(0, element)) && null == (object = this.parseOperation(0, element)) && null == (object = this.parseMathTransform(element, false)) && null == (object = this.parseEnsemble(0, element, GeodeticObjectParser.greenwich(), Datum.class)) && null == (object = this.parseDatum(0, element, GeodeticObjectParser.greenwich(), null)) && null == (object = this.parseVerticalDatum(0, element, null, false)) && null == (object = this.parseTimeDatum(0, element)) && null == (object = this.parseParametricDatum(0, element)) && null == (object = this.parseEngineeringDatum(0, element, false)) && null == (object = this.parseImageDatum(0, element)) && null == (object = this.parseEllipsoid(0, element)) && null == (object = this.parsePrimeMeridian(0, element, false, (Unit<Angle>)Units.DEGREE)) && null == (object = this.parseAxis(0, element, null, Units.METRE)) && null == (object = this.parseToWGS84(0, element)) && null == (object = this.parseGeogTranslation(0, element))) {
            throw element.missingOrUnknownComponent("GeodeticCRS");
        }
        return object;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element, boolean mandatory) throws ParseException {
        SingleCRS crs = this.parseGeodeticCRS(0, element, 2, null);
        if (crs == null && (crs = this.parseProjectedCRS(0, element, false)) == null && (crs = this.parseVerticalCRS(0, element, false)) == null && (crs = this.parseTimeCRS(0, element, false)) == null && (crs = this.parseParametricCRS(0, element, false)) == null && (crs = this.parseEngineeringCRS(0, element, false)) == null && (crs = this.parseImageCRS(0, element)) == null && (crs = this.parseCompoundCRS(0, element)) == null && (crs = this.parseFittedCS(0, element)) == null && mandatory) {
            throw element.missingOrUnknownComponent("GeodeticCRS");
        }
        return crs;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element parent, int mode, String keyword) throws ParseException {
        Element element = parent.pullElement(mode, keyword);
        if (element == null) {
            return null;
        }
        CoordinateReferenceSystem crs = this.parseCoordinateReferenceSystem(element, true);
        element.close(this.ignoredElements);
        return crs;
    }

    private DefaultCoordinateMetadata parseCoordinateMetadata(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "CoordinateMetadata");
        if (element == null) {
            return null;
        }
        CoordinateReferenceSystem crs = this.parseCoordinateReferenceSystem(element, true);
        Temporal epoch = this.parseEpoch(1, element, "Epoch");
        element.close(this.ignoredElements);
        return new DefaultCoordinateMetadata(crs, epoch);
    }

    private static Identifier toIdentifier(Object identifier) {
        return identifier instanceof Identifier[] ? ((Identifier[])identifier)[0] : (Identifier)identifier;
    }

    private Map<String, Object> parseMetadataAndClose(Element parent, String name, IdentifiedObject fallback) throws ParseException {
        DefaultExtent extent;
        String scope;
        Element element;
        this.properties.clear();
        this.properties.put("name", name.isEmpty() && fallback != null ? fallback.getName() : name);
        while ((element = parent.pullElement(1, ID_KEYWORDS)) != null) {
            String authority;
            String codeSpace = element.pullString("codeSpace");
            String code = element.pullObject("code").toString();
            Object version = element.pullOptional(Object.class);
            Element citation = element.pullElement(1, "Citation");
            if (citation != null) {
                authority = citation.pullString("authority");
                citation.close(this.ignoredElements);
            } else {
                authority = codeSpace;
            }
            Element uri = element.pullElement(1, "URI");
            if (uri != null) {
                uri.pullString("URI");
                uri.close(this.ignoredElements);
            }
            element.close(this.ignoredElements);
            ImmutableIdentifier id = new ImmutableIdentifier(Citations.fromName((String)authority), codeSpace, code, version != null ? version.toString() : null, null);
            this.properties.merge("identifiers", id, (previous, toAdd) -> {
                ReferenceIdentifier more = (ReferenceIdentifier)toAdd;
                if (previous instanceof ReferenceIdentifier) {
                    return new ReferenceIdentifier[]{(ReferenceIdentifier)previous, more};
                }
                return ArraysExt.append((Object[])((ReferenceIdentifier[])previous), (Object)more);
            });
        }
        ArrayList<DefaultObjectDomain> domains = new ArrayList<DefaultObjectDomain>();
        while ((element = parent.pullElement(1, "Usage")) != null) {
            scope = this.pullElementAsString(element, "Scope");
            extent = this.parseExtent(element);
            if (scope != null || extent != null) {
                domains.add(new DefaultObjectDomain(Types.toInternationalString((CharSequence)scope), (Extent)extent));
            }
            element.close(this.ignoredElements);
        }
        if (domains.isEmpty()) {
            scope = this.pullElementAsString(parent, "Scope");
            if (scope != null) {
                this.properties.put("scope", scope);
            }
            if ((extent = this.parseExtent(parent)) != null) {
                this.properties.put("domainOfValidity", extent);
            }
        } else {
            this.properties.put("domains", domains.toArray(DefaultObjectDomain[]::new));
        }
        element = parent.pullElement(1, "Remark");
        if (element != null) {
            this.properties.put("remarks", element.pullString("remarks"));
            element.close(this.ignoredElements);
        }
        parent.close(this.ignoredElements);
        if (parent.isRoot) {
            this.completeRoot(this.properties);
        }
        return this.properties;
    }

    private DefaultExtent parseExtent(Element parent) throws ParseException {
        Element element;
        DefaultExtent extent = null;
        while ((element = parent.pullElement(1, "Area")) != null) {
            String area = element.pullString("area");
            element.close(this.ignoredElements);
            if (extent == null) {
                extent = new DefaultExtent((CharSequence)area, null, null, null);
                continue;
            }
            extent.setDescription(Types.toInternationalString((CharSequence)area));
        }
        while ((element = parent.pullElement(1, "BBox")) != null) {
            double southBoundLatitude = element.pullDouble("southBoundLatitude");
            double westBoundLongitude = element.pullDouble("westBoundLongitude");
            double northBoundLatitude = element.pullDouble("northBoundLatitude");
            double eastBoundLongitude = element.pullDouble("eastBoundLongitude");
            element.close(this.ignoredElements);
            if (extent == null) {
                extent = new DefaultExtent();
            }
            extent.getGeographicElements().add(new DefaultGeographicBoundingBox(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude));
        }
        while ((element = parent.pullElement(1, "VerticalExtent")) != null) {
            double minimum = element.pullDouble("minimum");
            double maximum = element.pullDouble("maximum");
            Unit unit = this.parseScaledUnit(element, "LengthUnit", Units.METRE);
            element.close(this.ignoredElements);
            if (unit == null) {
                unit = Units.METRE;
            }
            if (extent == null) {
                extent = new DefaultExtent();
            }
            this.verticalElements = new VerticalInfo(this.verticalElements, extent, minimum, maximum, (Unit<Length>)unit).resolve(this.verticalCRS);
        }
        while ((element = parent.pullElement(1, "TimeExtent")) != null) {
            if (element.peekValue() instanceof String) {
                element.pullString("startTime");
                element.pullString("endTime");
                element.close(this.ignoredElements);
                this.warning(parent, element, Errors.formatInternational((short)200, (Object)"TimeExtent[String,String]"), null);
                continue;
            }
            Temporal startTime = element.pullTime("startTime");
            Temporal endTime = element.pullTime("endTime");
            element.close(this.ignoredElements);
            DefaultTemporalExtent t = new DefaultTemporalExtent(startTime, endTime);
            if (extent == null) {
                extent = new DefaultExtent();
            }
            extent.getTemporalElements().add(t);
        }
        return extent;
    }

    private <Q extends Quantity<Q>> Unit<Q> parseScaledUnit(Element parent, String keyword, Unit<Q> baseUnit) throws ParseException {
        Element element = parent.pullElement(1, keyword, "Unit");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        double factor = element.pullDouble("factor");
        Object[] unitID = new Object[2];
        Unit<?> byID = this.parseUnitID(element, unitID);
        Unit unit = baseUnit.multiply(GeodeticObjectParser.completeUnitFactor(baseUnit, factor));
        element.close(this.ignoredElements);
        if (!ArraysExt.containsIgnoreCase((String[])UNIT_SYMBOLS_TO_IGNORE, (String)name)) {
            try {
                Unit parsed = this.parseUnit(name);
                if (GeodeticObjectParser.verifyUnitConsistency(unit, parsed)) {
                    unit = parsed;
                } else {
                    this.warning(parent, element, Errors.formatInternational((short)174, (Object[])new Object[]{name, factor}), null);
                }
            }
            catch (IncommensurableException e) {
                unitID[0] = "Unit";
                unitID[1] = name;
                throw new UnparsableObjectException(this.errorLocale, 85, unitID, element.offset).initCause(e);
            }
            catch (MeasurementParseException e) {
                this.warning(parent, element, Errors.formatInternational((short)183, (Object)name), (Exception)((Object)e));
            }
        }
        if (byID != null && byID != unit) {
            IncommensurableException cause = null;
            try {
                if (GeodeticObjectParser.verifyUnitConsistency(unit, byID)) {
                    return byID;
                }
                if (Units.isAngular(unit) && GeodeticObjectParser.verifyUnitConsistency(unit, Units.DEGREE)) {
                    unit = Units.DEGREE;
                }
            }
            catch (IncommensurableException e) {
                cause = e;
            }
            unitID[1] = "EPSG:" + String.valueOf(unitID[0]);
            unitID[0] = "Unit[\"" + name + "\"].Id";
            this.warning(parent, element, Errors.formatInternational((short)85, (Object[])unitID), (Exception)((Object)cause));
        }
        return unit;
    }

    private static boolean verifyUnitConsistency(Unit<?> unit, Unit<?> expected) throws IncommensurableException {
        return Math.abs(expected.getConverterToAny(unit).convert(1.5) - 1.5) <= 1.5000000000000002E-13;
    }

    private CoordinateSystem parseCoordinateSystem(Element parent, String type, int dimension, boolean isWKT1, Unit<?> defaultUnit, boolean geodetic, VerticalDatumType vertical) throws ParseException, FactoryException {
        Element element;
        this.axisOrder.clear();
        boolean is3D = dimension >= 3;
        Map<String, Object> csProperties = null;
        if (!isWKT1 && (element = parent.pullElement(1, "CS")) != null) {
            String expected = type;
            type = element.pullVoidElement((String)"type").keyword;
            dimension = element.pullInteger("dimension");
            csProperties = new HashMap<String, Object>(this.parseMetadataAndClose(element, "CS", null));
            if (expected != null && !expected.equalsIgnoreCase(type)) {
                throw new UnparsableObjectException(this.errorLocale, 176, new String[]{"CS", type}, element.offset);
            }
            if (dimension <= 0 || dimension >= Short.MAX_VALUE) {
                Object[] args;
                short key;
                if (dimension <= 0) {
                    key = 203;
                    args = new Object[]{"dimension", dimension};
                } else {
                    key = 50;
                    args = new Object[]{dimension};
                }
                throw new UnparsableObjectException(this.errorLocale, key, args, element.offset);
            }
            type = type.equalsIgnoreCase("Cartesian") ? "Cartesian" : type.toLowerCase(this.symbols.getLocale());
        }
        CoordinateSystemAxis[] axes = null;
        CoordinateSystemAxis axis = this.parseAxis(type == null ? 2 : 1, parent, type, defaultUnit);
        if (axis != null) {
            ArrayList<CoordinateSystemAxis> list = new ArrayList<CoordinateSystemAxis>(dimension + 2);
            do {
                list.add(axis);
            } while ((axis = this.parseAxis(list.size() < dimension ? 2 : 1, parent, type, defaultUnit)) != null);
            if (!isWKT1 || !this.ignoreAxes) {
                axes = (CoordinateSystemAxis[])list.toArray(CoordinateSystemAxis[]::new);
                Arrays.sort(axes, this);
            }
        }
        CSFactory csFactory = this.factories.getCSFactory();
        if (axes == null) {
            if (type == null) {
                throw parent.missingComponent("Axis");
            }
            String nx = null;
            String x = null;
            String ny = null;
            String y = null;
            String nz = null;
            String z = null;
            AxisDirection dx = AxisDirection.EAST;
            AxisDirection dy = AxisDirection.NORTH;
            AxisDirection direction = null;
            Unit unit = defaultUnit;
            switch (type) {
                case "Cartesian": {
                    if (!geodetic) {
                        throw parent.missingComponent("Axis");
                    }
                    if (defaultUnit == null) {
                        throw parent.missingComponent("LengthUnit");
                    }
                    if (is3D) {
                        return Legacy.standard(defaultUnit);
                    }
                    nx = "Easting";
                    x = "E";
                    ny = "Northing";
                    y = "N";
                    if (dimension < 3) break;
                    z = "h";
                    nz = "Ellipsoidal height";
                    unit = Units.METRE;
                    break;
                }
                case "ellipsoidal": {
                    if (defaultUnit == null) {
                        throw parent.missingComponent("AngleUnit");
                    }
                    if (isWKT1) {
                        nx = "Geodetic longitude";
                        x = "\u03bb";
                        ny = "Geodetic latitude";
                        y = "\u03c6";
                    } else {
                        nx = "Geodetic latitude";
                        x = "\u03c6";
                        dx = AxisDirection.NORTH;
                        ny = "Geodetic longitude";
                        y = "\u03bb";
                        dy = AxisDirection.EAST;
                    }
                    if (dimension < 3) break;
                    direction = AxisDirection.UP;
                    z = "h";
                    nz = "Ellipsoidal height";
                    unit = Units.METRE;
                    break;
                }
                case "vertical": {
                    if (defaultUnit == null) {
                        throw parent.missingComponent("Unit");
                    }
                    z = "h";
                    nz = "Height";
                    direction = AxisDirection.UP;
                    if (vertical == VerticalDatumType.GEOIDAL) {
                        nz = "Gravity-related height";
                        z = "H";
                        break;
                    }
                    if (vertical == VerticalDatumType.DEPTH) {
                        direction = AxisDirection.DOWN;
                        nz = "Depth";
                        z = "D";
                        break;
                    }
                    if (!VerticalDatumTypes.ellipsoidal(vertical)) break;
                    nz = "Ellipsoidal height";
                    break;
                }
                case "temporal": {
                    if (defaultUnit == null) {
                        throw parent.missingComponent("TimeUnit");
                    }
                    direction = AxisDirection.FUTURE;
                    nz = "Time";
                    z = "t";
                    break;
                }
                case "parametric": {
                    if (defaultUnit == null) {
                        throw parent.missingComponent("ParametricUnit");
                    }
                    direction = AxisDirections.UNSPECIFIED;
                    nz = "Parametric";
                    z = "p";
                    break;
                }
                default: {
                    throw parent.missingComponent("Axis");
                }
            }
            int i = 0;
            axes = new CoordinateSystemAxis[dimension];
            if (x != null && i < dimension) {
                axes[i++] = csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", nx), x, dx, defaultUnit);
            }
            if (y != null && i < dimension) {
                axes[i++] = csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", ny), y, dy, defaultUnit);
            }
            if (z != null && i < dimension) {
                axes[i++] = csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", nz), z, direction, unit);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (type != null && !type.isEmpty()) {
            int c = type.codePointAt(0);
            buffer.appendCodePoint(Character.toUpperCase(c)).append(type, Character.charCount(c), type.length()).append(' ');
        }
        String name = AxisDirections.appendTo(buffer.append("CS"), axes);
        if (csProperties == null) {
            csProperties = Collections.singletonMap("name", name);
        } else {
            csProperties.put("name", name);
        }
        if (type == null) {
            return new AbstractCS(csProperties, axes);
        }
        switch (type) {
            case "ellipsoidal": {
                switch (axes.length) {
                    case 2: {
                        return csFactory.createEllipsoidalCS(csProperties, axes[0], axes[1]);
                    }
                    case 3: {
                        return csFactory.createEllipsoidalCS(csProperties, axes[0], axes[1], axes[2]);
                    }
                }
                dimension = axes.length < 2 ? 2 : 3;
                break;
            }
            case "spherical": {
                switch (axes.length) {
                    case 2: {
                        if (!(csFactory instanceof GeodeticObjectFactory)) break;
                        return ((GeodeticObjectFactory)csFactory).createSphericalCS(csProperties, axes[0], axes[1]);
                    }
                    case 3: {
                        return csFactory.createSphericalCS(csProperties, axes[0], axes[1], axes[2]);
                    }
                }
                dimension = axes.length < 2 ? 2 : 3;
                break;
            }
            case "Cartesian": {
                switch (axes.length) {
                    case 2: {
                        return csFactory.createCartesianCS(csProperties, axes[0], axes[1]);
                    }
                    case 3: {
                        return csFactory.createCartesianCS(csProperties, axes[0], axes[1], axes[2]);
                    }
                }
                dimension = axes.length < 2 ? 2 : 3;
                break;
            }
            case "affine": {
                switch (axes.length) {
                    case 2: {
                        return csFactory.createAffineCS(csProperties, axes[0], axes[1]);
                    }
                    case 3: {
                        return csFactory.createAffineCS(csProperties, axes[0], axes[1], axes[2]);
                    }
                }
                dimension = axes.length < 2 ? 2 : 3;
                break;
            }
            case "vertical": {
                dimension = 1;
                if (axes.length != 1) break;
                return csFactory.createVerticalCS(csProperties, axes[0]);
            }
            case "temporal": {
                dimension = 1;
                if (axes.length != 1) break;
                return csFactory.createTimeCS(csProperties, axes[0]);
            }
            case "linear": {
                dimension = 1;
                if (axes.length != 1) break;
                return csFactory.createLinearCS(csProperties, axes[0]);
            }
            case "polar": {
                dimension = 2;
                if (axes.length != 2) break;
                return csFactory.createPolarCS(csProperties, axes[0], axes[1]);
            }
            case "cylindrical": {
                dimension = 3;
                if (axes.length != 3) break;
                return csFactory.createCylindricalCS(csProperties, axes[0], axes[1], axes[2]);
            }
            case "parametric": {
                dimension = 1;
                if (axes.length != 1) break;
                return MissingMethods.createParametricCS(csProperties, axes[0], csFactory);
            }
            default: {
                this.warning(parent, "CS", Errors.formatInternational((short)182, (Object)type), null);
                return new AbstractCS(csProperties, axes);
            }
        }
        throw new UnparsableObjectException(this.errorLocale, axes.length > dimension ? (short)161 : 158, new Object[]{dimension, "Axis"}, parent.offset);
    }

    private CoordinateSystemAxis parseAxis(int mode, Element parent, String csType, Unit<?> defaultUnit) throws ParseException {
        CoordinateSystemAxis axis;
        String abbreviation;
        int start;
        int end;
        Element element = parent.pullElement(mode, "Axis");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Element orientation = element.pullVoidElement("orientation");
        Unit<?> unit = this.parseUnit(element);
        if (unit == null) {
            if (defaultUnit == null) {
                throw element.missingComponent("Unit");
            }
            unit = defaultUnit;
        }
        AxisDirection direction = (AxisDirection)Types.forCodeName(AxisDirection.class, (String)orientation.keyword, AxisDirection::valueOf);
        Element meridian = element.pullElement(1, "Meridian");
        if (meridian != null) {
            double angle = meridian.pullDouble("meridian");
            Unit m = this.parseScaledUnit(meridian, "AngleUnit", Units.RADIAN);
            meridian.close(this.ignoredElements);
            if (m != null) {
                angle = m.getConverterTo(Units.DEGREE).convert(angle);
            }
            direction = CoordinateSystems.directionAlongMeridian(direction, angle);
        }
        if ((end = name.length() - 1) > 1 && name.charAt(end) == ')' && (start = name.lastIndexOf(40, end - 1)) >= 0) {
            int np = end;
            while (--np >= 0 && name.charAt(np) == ')') {
                int c = name.lastIndexOf(40, start - 1);
                if (c < 0) {
                    this.warning(parent, element, Errors.formatInternational((short)127, (Object[])new Object[]{Character.valueOf('('), name}), null);
                    break;
                }
                start = c;
            }
            abbreviation = name.substring(start + 1, end).strip();
            if ((name = name.substring(0, start).strip()).isEmpty()) {
                name = abbreviation;
            }
        } else {
            abbreviation = AxisDirections.suggestAbbreviation(name, direction, unit);
        }
        name = this.transliterator.toLongAxisName(csType, direction, name);
        abbreviation = this.transliterator.toUnicodeAbbreviation(csType, direction, abbreviation);
        Integer order = this.pullElementAsInteger(element, "Order");
        double minimum = this.pullElementAsDouble(element, "AxisMinValue", 1);
        double maximum = this.pullElementAsDouble(element, "AxisMaxValue", 1);
        String meaning = this.pullElementAsEnum(element, "RangeMeaning");
        Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
        if (Double.isFinite(minimum)) {
            properties.put("minimumValue", minimum);
        }
        if (Double.isFinite(maximum)) {
            properties.put("maximumValue", maximum);
        }
        properties.put("rangeMeaning", Types.forCodeName(RangeMeaning.class, (String)meaning, RangeMeaning::valueOf));
        CSFactory csFactory = this.factories.getCSFactory();
        try {
            axis = csFactory.createCoordinateSystemAxis(properties, abbreviation, direction, unit);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        if (this.axisOrder.put(axis, order) != null) {
            throw new UnparsableObjectException(this.errorLocale, 37, new Object[]{Strings.bracket((String)"Axis", (Object)name)}, element.offset);
        }
        return axis;
    }

    @Override
    public final int compare(CoordinateSystemAxis o1, CoordinateSystemAxis o2) {
        Integer n1 = this.axisOrder.get(o1);
        Integer n2 = this.axisOrder.get(o2);
        if (n1 != null) {
            if (n2 != null) {
                return n1 - n2;
            }
            return -1;
        }
        if (n2 != null) {
            return 1;
        }
        return 0;
    }

    private PrimeMeridian parsePrimeMeridian(int mode, Element parent, boolean isWKT1, Unit<Angle> angularUnit) throws ParseException {
        Element element;
        if (isWKT1 && this.usesCommonUnits) {
            angularUnit = Units.DEGREE;
        }
        if ((element = parent.pullElement(mode, "PrimeMeridian", "PrimeM")) == null) {
            return null;
        }
        String name = element.pullString("name");
        double longitude = element.pullDouble("longitude");
        Unit unit = this.parseScaledUnit(element, "AngleUnit", Units.RADIAN);
        if (unit != null) {
            angularUnit = unit;
        } else if (angularUnit == null) {
            throw parent.missingComponent("AngleUnit");
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createPrimeMeridian(this.parseMetadataAndClose(element, name, null), longitude, angularUnit);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private Object parseToWGS84(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "ToWGS84");
        if (element == null) {
            return null;
        }
        double[] values = new double[ToWGS84.length];
        int i = 0;
        while (i < values.length) {
            values[i] = element.pullDouble(ToWGS84[i]);
            if (++i % 3 != 0 || !element.isEmpty()) continue;
        }
        element.close(this.ignoredElements);
        BursaWolfParameters info = new BursaWolfParameters(CommonCRS.WGS84.datum(true), null);
        info.setValues(values);
        return info;
    }

    private Ellipsoid parseEllipsoid(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "Ellipsoid", "Spheroid");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        double semiMajorAxis = element.pullDouble("semiMajorAxis");
        double inverseFlattening = element.pullDouble("inverseFlattening");
        Unit unit = this.parseScaledUnit(element, "LengthUnit", Units.METRE);
        if (unit == null) {
            unit = Units.METRE;
        }
        Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            if (inverseFlattening == 0.0) {
                return datumFactory.createEllipsoid(properties, semiMajorAxis, semiMajorAxis, unit);
            }
            return datumFactory.createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private SingleCRS parseBaseCRS(int mode, Element parent, OperationMethod method) throws ParseException {
        int dimension = 2;
        String csType = "ellipsoidal";
        if (method instanceof AbstractProvider) {
            AbstractProvider p = (AbstractProvider)method;
            dimension = p.minSourceDimension;
            csType = WKTUtilities.toType(CoordinateSystem.class, p.sourceCSType);
            if (csType == null) {
                csType = "ellipsoidal";
            }
        }
        return this.parseGeodeticCRS(mode, parent, dimension, csType);
    }

    private OperationMethod parseMethod(Element parent, String ... keywords) throws ParseException {
        Element element = parent.pullElement(2, keywords);
        String name = element.pullString("method");
        Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
        Identifier id = GeodeticObjectParser.toIdentifier(properties.remove("identifiers"));
        FactoryException suppressed = null;
        if (id instanceof ReferenceIdentifier) {
            try {
                ReferenceIdentifier rid = (ReferenceIdentifier)id;
                return this.factories.findOperationMethod(rid.getCodeSpace() + ":" + rid.getCode());
            }
            catch (FactoryException e) {
                suppressed = e;
            }
        }
        try {
            return this.factories.findOperationMethod(name);
        }
        catch (FactoryException e) {
            if (suppressed != null) {
                e.addSuppressed((Throwable)suppressed);
            }
            throw element.parseFailed((Exception)((Object)e));
        }
    }

    private Conversion parseDerivingConversion(int mode, Element parent, String wrapper, Unit<?> defaultUnit, Unit<Angle> defaultAngularUnit) throws ParseException {
        String name;
        if (wrapper != null) {
            defaultUnit = Units.METRE;
            defaultAngularUnit = Units.DEGREE;
        }
        if (wrapper == null) {
            name = null;
        } else {
            if ((parent = parent.pullElement(mode, wrapper)) == null) {
                return null;
            }
            name = parent.pullString("name");
        }
        OperationMethod method = this.parseMethod(parent, "Method", "Projection");
        Map<String, Object> properties = this.properties;
        ParameterValueGroup parameters = method.getParameters().createValue();
        this.parseParameters(parent, parameters, defaultUnit, (Unit<Angle>)defaultAngularUnit);
        if (wrapper != null) {
            properties = this.parseMetadataAndClose(parent, name, (IdentifiedObject)method);
        }
        DefaultCoordinateOperationFactory opFactory = this.factories.getCoordinateOperationFactory();
        try {
            return opFactory.createDefiningConversion(properties, method, parameters);
        }
        catch (FactoryException exception) {
            throw parent.parseFailed((Exception)((Object)exception));
        }
    }

    private Temporal parseEpoch(int mode, Element parent, String keyword) throws ParseException {
        return Epoch.fromYear(this.pullElementAsDouble(parent, keyword, mode), 0);
    }

    private Temporal parseDynamic(Element parent) throws ParseException {
        Element element = parent.pullElement(1, "Dynamic");
        if (element == null) {
            return null;
        }
        Temporal epoch = this.parseEpoch(2, element, "FrameEpoch");
        element.close(this.ignoredElements);
        return epoch;
    }

    private Map<String, Object> parseAnchorAndClose(Element element, String name) throws ParseException {
        String anchor = this.pullElementAsString(element, "Anchor");
        Temporal epoch = this.parseEpoch(1, element, "AnchorEpoch");
        Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
        if (anchor != null) {
            properties.put("anchorDefinition", anchor);
        }
        if (epoch != null) {
            properties.put("anchorEpoch", epoch);
        }
        return properties;
    }

    private <D extends Datum> DefaultDatumEnsemble<D> parseEnsemble(int mode, Element parent, PrimeMeridian meridian, Class<D> datumType) throws ParseException {
        boolean vertical;
        Ellipsoid ellipsoid;
        Element ensemble = parent.pullElement(mode, "Ensemble");
        if (ensemble == null) {
            return null;
        }
        String ensembleName = ensemble.pullString("name");
        if (datumType == GeodeticDatum.class) {
            ellipsoid = this.parseEllipsoid(2, ensemble);
            vertical = false;
        } else if (datumType == Datum.class) {
            ellipsoid = this.parseEllipsoid(1, ensemble);
            vertical = ellipsoid == null;
        } else {
            ellipsoid = null;
            vertical = datumType == VerticalDatum.class;
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        ArrayList<Datum> members = new ArrayList<Datum>();
        try {
            Element element = ensemble.pullElement(2, "Member");
            do {
                Object member;
                block15: {
                    try {
                        String name = element.pullString("name");
                        Map<String, Object> properties = this.parseAnchorAndClose(element, name);
                        if (ellipsoid != null) {
                            member = datumFactory.createGeodeticDatum(properties, ellipsoid, meridian);
                            break block15;
                        }
                        if (vertical) {
                            member = datumFactory.createVerticalDatum(properties, VerticalDatumTypes.fromDatum(name, null, null));
                            break block15;
                        }
                        if (datumType == TemporalDatum.class) {
                            member = datumFactory.createTemporalDatum(properties, null);
                            break block15;
                        }
                        if (datumType == DefaultParametricDatum.class) {
                            member = MissingMethods.createParametricDatum(properties, datumFactory);
                            break block15;
                        }
                        if (datumType == EngineeringDatum.class) {
                            member = datumFactory.createEngineeringDatum(properties);
                            break block15;
                        }
                        throw new AssertionError(datumType);
                    }
                    catch (FactoryException exception) {
                        throw element.parseFailed((Exception)((Object)exception));
                    }
                }
                members.add((Datum)datumType.cast(member));
            } while ((element = ensemble.pullElement(1, "Member")) != null);
            PositionalAccuracy accuracy = PositionalAccuracyConstant.ensemble(this.pullElementAsDouble(ensemble, "EnsembleAccuracy", 2));
            return MissingMethods.createDatumEnsemble(this.parseAnchorAndClose(ensemble, ensembleName), members, accuracy, datumFactory);
        }
        catch (FactoryException exception) {
            throw ensemble.parseFailed((Exception)((Object)exception));
        }
    }

    private GeodeticDatum parseDatum(int mode, Element parent, PrimeMeridian meridian, Temporal epoch) throws ParseException {
        Element element = parent.pullElement(mode, "GeodeticDatum", "Datum", "TRF");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Ellipsoid ellipsoid = this.parseEllipsoid(2, element);
        Object toWGS84 = this.parseToWGS84(1, element);
        Map<String, Object> properties = this.parseAnchorAndClose(element, name);
        if (toWGS84 != null) {
            properties.put("bursaWolf", toWGS84);
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            if (epoch == null) {
                return datumFactory.createGeodeticDatum(properties, ellipsoid, meridian);
            }
            return MissingMethods.createGeodeticDatum(properties, ellipsoid, meridian, epoch, datumFactory);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private VerticalDatum parseVerticalDatum(int mode, Element parent, Temporal epoch, boolean isWKT1) throws ParseException {
        Element element = parent.pullElement(mode, "VerticalDatum", "VDatum", "Vert_Datum", "VRF");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        VerticalDatumType method = null;
        if (isWKT1) {
            method = VerticalDatumTypes.fromLegacyCode(element.pullInteger("datum"));
        }
        if (method == null) {
            method = VerticalDatumTypes.fromDatum(name, null, null);
        }
        Map<String, Object> properties = this.parseAnchorAndClose(element, name);
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            if (epoch == null) {
                return datumFactory.createVerticalDatum(properties, method);
            }
            return MissingMethods.createVerticalDatum(properties, method, epoch, datumFactory);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private TemporalDatum parseTimeDatum(int mode, Element parent) throws ParseException {
        Temporal epoch;
        Element element = parent.pullElement(mode, "TimeDatum", "TDatum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Element origin = element.pullElement(1, "TimeOrigin");
        if (origin != null) {
            epoch = origin.pullTime("origin");
            origin.close(this.ignoredElements);
        } else {
            epoch = LocalDate.of(1875, 5, 20);
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createTemporalDatum(this.parseAnchorAndClose(element, name), TemporalDate.toDate((Temporal)epoch));
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private DefaultParametricDatum parseParametricDatum(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "ParametricDatum", "PDatum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return MissingMethods.createParametricDatum(this.parseAnchorAndClose(element, name), datumFactory);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private EngineeringDatum parseEngineeringDatum(int mode, Element parent, boolean isWKT1) throws ParseException {
        Element element = parent.pullElement(mode, "EngineeringDatum", "EDatum", "Local_Datum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        if (isWKT1) {
            element.pullInteger("datum");
        }
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createEngineeringDatum(this.parseAnchorAndClose(element, name));
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private ImageDatum parseImageDatum(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "ImageDatum", "IDatum");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        PixelInCell pixelInCell = (PixelInCell)Types.forCodeName(PixelInCell.class, (String)element.pullVoidElement((String)"pixelInCell").keyword, PixelInCell::valueOf);
        DatumFactory datumFactory = this.factories.getDatumFactory();
        try {
            return datumFactory.createImageDatum(this.parseAnchorAndClose(element, name), pixelInCell);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private SingleCRS parseEngineeringCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        String[] stringArray;
        if (isBaseCRS) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseEngCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "EngineeringCRS";
            stringArray3[1] = "EngCRS";
            stringArray = stringArray3;
            stringArray3[2] = "Local_CS";
        }
        Element element = parent.pullElement(mode, stringArray);
        if (element == null) {
            return null;
        }
        boolean isWKT1 = element.getKeywordIndex() == 2;
        String name = element.pullString("name");
        Unit<?> unit = this.parseUnit(element);
        EngineeringDatum ensemble = null;
        EngineeringDatum datum = null;
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isWKT1 && !isBaseCRS && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", unit, null)) != null && (baseCRS = this.parseEngineeringCRS(1, element, true)) == null && (baseCRS = this.parseBaseCRS(1, element, fromBase.getMethod())) == null) {
            baseCRS = this.parseProjectedCRS(2, element, true);
        }
        if (baseCRS == null) {
            ensemble = this.parseEnsemble(1, element, null, EngineeringDatum.class);
            datum = this.parseEngineeringDatum(ensemble == null ? 2 : 1, element, isWKT1);
        }
        EngineeringDatum datumOrEnsemble = datum != null ? datum : ensemble;
        CRSFactory crsFactory = this.factories.getCRSFactory();
        try {
            CoordinateSystem cs = this.parseCoordinateSystem(element, null, 1, isWKT1, unit, false, null);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, (IdentifiedObject)datumOrEnsemble);
            if (baseCRS != null) {
                properties.put("derivedType", EngineeringCRS.class);
                return crsFactory.createDerivedCRS(properties, (CoordinateReferenceSystem)baseCRS, fromBase, cs);
            }
            return MissingMethods.createEngineeringCRS(properties, datum, (DefaultDatumEnsemble<EngineeringDatum>)ensemble, cs, crsFactory);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private ImageCRS parseImageCRS(int mode, Element parent) throws ParseException {
        CoordinateSystem cs;
        Element element = parent.pullElement(mode, "ImageCRS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        ImageDatum datum = this.parseImageDatum(2, element);
        Unit<?> unit = this.parseUnit(element);
        try {
            cs = this.parseCoordinateSystem(element, "Cartesian", 2, false, unit, false, null);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, (IdentifiedObject)datum);
            if (cs instanceof AffineCS) {
                return this.factories.getCRSFactory().createImageCRS(properties, datum, (AffineCS)cs);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        throw element.illegalCS(cs);
    }

    private SingleCRS parseGeodeticCRS(int mode, Element parent, int dimension, String csType) throws ParseException {
        CoordinateSystem cs;
        Unit angularUnit;
        Unit csUnit;
        boolean isWKT1;
        String[] stringArray;
        if (csType != null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "BaseGeodCRS";
            stringArray2[1] = "BaseGeogCRS";
            stringArray = stringArray2;
            stringArray2[2] = "GeogCS";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "GeodeticCRS";
            stringArray3[1] = "GeographicCRS";
            stringArray3[2] = "GeogCS";
            stringArray3[3] = "GeodCRS";
            stringArray3[4] = "GeogCRS";
            stringArray = stringArray3;
            stringArray3[5] = "GeocCS";
        }
        Element element = parent.pullElement(mode, stringArray);
        if (element == null) {
            return null;
        }
        switch (element.getKeywordIndex()) {
            default: {
                isWKT1 = false;
                csUnit = this.parseUnit(element);
                if (Units.isAngular(csUnit)) {
                    angularUnit = csUnit.asType(Angle.class);
                    break;
                }
                angularUnit = Units.DEGREE;
                if (csUnit != null || csType == null) break;
                switch (csType) {
                    case "ellipsoidal": {
                        csUnit = Units.DEGREE;
                        break;
                    }
                    case "Cartesian": {
                        csUnit = Units.METRE;
                    }
                }
                break;
            }
            case 2: {
                isWKT1 = true;
                csType = "ellipsoidal";
                csUnit = angularUnit = this.parseScaledUnit(element, "AngleUnit", Units.RADIAN);
                dimension = 2;
                break;
            }
            case 5: {
                isWKT1 = true;
                csType = "Cartesian";
                angularUnit = Units.DEGREE;
                csUnit = this.parseScaledUnit(element, "LengthUnit", Units.METRE);
                dimension = 3;
            }
        }
        String name = element.pullString("name");
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isWKT1 && csType == null && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", csUnit, (Unit<Angle>)angularUnit)) != null) {
            baseCRS = this.parseBaseCRS(2, element, fromBase.getMethod());
        }
        CRSFactory crsFactory = this.factories.getCRSFactory();
        try {
            PrimeMeridian meridian;
            cs = this.parseCoordinateSystem(element, csType, dimension, isWKT1, csUnit, true, null);
            if (baseCRS != null) {
                Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
                return crsFactory.createDerivedCRS(properties, (CoordinateReferenceSystem)baseCRS, fromBase, cs);
            }
            Unit<Angle> longitudeUnit = AxisDirections.getAngularUnit(cs, (Unit<Angle>)angularUnit);
            if (angularUnit != null && !angularUnit.equals(longitudeUnit)) {
                this.warning(element, "AngleUnit", Errors.formatInternational((short)87, (Object)angularUnit), null);
            }
            if ((meridian = this.parsePrimeMeridian(1, element, isWKT1, longitudeUnit)) == null) {
                meridian = GeodeticObjectParser.greenwich();
            }
            Temporal epoch = this.parseDynamic(element);
            DefaultDatumEnsemble<GeodeticDatum> ensemble = this.parseEnsemble(1, element, meridian, GeodeticDatum.class);
            GeodeticDatum datum = this.parseDatum(ensemble == null ? 2 : 1, element, meridian, epoch);
            Object datumOrEnsemble = datum != null ? datum : ensemble;
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, (IdentifiedObject)datumOrEnsemble);
            if (cs instanceof EllipsoidalCS) {
                return MissingMethods.createGeographicCRS(properties, datum, ensemble, (EllipsoidalCS)cs, crsFactory);
            }
            if (cs instanceof CartesianCS) {
                return MissingMethods.createGeodeticCRS(properties, datum, ensemble, Legacy.forGeocentricCRS((CartesianCS)cs, false), crsFactory);
            }
            if (cs instanceof SphericalCS) {
                return MissingMethods.createGeodeticCRS(properties, datum, ensemble, (SphericalCS)cs, crsFactory);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        throw element.illegalCS(cs);
    }

    private SingleCRS parseVerticalCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        CoordinateSystem cs;
        String[] stringArray;
        if (isBaseCRS) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseVertCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "VerticalCRS";
            stringArray3[1] = "VertCRS";
            stringArray = stringArray3;
            stringArray3[2] = "Vert_CS";
        }
        Element element = parent.pullElement(mode, stringArray);
        if (element == null) {
            return null;
        }
        boolean isWKT1 = element.getKeywordIndex() == 2;
        String name = element.pullString("name");
        Unit<?> unit = this.parseUnit(element);
        VerticalDatum ensemble = null;
        VerticalDatum datum = null;
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isWKT1 && !isBaseCRS && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", unit, null)) != null) {
            baseCRS = this.parseVerticalCRS(2, element, true);
        }
        if (baseCRS == null) {
            Temporal epoch = this.parseDynamic(element);
            ensemble = this.parseEnsemble(1, element, null, VerticalDatum.class);
            datum = this.parseVerticalDatum(ensemble == null ? 2 : 1, element, epoch, isWKT1);
        }
        VerticalDatum datumOrEnsemble = datum != null ? datum : ensemble;
        try {
            VerticalDatumType method = ((VerticalDatum)datumOrEnsemble).getVerticalDatumType();
            cs = this.parseCoordinateSystem(element, "vertical", 1, isWKT1, unit, false, method);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, (IdentifiedObject)datumOrEnsemble);
            if (cs instanceof VerticalCS) {
                VerticalDatumType type;
                CRSFactory crsFactory = this.factories.getCRSFactory();
                if (baseCRS != null) {
                    return crsFactory.createDerivedCRS(properties, (CoordinateReferenceSystem)baseCRS, fromBase, cs);
                }
                if (method == VerticalDatumType.OTHER_SURFACE && datum != null && !(datum instanceof DefaultVerticalDatum.Dynamic) && (type = VerticalDatumTypes.fromDatum(datum.getName().getCode(), datum.getAlias(), cs.getAxis(0))) != VerticalDatumType.OTHER_SURFACE) {
                    DatumFactory datumFactory = this.factories.getDatumFactory();
                    datum = datumFactory.createVerticalDatum(IdentifiedObjects.getProperties((IdentifiedObject)datum, new String[0]), type);
                }
                this.verticalCRS = MissingMethods.createVerticalCRS(properties, datum, (DefaultDatumEnsemble<VerticalDatum>)ensemble, (VerticalCS)cs, crsFactory);
                if (this.verticalElements != null) {
                    this.verticalElements = this.verticalElements.resolve(this.verticalCRS);
                }
                return this.verticalCRS;
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        throw element.illegalCS(cs);
    }

    private SingleCRS parseTimeCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        CoordinateSystem cs;
        Element element = parent.pullElement(mode, isBaseCRS ? "BaseTimeCRS" : "TimeCRS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Unit unit = this.parseScaledUnit(element, "TimeUnit", Units.SECOND);
        TemporalDatum ensemble = null;
        TemporalDatum datum = null;
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isBaseCRS && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", unit, null)) != null) {
            baseCRS = this.parseTimeCRS(2, element, true);
        }
        if (baseCRS == null) {
            ensemble = this.parseEnsemble(1, element, null, TemporalDatum.class);
            datum = this.parseTimeDatum(ensemble == null ? 2 : 1, element);
        }
        TemporalDatum datumOrEnsemble = datum != null ? datum : ensemble;
        try {
            cs = this.parseCoordinateSystem(element, "temporal", 1, false, unit, false, null);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, (IdentifiedObject)datumOrEnsemble);
            if (cs instanceof TimeCS) {
                CRSFactory crsFactory = this.factories.getCRSFactory();
                if (baseCRS != null) {
                    return crsFactory.createDerivedCRS(properties, (CoordinateReferenceSystem)baseCRS, fromBase, cs);
                }
                return MissingMethods.createTemporalCRS(properties, datum, (DefaultDatumEnsemble<TemporalDatum>)ensemble, (TimeCS)cs, crsFactory);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        throw element.illegalCS(cs);
    }

    private SingleCRS parseParametricCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        CoordinateSystem cs;
        Element element = parent.pullElement(mode, isBaseCRS ? "BaseParamCRS" : "ParametricCRS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        Unit<?> unit = this.parseUnit(element);
        DefaultDatumEnsemble<DefaultParametricDatum> ensemble = null;
        AbstractIdentifiedObject datum = null;
        SingleCRS baseCRS = null;
        Conversion fromBase = null;
        if (!isBaseCRS && (fromBase = this.parseDerivingConversion(1, element, "DerivingConversion", unit, null)) != null) {
            baseCRS = this.parseParametricCRS(2, element, true);
        }
        if (baseCRS == null) {
            ensemble = this.parseEnsemble(1, element, null, DefaultParametricDatum.class);
            datum = this.parseParametricDatum(ensemble == null ? 2 : 1, element);
        }
        DefaultDatumEnsemble<DefaultParametricDatum> datumOrEnsemble = datum != null ? datum : ensemble;
        try {
            cs = this.parseCoordinateSystem(element, "parametric", 1, false, unit, false, null);
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, datumOrEnsemble);
            if (cs instanceof DefaultParametricCS) {
                CRSFactory crsFactory = this.factories.getCRSFactory();
                if (baseCRS != null) {
                    return crsFactory.createDerivedCRS(properties, (CoordinateReferenceSystem)baseCRS, fromBase, cs);
                }
                return MissingMethods.createParametricCRS(properties, datum, ensemble, (DefaultParametricCS)cs, crsFactory);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        throw element.illegalCS(cs);
    }

    private ProjectedCRS parseProjectedCRS(int mode, Element parent, boolean isBaseCRS) throws ParseException {
        CoordinateSystem cs;
        String[] stringArray;
        if (isBaseCRS) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseProjCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "ProjectedCRS";
            stringArray3[1] = "ProjCRS";
            stringArray = stringArray3;
            stringArray3[2] = "ProjCS";
        }
        Element element = parent.pullElement(mode, stringArray);
        if (element == null) {
            return null;
        }
        boolean isWKT1 = element.getKeywordIndex() == 2;
        String name = element.pullString("name");
        Unit csUnit = this.parseScaledUnit(element, "LengthUnit", Units.METRE);
        if (csUnit == null && isBaseCRS) {
            csUnit = Units.METRE;
        }
        try {
            cs = this.parseCoordinateSystem(element, "Cartesian", 2, isWKT1, csUnit, true, null);
            if (cs instanceof CartesianCS) {
                Unit<Angle> angularUnit;
                Unit linearUnit;
                SingleCRS geoCRS = this.parseGeodeticCRS(2, element, cs.getDimension(), "ellipsoidal");
                if (!(geoCRS instanceof GeodeticCRS)) {
                    throw new UnparsableObjectException(this.errorLocale, 61, new Object[]{geoCRS.getClass()}, element.offset);
                }
                if (isWKT1 && this.usesCommonUnits) {
                    linearUnit = Units.METRE;
                    angularUnit = Units.DEGREE;
                } else {
                    linearUnit = csUnit;
                    angularUnit = AxisDirections.getAngularUnit(geoCRS.getCoordinateSystem(), (Unit<Angle>)Units.DEGREE);
                }
                Conversion conversion = this.parseDerivingConversion(2, element, isWKT1 ? null : "Conversion", linearUnit, angularUnit);
                Map<String, Object> properties = this.parseMetadataAndClose(element, name, (IdentifiedObject)conversion);
                CRSFactory crsFactory = this.factories.getCRSFactory();
                return crsFactory.createProjectedCRS(properties, (GeographicCRS)geoCRS, conversion, (CartesianCS)cs);
            }
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
        throw element.illegalCS(cs);
    }

    private CoordinateReferenceSystem parseCompoundCRS(int mode, Element parent) throws ParseException {
        CoordinateReferenceSystem crs;
        Element element = parent.pullElement(mode, "CompoundCRS", "Compd_CS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        ArrayList<CoordinateReferenceSystem> components = new ArrayList<CoordinateReferenceSystem>(4);
        while ((crs = this.parseCoordinateReferenceSystem(element, components.size() < 2)) != null) {
            components.add(crs);
        }
        try {
            return new EllipsoidalHeightCombiner(this.factories).createCompoundCRS(this.parseMetadataAndClose(element, name, null), (CoordinateReferenceSystem[])components.toArray(CoordinateReferenceSystem[]::new));
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception));
        }
    }

    private DerivedCRS parseFittedCS(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "Fitted_CS");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        MathTransform toBase = this.parseMathTransform(element, true);
        OperationMethod method = this.getOperationMethod(element);
        CoordinateReferenceSystem baseCRS = this.parseCoordinateReferenceSystem(element, true);
        if (!(baseCRS instanceof SingleCRS)) {
            throw new UnparsableObjectException(this.errorLocale, 176, new Object[]{"Fitted_CS", baseCRS.getClass()}, element.offset);
        }
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[toBase.getSourceDimensions()];
        StringBuilder buffer = new StringBuilder(name).append(" axis ");
        int start = buffer.length();
        CSFactory csFactory = this.factories.getCSFactory();
        try {
            for (int i = 0; i < axes.length; ++i) {
                String number = String.valueOf(i);
                buffer.setLength(start);
                buffer.append(number);
                axes[i] = csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", buffer.toString()), number, AxisDirections.UNSPECIFIED, Units.UNITY);
            }
            Map<String, Object> properties = this.parseMetadataAndClose(element, name, (IdentifiedObject)baseCRS);
            Map<String, String> axisName = Collections.singletonMap("name", AxisDirections.appendTo(new StringBuilder("CS"), axes));
            AbstractCS derivedCS = new AbstractCS(axisName, axes);
            properties.put("conversion.name", name);
            return DefaultDerivedCRS.create(properties, (SingleCRS)baseCRS, null, method, toBase.inverse(), derivedCS);
        }
        catch (NoninvertibleTransformException | FactoryException exception) {
            throw element.parseFailed((Exception)exception);
        }
    }

    private CoordinateOperation parseGeogTranslation(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "GeogTran");
        if (element == null) {
            return null;
        }
        String name = element.pullString("name");
        SingleCRS sourceCRS = this.parseGeodeticCRS(2, element, 2, null);
        SingleCRS targetCRS = this.parseGeodeticCRS(2, element, 2, null);
        OperationMethod method = this.parseMethod(element, "Method");
        Map<String, Object> properties = this.parseParametersAndClose(element, name, method);
        try {
            DefaultCoordinateOperationFactory df = this.getOperationFactory();
            return df.createSingleOperation(properties, (CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, null, method, null);
        }
        catch (FactoryException e) {
            throw element.parseFailed((Exception)((Object)e));
        }
    }

    private CoordinateOperation parseOperation(int mode, Element parent) throws ParseException {
        Element element = parent.pullElement(mode, "CoordinateOperation", "ConcatenatedOperation");
        if (element == null) {
            return null;
        }
        boolean concat = element.getKeywordIndex() != 0;
        String name = element.pullString("name");
        String version = this.pullElementAsString(element, "Version");
        double accuracy = this.pullElementAsDouble(element, "OperationAccuracy", 1);
        CoordinateReferenceSystem sourceCRS = this.parseCoordinateReferenceSystem(element, 2, "SourceCRS");
        CoordinateReferenceSystem targetCRS = this.parseCoordinateReferenceSystem(element, 2, "TargetCRS");
        DefaultCoordinateOperationFactory df = this.getOperationFactory();
        try {
            if (concat) {
                Element step;
                ArrayList<CoordinateOperation> steps = new ArrayList<CoordinateOperation>();
                while ((step = element.pullElement(steps.isEmpty() ? 2 : 1, "Step")) != null) {
                    steps.add(this.parseOperation(2, step));
                    step.close(this.ignoredElements);
                }
                Map<String, Object> properties = this.parseMetadataAndClose(element, name, null);
                GeodeticObjectParser.addOperationMetadata(properties, version, accuracy);
                return df.createConcatenatedOperation(properties, sourceCRS, targetCRS, (CoordinateOperation[])steps.toArray(CoordinateOperation[]::new));
            }
            CoordinateReferenceSystem interpolationCRS = this.parseCoordinateReferenceSystem(element, 1, "InterpolationCRS");
            OperationMethod method = this.parseMethod(element, "Method");
            Map<String, Object> properties = this.parseParametersAndClose(element, name, method);
            GeodeticObjectParser.addOperationMetadata(properties, version, accuracy);
            return df.createSingleOperation(properties, sourceCRS, targetCRS, interpolationCRS, method, null);
        }
        catch (FactoryException e) {
            throw element.parseFailed((Exception)((Object)e));
        }
    }

    private static void addOperationMetadata(Map<String, Object> properties, String version, double accuracy) {
        if (version != null) {
            properties.put("operationVersion", version);
        }
        if (Double.isFinite(accuracy)) {
            properties.put("coordinateOperationAccuracy", PositionalAccuracyConstant.transformation(accuracy));
        }
    }

    private Map<String, Object> parseParametersAndClose(Element parent, String name, OperationMethod method) throws ParseException {
        ParameterValueGroup parameters = method.getParameters().createValue();
        this.parseParameters(parent, parameters, null, null);
        Map<String, Object> properties = this.parseMetadataAndClose(parent, name, (IdentifiedObject)method);
        properties.put("parameters", parameters);
        return properties;
    }

    private DefaultCoordinateOperationFactory getOperationFactory() {
        DefaultCoordinateOperationFactory opFactory = this.factories.getCoordinateOperationFactory();
        if (opFactory instanceof DefaultCoordinateOperationFactory) {
            return opFactory;
        }
        return DefaultCoordinateOperationFactory.provider();
    }

    static {
        AxisDirections.AWAY_FROM.toString();
        ToWGS84 = new String[]{"dx", "dy", "dz", "ex", "ey", "ez", "ppm"};
        UNIT_SYMBOLS_TO_IGNORE = new String[]{"DMSH", "DMS", "D.MS", "D.M"};
    }
}

