/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.ParameterizedAffine;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.VerticalOffset;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.EllipsoidToRadiusTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class ParameterizedTransformBuilder
extends MathTransformBuilder
implements MathTransformProvider.Context {
    public static final ThreadLocal<CRSAuthorityFactory> CREATOR = new ThreadLocal();
    private static final double ELLIPSOID_PRECISION = 0.01;
    protected CoordinateSystem sourceCS;
    protected CoordinateSystem targetCS;
    protected Ellipsoid sourceEllipsoid;
    protected Ellipsoid targetEllipsoid;
    protected ParameterValueGroup parameters;
    private final Map<String, Boolean> contextualParameters;
    private boolean completedParameters;
    private RuntimeException warning;

    public ParameterizedTransformBuilder(MathTransformFactory factory, OperationMethod method) {
        super(factory);
        if (method != null) {
            this.provider = method;
            this.parameters = method.getParameters().createValue();
        }
        this.contextualParameters = new LinkedHashMap<String, Boolean>();
    }

    public void setParameters(ParameterValueGroup values, boolean copy) throws NoSuchIdentifierException, InvalidGeodeticParameterException {
        this.provider = CoordinateOperations.findMethod(this.factory, (IdentifiedObject)values.getDescriptor());
        if (copy) {
            try {
                this.parameters = this.provider.getParameters().createValue();
                Parameters.copy(values, this.parameters);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidGeodeticParameterException(e.getMessage(), e);
            }
        } else {
            this.parameters = values;
        }
    }

    @Override
    public final MathTransformFactory getFactory() {
        return this.factory;
    }

    public final void setSourceAxes(CoordinateReferenceSystem crs) {
        this.setSourceAxes(crs != null ? crs.getCoordinateSystem() : null, DatumOrEnsemble.getEllipsoid(crs).orElse(null));
    }

    public final void setTargetAxes(CoordinateReferenceSystem crs) {
        this.setTargetAxes(crs != null ? crs.getCoordinateSystem() : null, DatumOrEnsemble.getEllipsoid(crs).orElse(null));
    }

    @Override
    public void setSourceAxes(CoordinateSystem cs, Ellipsoid ellipsoid) {
        if (this.completedParameters) {
            throw new IllegalStateException(Errors.format((short)1, (Object)"completedParameters"));
        }
        this.sourceCS = cs;
        this.sourceEllipsoid = ellipsoid;
    }

    @Override
    public void setTargetAxes(CoordinateSystem cs, Ellipsoid ellipsoid) {
        if (this.completedParameters) {
            throw new IllegalStateException(Errors.format((short)1, (Object)"completedParameters"));
        }
        this.targetCS = cs;
        this.targetEllipsoid = ellipsoid;
    }

    @Override
    public final OptionalInt getSourceDimensions() {
        return this.sourceCS != null ? OptionalInt.of(this.sourceCS.getDimension()) : OptionalInt.empty();
    }

    @Override
    public final Class<? extends CoordinateSystem> getSourceCSType() {
        return this.sourceCS != null ? this.sourceCS.getClass() : CoordinateSystem.class;
    }

    @Override
    public final OptionalInt getTargetDimensions() {
        return this.targetCS != null ? OptionalInt.of(this.targetCS.getDimension()) : OptionalInt.empty();
    }

    @Override
    public final Class<? extends CoordinateSystem> getTargetCSType() {
        return this.targetCS != null ? this.targetCS.getClass() : CoordinateSystem.class;
    }

    public Matrix getMatrix(ContextualParameters.MatrixRole role) throws FactoryException {
        CoordinateSystem userCS;
        boolean inverse = false;
        switch (role) {
            default: {
                throw new IllegalArgumentException(Errors.format((short)59, (Object)"role", (Object)((Object)role)));
            }
            case INVERSE_NORMALIZATION: {
                inverse = true;
            }
            case NORMALIZATION: {
                userCS = this.sourceCS;
                break;
            }
            case INVERSE_DENORMALIZATION: {
                inverse = true;
            }
            case DENORMALIZATION: {
                inverse = !inverse;
                userCS = this.targetCS;
            }
        }
        if (userCS == null) {
            return null;
        }
        CoordinateSystem normalized = CoordinateSystems.replaceAxes(userCS, AxesConvention.NORMALIZED);
        try {
            if (inverse) {
                return CoordinateSystems.swapAndScaleAxes(normalized, userCS);
            }
            return CoordinateSystems.swapAndScaleAxes(userCS, normalized);
        }
        catch (IllegalArgumentException | IncommensurableException cause) {
            throw new InvalidGeodeticParameterException(cause.getLocalizedMessage(), cause);
        }
    }

    @Override
    public final ParameterValueGroup parameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        throw new IllegalStateException(Errors.format((short)111, (Object)"method"));
    }

    @Override
    public Map<String, Boolean> getContextualParameters() {
        return Collections.unmodifiableMap(this.contextualParameters);
    }

    @Override
    public ParameterValueGroup getCompletedParameters() {
        if (this.parameters != null) {
            if (!this.completedParameters) {
                this.warning = this.completeParameters();
            }
            return this.parameters;
        }
        throw new IllegalStateException(Resources.format((short)70));
    }

    private ParameterValue<?> getContextualParameter(String name) throws ParameterNotFoundException {
        ParameterValue parameter = this.parameters.parameter(name);
        this.contextualParameters.put(name, Boolean.TRUE);
        return parameter;
    }

    private static double getValue(ParameterValue<?> parameter, Unit<?> unit) {
        return parameter.getValue() != null ? parameter.doubleValue(unit) : Double.NaN;
    }

    private static boolean ensureSet(ParameterValue<?> parameter, double actual, double expected, Unit<?> unit, double tolerance) {
        if (Math.abs(actual - expected) <= tolerance) {
            return false;
        }
        if (Double.isNaN(actual)) {
            parameter.setValue(expected, unit);
            return false;
        }
        return true;
    }

    private RuntimeException setEllipsoid(Ellipsoid ellipsoid, String semiMajor, String semiMinor, boolean inverseFlattening, RuntimeException failure) {
        if (ellipsoid != null) {
            ParameterValue<?> mismatchedParam = null;
            double mismatchedValue = 0.0;
            try {
                ParameterValue<?> ap = this.getContextualParameter(semiMajor);
                ParameterValue<?> bp = this.getContextualParameter(semiMinor);
                Unit unit = ellipsoid.getAxisUnit();
                double a = ParameterizedTransformBuilder.getValue(ap, unit);
                double b = ParameterizedTransformBuilder.getValue(bp, unit);
                double tol = Units.METRE.getConverterTo(unit).convert(0.01);
                if (ParameterizedTransformBuilder.ensureSet(ap, a, ellipsoid.getSemiMajorAxis(), unit, tol)) {
                    this.contextualParameters.put(semiMajor, Boolean.FALSE);
                    mismatchedParam = ap;
                    mismatchedValue = a;
                }
                if (ParameterizedTransformBuilder.ensureSet(bp, b, ellipsoid.getSemiMinorAxis(), unit, tol)) {
                    this.contextualParameters.put(semiMinor, Boolean.FALSE);
                    mismatchedParam = bp;
                    mismatchedValue = b;
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                if (failure == null) {
                    failure = e;
                }
                failure.addSuppressed(e);
            }
            if (mismatchedParam == null && inverseFlattening && ellipsoid.isIvfDefinitive()) {
                try {
                    ParameterValue<?> ep = this.getContextualParameter("inverse_flattening");
                    double e = ParameterizedTransformBuilder.getValue(ep, Units.UNITY);
                    if (ParameterizedTransformBuilder.ensureSet(ep, e, ellipsoid.getInverseFlattening(), Units.UNITY, 1.0E-10)) {
                        this.contextualParameters.put("inverse_flattening", Boolean.FALSE);
                        mismatchedParam = ep;
                        mismatchedValue = e;
                    }
                }
                catch (ParameterNotFoundException e) {
                    Logging.recoverableException((Logger)CoordinateOperations.LOGGER, this.getClass(), (String)"create", (Throwable)e);
                }
            }
            if (mismatchedParam != null) {
                LogRecord record = Resources.forLocale(null).createLogRecord(Level.WARNING, (short)33, ellipsoid.getName().getCode(), mismatchedParam.getDescriptor().getName().getCode(), mismatchedValue);
                Logging.completeAndLog((Logger)CoordinateOperations.LOGGER, this.getClass(), (String)"create", (LogRecord)record);
            }
        }
        return failure;
    }

    private RuntimeException completeParameters() throws IllegalArgumentException {
        boolean targetOnEllipsoid;
        boolean sourceOnEllipsoid;
        this.completedParameters = true;
        if (this.provider instanceof AbstractProvider) {
            AbstractProvider p = (AbstractProvider)this.provider;
            sourceOnEllipsoid = p.sourceOnEllipsoid;
            targetOnEllipsoid = p.targetOnEllipsoid;
        } else {
            sourceOnEllipsoid = this.sourceEllipsoid != null;
            boolean bl = targetOnEllipsoid = this.targetEllipsoid != null;
        }
        if (!(sourceOnEllipsoid | targetOnEllipsoid)) {
            return null;
        }
        if (!targetOnEllipsoid) {
            return this.setEllipsoid(this.sourceEllipsoid, "semi_major", "semi_minor", true, null);
        }
        if (!sourceOnEllipsoid) {
            return this.setEllipsoid(this.targetEllipsoid, "semi_major", "semi_minor", true, null);
        }
        RuntimeException failure = null;
        if (this.sourceCS != null) {
            try {
                ParameterValue<?> p = this.getContextualParameter("dim");
                if (p.getValue() == null) {
                    p.setValue(this.sourceCS.getDimension());
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                failure = e;
            }
        }
        failure = this.setEllipsoid(this.sourceEllipsoid, "src_semi_major", "src_semi_minor", false, failure);
        failure = this.setEllipsoid(this.targetEllipsoid, "tgt_semi_major", "tgt_semi_minor", false, failure);
        return failure;
    }

    @Override
    public MathTransform create() throws FactoryException {
        try {
            MathTransform transform;
            String method;
            if (this.provider instanceof AbstractProvider && (method = ((AbstractProvider)this.provider).resolveAmbiguity(this)) != null) {
                this.provider = (this.factory instanceof DefaultMathTransformFactory ? (DefaultMathTransformFactory)this.factory : DefaultMathTransformFactory.provider()).getOperationMethod(method);
            }
            if (this.provider instanceof MathTransformProvider) {
                try {
                    transform = ((MathTransformProvider)this.provider).createMathTransform(this);
                }
                catch (IllegalArgumentException | IllegalStateException exception) {
                    throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
                }
            } else {
                throw new FactoryException(Errors.format((short)197, (Object)Classes.getClass((Object)this.provider)));
            }
            if (this.provider instanceof AbstractProvider) {
                this.provider = ((AbstractProvider)this.provider).variantFor(transform);
            }
            return this.unique(this.swapAndScaleAxes(transform));
        }
        catch (FactoryException exception) {
            if (this.warning != null) {
                exception.addSuppressed((Throwable)this.warning);
            }
            throw exception;
        }
    }

    public MathTransform swapAndScaleAxes(MathTransform normalized) throws FactoryException {
        int numTrailingCoordinates;
        MathTransform change;
        ArgumentChecks.ensureNonNull((String)"normalized", (Object)normalized);
        if (this.provider instanceof AbstractProvider) {
            switch (((AbstractProvider)this.provider).getFormulaCategory()) {
                case APPLIED_VERBATIM: {
                    return normalized;
                }
            }
        }
        Matrix swap1 = this.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        Matrix swap3 = this.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        LinearTransform step1 = swap1 != null ? this.factory.createAffineTransform(swap1) : MathTransforms.identity(normalized.getSourceDimensions());
        LinearTransform step3 = swap3 != null ? this.factory.createAffineTransform(swap3) : MathTransforms.identity(normalized.getTargetDimensions());
        MathTransform step2 = normalized;
        if (this.provider instanceof VerticalOffset) {
            step2 = VerticalOffset.postCreate(step2, swap3);
        }
        int sourceDim = step1.getTargetDimensions();
        int neededDim = step2.getSourceDimensions();
        int kernelDim = step2.getTargetDimensions();
        int resultDim = step3.getSourceDimensions();
        if (sourceDim == 2 && neededDim > 2 && (change = this.addOrRemoveVertical(this.sourceCS, this.sourceEllipsoid, this.targetEllipsoid, false)) != null) {
            step1 = this.factory.createConcatenatedTransform((MathTransform)step1, change);
            sourceDim = step1.getTargetDimensions();
        }
        if (kernelDim == 3 && resultDim < 3 && (change = this.addOrRemoveVertical(this.targetCS, this.targetEllipsoid, this.sourceEllipsoid, true)) != null) {
            step3 = this.factory.createConcatenatedTransform(change, (MathTransform)step3);
            resultDim = step3.getSourceDimensions();
        }
        if ((numTrailingCoordinates = resultDim - kernelDim) != 0) {
            this.ensureDimensionChangeAllowed(numTrailingCoordinates, resultDim, normalized);
            step2 = numTrailingCoordinates > 0 ? this.factory.createPassThroughTransform(0, step2, numTrailingCoordinates) : this.factory.createConcatenatedTransform(step2, this.addOrRemoveDimensions(kernelDim, resultDim));
            neededDim = step2.getSourceDimensions();
            kernelDim = step2.getTargetDimensions();
        }
        if (sourceDim != neededDim) {
            this.ensureDimensionChangeAllowed(neededDim - sourceDim, neededDim, normalized);
            step1 = this.factory.createConcatenatedTransform((MathTransform)step1, this.addOrRemoveDimensions(sourceDim, neededDim));
        }
        if (kernelDim != resultDim) {
            this.ensureDimensionChangeAllowed(resultDim - kernelDim, resultDim, normalized);
            step3 = this.factory.createConcatenatedTransform(this.addOrRemoveDimensions(kernelDim, resultDim), (MathTransform)step3);
        }
        MathTransform mt = this.factory.createConcatenatedTransform(this.factory.createConcatenatedTransform((MathTransform)step1, step2), (MathTransform)step3);
        if (normalized instanceof ParameterizedAffine && !(mt instanceof ParameterizedAffine)) {
            return ((ParameterizedAffine)normalized).newTransform(mt);
        }
        return mt;
    }

    private MathTransform addOrRemoveVertical(CoordinateSystem cs, Ellipsoid ellipsoid, Ellipsoid fallback, boolean remove) throws FactoryException {
        MathTransform tr;
        if (ellipsoid == null) {
            ellipsoid = fallback;
        }
        if (cs instanceof EllipsoidalCS) {
            MatrixSIS resize = Matrices.createDiagonal(4, 3);
            resize.setElement(3, 2, 1.0);
            resize.setElement(2, 2, 0.0);
            tr = this.factory.createAffineTransform((Matrix)resize);
        } else if (ellipsoid != null && cs instanceof SphericalCS) {
            tr = EllipsoidToRadiusTransform.createGeodeticConversion(this.factory, ellipsoid);
        } else {
            return null;
        }
        if (remove) {
            try {
                tr = tr.inverse();
            }
            catch (NoninvertibleTransformException cause) {
                throw new FactoryException(cause.getMessage(), (Throwable)cause);
            }
        }
        return tr;
    }

    private MathTransform addOrRemoveDimensions(int sourceDim, int targetDim) throws FactoryException {
        MatrixSIS resize = Matrices.createDiagonal(targetDim + 1, sourceDim + 1);
        if (sourceDim < targetDim) {
            for (int j = sourceDim; j < targetDim; ++j) {
                resize.setElement(j, sourceDim, Double.NaN);
            }
        } else {
            resize.setElement(targetDim, targetDim, 0.0);
        }
        resize.setElement(targetDim, sourceDim, 1.0);
        return this.factory.createAffineTransform((Matrix)resize);
    }

    private void ensureDimensionChangeAllowed(int change, int resultDim, MathTransform normalized) throws FactoryException {
        if (Math.abs(change) == 1 && resultDim >= 2 && resultDim <= 3 && (this.sourceCS instanceof EllipsoidalCS || this.targetCS instanceof EllipsoidalCS)) {
            return;
        }
        String name = null;
        if (normalized instanceof Parameterized) {
            name = IdentifiedObjects.getDisplayName((IdentifiedObject)((Parameterized)normalized).getParameterDescriptors(), null);
        }
        if (name == null) {
            name = Classes.getShortClassName((Object)normalized);
        }
        StringBuilder b = new StringBuilder();
        this.getSourceDimensions().ifPresent(dim -> b.append(dim).append("D \u2192 "));
        b.append("tr(").append(normalized.getSourceDimensions()).append("D \u2192 ").append(normalized.getTargetDimensions()).append("D)");
        this.getTargetDimensions().ifPresent(dim -> b.append(" \u2192 ").append(dim).append('D'));
        throw new InvalidGeodeticParameterException(Resources.format((short)95, name, b));
    }

    @Override
    public String toString() {
        Object[] properties = new Object[]{"sourceCS", this.sourceCS, "sourceEllipsoid", this.sourceEllipsoid, "targetCS", this.targetCS, "targetEllipsoid", this.targetEllipsoid};
        for (int i = 1; i < properties.length; i += 2) {
            IdentifiedObject value = (IdentifiedObject)properties[i];
            if (value == null) continue;
            properties[i] = value.getName();
        }
        String text = Strings.toString(this.getClass(), (Object[])properties);
        if (!this.contextualParameters.isEmpty()) {
            StringBuilder b = new StringBuilder(text);
            boolean isContextual = true;
            do {
                boolean first = true;
                for (Map.Entry<String, Boolean> entry : this.contextualParameters.entrySet()) {
                    if (entry.getValue() != isContextual) continue;
                    if (first) {
                        first = false;
                        b.append(System.lineSeparator()).append(isContextual ? "Contextual parameters" : "Inconsistencies").append(": ");
                    } else {
                        b.append(", ");
                    }
                    b.append(entry.getKey());
                }
            } while (!(isContextual = !isContextual));
            text = b.toString();
        }
        return text;
    }
}

