/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.referencing;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import org.apache.sis.metadata.internal.shared.Identifiers;
import org.apache.sis.metadata.internal.shared.NameMeaning;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.internal.shared.DefinitionURI;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;

@XmlType(name="CodeType")
public final class Code {
    @XmlValue
    public String code;
    @XmlAttribute
    public String codeSpace;

    public Code() {
    }

    Code(ReferenceIdentifier identifier) {
        this.code = identifier.getCode();
        this.codeSpace = identifier.getCodeSpace();
        String version = identifier.getVersion();
        if (version != null) {
            StringBuilder buffer = new StringBuilder();
            if (this.codeSpace != null) {
                buffer.append(this.codeSpace);
            }
            this.codeSpace = buffer.append(':').append(version).toString();
        }
    }

    public ReferenceIdentifier getIdentifier() {
        String c = this.code;
        if (c == null) {
            return null;
        }
        Object authority = null;
        String version = null;
        String cs = this.codeSpace;
        DefinitionURI parsed = DefinitionURI.parse((String)c);
        if (parsed != null && parsed.code != null) {
            authority = Identifiers.isEPSG((String)cs, (String)parsed.authority) ? Citations.EPSG : Citations.fromName((String)cs);
            cs = parsed.authority;
            version = parsed.version;
            c = parsed.code;
        } else if (cs != null) {
            int s = cs.lastIndexOf(58);
            if (s >= 0) {
                version = cs.substring(s + 1);
                cs = cs.substring(0, s);
            }
            authority = Citations.fromName((String)cs);
        }
        return new NamedIdentifier((Citation)authority, cs, (CharSequence)c, version, null);
    }

    public static Code forIdentifiedObject(Class<?> type, Iterable<? extends ReferenceIdentifier> identifiers) {
        if (identifiers != null) {
            boolean isHTTP = false;
            boolean isEPSG = false;
            ReferenceIdentifier fallback = null;
            for (ReferenceIdentifier referenceIdentifier : identifiers) {
                String code = referenceIdentifier.getCode();
                if (code == null) continue;
                if (code.regionMatches(true, 0, "urn:", 0, 4)) {
                    return new Code(referenceIdentifier);
                }
                if (isHTTP) continue;
                isHTTP = code.regionMatches(true, 0, "http:", 0, 5);
                if (isHTTP) {
                    fallback = referenceIdentifier;
                    continue;
                }
                if (isEPSG || !(isEPSG = "EPSG".equalsIgnoreCase(referenceIdentifier.getCodeSpace())) && fallback != null) continue;
                fallback = referenceIdentifier;
            }
            if (fallback != null) {
                String urn;
                if (!isHTTP && (urn = NameMeaning.toURN(type, (String)fallback.getCodeSpace(), (String)fallback.getVersion(), (String)fallback.getCode())) != null) {
                    Code code = new Code();
                    Citation authority = fallback.getAuthority();
                    if (isEPSG) {
                        code.codeSpace = "IOGP";
                        if (authority != null) {
                            for (Identifier id : authority.getIdentifiers()) {
                                String cs;
                                if (!"EPSG".equalsIgnoreCase(id.getCode()) || !(id instanceof ReferenceIdentifier) || (cs = ((ReferenceIdentifier)id).getCodeSpace()) == null) continue;
                                code.codeSpace = cs;
                                break;
                            }
                        }
                    } else {
                        code.codeSpace = Citations.toCodeSpace((Citation)authority);
                    }
                    code.code = urn;
                    return code;
                }
                return new Code(fallback);
            }
        }
        return null;
    }

    public String toString() {
        if (this.code == null) {
            return this.codeSpace;
        }
        if (this.codeSpace == null || DefinitionURI.isAbsolute((String)this.code)) {
            return this.code;
        }
        return this.codeSpace + ":" + this.code;
    }
}

