/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.sis.console.Command;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.setup.About;
import org.apache.sis.system.DataDirectory;
import org.apache.sis.system.SupervisorMBean;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.shared.X364;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;

final class AboutCommand
extends CommandRunner {
    AboutCommand(int commandIndex, Object[] arguments) throws InvalidOptionException {
        super(commandIndex, arguments, EnumSet.of(Option.LOCALE, new Option[]{Option.TIMEZONE, Option.ENCODING, Option.BRIEF, Option.VERBOSE, Option.HELP, Option.DEBUG}));
    }

    @Override
    public int run() throws Exception {
        String configuration;
        DataDirectory.quiet();
        boolean brief = this.options.containsKey((Object)Option.BRIEF);
        if (this.hasUnexpectedFileCount(0, brief ? 0 : 1)) {
            return 3;
        }
        String[] warnings = null;
        if (brief && this.files.isEmpty()) {
            configuration = Vocabulary.forLocale((Locale)this.locale).getString((short)218, (Object)"Apache SIS", (Object)Version.SIS);
        } else {
            EnumSet<About> sections = EnumSet.allOf(About.class);
            if (!this.options.containsKey((Object)Option.VERBOSE)) {
                sections.remove(About.LIBRARIES);
            }
            if (this.files.isEmpty()) {
                configuration = About.configuration(sections, (Locale)this.locale, (TimeZone)this.getTimeZone()).toString();
            } else {
                TreeTable table;
                String address = IOUtilities.toString(this.files.get(0));
                if (address == null) {
                    return 3;
                }
                String path = AboutCommand.toRemoteURL(address);
                long l = System.nanoTime();
                try {
                    JMXServiceURL url = new JMXServiceURL(path);
                    try (JMXConnector jmxc = JMXConnectorFactory.connect(url);){
                        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
                        SupervisorMBean bean = JMX.newMBeanProxy(mbsc, new ObjectName("org.apache.sis:type=Supervisor"), SupervisorMBean.class);
                        table = bean.configuration(sections, this.locale, this.getTimeZone());
                        warnings = bean.warnings(this.locale);
                    }
                }
                catch (IOException e) {
                    this.error(Errors.format((short)10, (Object)path), e);
                    return 100;
                }
                double delay = (double)(System.nanoTime() - l) / 1.0E9;
                if (delay >= 0.1) {
                    double scale = delay >= 10.0 ? 1.0 : (delay >= 1.0 ? 10.0 : 100.0);
                    delay = Math.rint(delay * scale) / scale;
                }
                LogRecord record = Messages.forLocale((Locale)this.locale).createLogRecord(Level.INFO, (short)5, (Object)address, (Object)new Date(), (Object)delay);
                record.setLoggerName("org.apache.sis.application");
                Logging.completeAndLog(null, Command.class, (String)"main", (LogRecord)record);
                table.getRoot().setValue(TableColumn.NAME, (Object)Vocabulary.forLocale((Locale)this.locale).getString((short)170));
                configuration = table.toString();
            }
        }
        this.out.println(configuration);
        if (warnings != null) {
            this.out.println();
            if (this.colors) {
                this.color(X364.BACKGROUND_RED);
                this.color(X364.BOLD);
                this.out.print('\u00a0');
            }
            Vocabulary.forLocale((Locale)this.locale).appendLabel((short)222, (Appendable)this.out);
            if (this.colors) {
                this.out.print('\u00a0');
                this.out.println(X364.RESET.sequence());
                this.color(X364.FOREGROUND_RED);
            } else {
                this.out.println();
            }
            for (void var7_10 : warnings) {
                this.out.println((String)var7_10);
            }
            this.color(X364.FOREGROUND_DEFAULT);
        }
        this.out.flush();
        return 0;
    }

    static String toRemoteURL(String host) {
        StringBuilder buffer = new StringBuilder(60).append("service:jmx:rmi:///jndi/rmi://").append(host, host.regionMatches(true, 0, "localhost", 0, 9) ? 9 : 0, host.length());
        if (host.lastIndexOf(58) < 0) {
            buffer.append(':').append(1099);
        }
        return buffer.append("/jmxrmi").toString();
    }
}

