/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

public class IntegerList
extends AbstractList<Integer>
implements RandomAccess,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1241962316404811189L;
    private static final int VALUE_SIZE = 64;
    private static final int BASE_SHIFT = 6;
    private static final int OFFSET_MASK = 63;
    private long[] values;
    private final int bitCount;
    private final int mask;
    private int size;

    public IntegerList(int initialCapacity, int maximalValue) {
        this(initialCapacity, maximalValue, false);
    }

    public IntegerList(int initialCapacity, int maximalValue, boolean fill) {
        ArgumentChecks.ensureStrictlyPositive("initialCapacity", initialCapacity);
        ArgumentChecks.ensureStrictlyPositive("maximalValue", maximalValue);
        this.bitCount = Math.max(1, 32 - Integer.numberOfLeadingZeros(maximalValue));
        this.mask = (1 << this.bitCount) - 1;
        this.values = new long[this.length(initialCapacity)];
        if (fill) {
            this.size = initialCapacity;
        }
    }

    private int length(int capacity) {
        int length = (capacity *= this.bitCount) >>> 6;
        if ((capacity & 0x3F) != 0) {
            ++length;
        }
        return length;
    }

    public int maximalValue() {
        return this.mask;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void resize(int size) {
        ArgumentChecks.ensurePositive("size", size);
        ++this.modCount;
        if (size > this.size) {
            int base = this.size * this.bitCount;
            int offset = base & 0x3F;
            if (offset != 0 && (base >>>= 6) < this.values.length) {
                int n = base++;
                this.values[n] = this.values[n] & (1L << offset) - 1L;
            }
            int length = this.length(size);
            Arrays.fill(this.values, base, Math.min(length, this.values.length), 0L);
            if (length > this.values.length) {
                this.values = Arrays.copyOf(this.values, length);
            }
        }
        this.size = size;
    }

    public void fill(int value) {
        long p;
        ArgumentChecks.ensureBetween("value", 0, this.mask, value);
        ++this.modCount;
        if (value == 0) {
            p = 0L;
        } else if (value == this.mask) {
            p = -1L;
        } else {
            switch (this.bitCount) {
                case 1: {
                    value |= value << 1;
                }
                case 2: {
                    value |= value << 2;
                }
                case 4: {
                    value |= value << 4;
                }
                case 8: {
                    value |= value << 8;
                }
                case 16: {
                    value |= value << 16;
                }
                case 32: {
                    p = (long)value & 0xFFFFFFFFL | (long)value << 32;
                    break;
                }
                default: {
                    for (int i = 0; i < this.size; ++i) {
                        this.setUnchecked(i, value);
                    }
                    return;
                }
            }
        }
        Arrays.fill(this.values, 0, this.length(this.size), p);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public boolean add(Integer value) throws IllegalArgumentException {
        this.addInt(value);
        return true;
    }

    public void addInt(int value) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("value", 0, this.mask, value);
        ++this.modCount;
        int last = this.size++;
        int length = this.length(this.size);
        if (length > this.values.length) {
            this.values = Arrays.copyOf(this.values, 2 * this.values.length);
        }
        this.setUnchecked(last, value);
    }

    @Override
    public Integer get(int index) throws IndexOutOfBoundsException {
        return this.getInt(index);
    }

    @Override
    public Integer getFirst() {
        if (this.size != 0) {
            return this.getUnchecked(0);
        }
        throw new NoSuchElementException();
    }

    @Override
    public Integer getLast() {
        if (this.size != 0) {
            return this.getUnchecked(this.size - 1);
        }
        throw new NoSuchElementException();
    }

    public int getInt(int index) throws IndexOutOfBoundsException {
        return this.getUnchecked(Objects.checkIndex(index, this.size));
    }

    private int getUnchecked(int index) {
        int base = (index *= this.bitCount) >>> 6;
        int offset = index & 0x3F;
        int value = (int)(this.values[base] >>> offset);
        if ((offset = 64 - offset) < this.bitCount) {
            int high = (int)this.values[++base];
            value |= high << offset;
        }
        return value &= this.mask;
    }

    @Override
    public Integer set(int index, Integer value) throws IndexOutOfBoundsException {
        Integer old = this.get(index);
        this.setInt(index, value);
        return old;
    }

    public void setInt(int index, int value) throws IndexOutOfBoundsException {
        Objects.checkIndex(index, this.size);
        ArgumentChecks.ensureBetween("value", 0, this.mask, value);
        ++this.modCount;
        this.setUnchecked(index, value);
    }

    private void setUnchecked(int index, int value) {
        int base = (index *= this.bitCount) >>> 6;
        int offset = index & 0x3F;
        int n = base;
        this.values[n] = this.values[n] & ((long)this.mask << offset ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = base++;
        this.values[n2] = this.values[n2] | (long)value << offset;
        if ((offset = 64 - offset) < this.bitCount) {
            int n3 = base;
            this.values[n3] = this.values[n3] & ((long)this.mask >>> offset ^ 0xFFFFFFFFFFFFFFFFL);
            int n4 = base;
            this.values[n4] = this.values[n4] | (long)(value >>>= offset);
        }
    }

    @Override
    public Integer remove(int index) throws IndexOutOfBoundsException {
        Integer old = this.get(index);
        ++this.modCount;
        this.removeRange(index, index + 1);
        return old;
    }

    @Override
    public Integer removeFirst() throws NoSuchElementException {
        if (this.size != 0) {
            ++this.modCount;
            return this.getUnchecked(0);
        }
        throw new NoSuchElementException();
    }

    @Override
    public Integer removeLast() throws NoSuchElementException {
        if (this.size != 0) {
            ++this.modCount;
            return this.getUnchecked(--this.size);
        }
        throw new NoSuchElementException();
    }

    @Override
    protected void removeRange(int lower, int upper) {
        Objects.checkFromToIndex(lower, upper, this.size);
        int lo = lower * this.bitCount;
        int hi = upper * this.bitCount;
        int offset = lo & 0x3F;
        if (offset == (hi & 0x3F)) {
            long mask = (1L << offset) - 1L;
            long save = this.values[lo >>>= 6] & mask;
            System.arraycopy(this.values, hi >>>= 6, this.values, lo, this.length(this.size) - hi);
            this.values[lo] = this.values[lo] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | save;
        } else {
            while (upper < this.size) {
                this.setUnchecked(lower++, this.getUnchecked(upper++));
            }
        }
        this.size -= upper - lower;
    }

    public int occurrence(int value) {
        int count = 0;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            if (this.getUnchecked(i) != value) continue;
            ++count;
        }
        return count;
    }

    public PrimitiveIterator.OfInt iterator() {
        return new PrimitiveSpliterator();
    }

    public Spliterator.OfInt spliterator() {
        return new PrimitiveSpliterator();
    }

    public IntStream stream(boolean parallel) {
        return StreamSupport.intStream(this.spliterator(), parallel);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    public void trimToSize() {
        this.values = ArraysExt.resize(this.values, this.length(this.size));
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            IntegerList that = (IntegerList)other;
            if (that.size != this.size) {
                return false;
            }
            if (that.bitCount == this.bitCount) {
                int n = this.size * this.bitCount;
                int nr = n & 0x3F;
                if (!Arrays.equals(this.values, 0, n >>>= 6, that.values, 0, n)) {
                    return false;
                }
                if (nr == 0) {
                    return true;
                }
                return ((that.values[n] ^ this.values[n]) & (1L << nr) - 1L) == 0L;
            }
        }
        return super.equals(other);
    }

    public IntegerList clone() {
        IntegerList clone;
        try {
            clone = (IntegerList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        clone.values = Arrays.copyOf(this.values, this.length(this.size));
        clone.modCount = 0;
        return clone;
    }

    private final class PrimitiveSpliterator
    implements Spliterator.OfInt,
    PrimitiveIterator.OfInt {
        private int stopAt;
        private int nextIndex;
        private int expectedModCount;
        private int lastRemove;

        PrimitiveSpliterator() {
            this.expectedModCount = IntegerList.this.modCount;
            this.stopAt = IntegerList.this.size;
        }

        private PrimitiveSpliterator(PrimitiveSpliterator suffix, int startAt) {
            this.expectedModCount = suffix.expectedModCount;
            this.stopAt = suffix.nextIndex;
            this.nextIndex = startAt;
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return this.stopAt - this.nextIndex;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            int startAt = this.nextIndex;
            int halfSize = this.stopAt - startAt >>> 1;
            if (halfSize > 1) {
                this.nextIndex += halfSize;
                return new PrimitiveSpliterator(this, startAt);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (IntegerList.this.modCount == this.expectedModCount) {
                return this.nextIndex < this.stopAt;
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                return IntegerList.this.getUnchecked(this.nextIndex++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            boolean canAdvance = this.hasNext();
            if (canAdvance) {
                action.accept(IntegerList.this.getUnchecked(this.nextIndex++));
            }
            return canAdvance;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            while (this.hasNext()) {
                action.accept(IntegerList.this.getUnchecked(this.nextIndex++));
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> action) {
            if (action instanceof IntConsumer) {
                this.forEachRemaining((IntConsumer)((Object)action));
            } else {
                while (this.hasNext()) {
                    action.accept((Integer)IntegerList.this.getUnchecked(this.nextIndex++));
                }
            }
        }

        @Override
        public void remove() {
            if (this.nextIndex < this.lastRemove || this.nextIndex > this.stopAt) {
                throw new IllegalStateException();
            }
            if (IntegerList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IntegerList.this.modCount;
            IntegerList.this.removeRange(this.nextIndex - 1, this.nextIndex);
            this.lastRemove = --this.nextIndex;
            --this.stopAt;
        }
    }
}

