/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.function.BiFunction;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.ComparisonMode;

public final class Numerics {
    public static final int MAXIMUM_MATRIX_SIZE = Short.MAX_VALUE;
    public static final double COMPARISON_THRESHOLD = 1.0E-13;
    public static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    public static final long HIGH_BITS_MASK = -4294967296L;
    public static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    public static final int SIGNIFICAND_MASK_OF_FLOAT = 0x7FFFFF;
    public static final int MAX_INTEGER_CONVERTIBLE_TO_FLOAT = 0x1000000;
    public static final long MAX_INTEGER_CONVERTIBLE_TO_DOUBLE = 0x20000000000000L;
    public static final int LONG_SHIFT = 6;
    public static final int INT_SHIFT = 5;

    private Numerics() {
    }

    public static long bitmask(int bit) {
        return (bit & 0xFFFFFFC0) == 0 ? 1L << bit : 0L;
    }

    public static long tuple(int hi, int low) {
        return (long)hi << 32 | Integer.toUnsignedLong(low);
    }

    public static boolean isInteger(double x) {
        return x == Math.rint(x);
    }

    public static int snapToCeil(int value, int divisor) {
        int r = value % divisor;
        value = r > 0 ? (value += Math.abs(divisor) - r) : (value -= r);
        return value;
    }

    public static int wholeDiv(int x, int y) {
        if (x % y != 0) {
            throw new ArithmeticException(x + " % " + y + " \u2260 0");
        }
        return x / y;
    }

    public static long multiplyDivide(long value, long multiplier, long divisor) {
        try {
            return Math.multiplyExact(value, multiplier) / divisor;
        }
        catch (ArithmeticException e) {
            return BigInteger.valueOf(value).multiply(BigInteger.valueOf(multiplier)).divide(BigInteger.valueOf(divisor)).longValueExact();
        }
    }

    public static long saturatingAdd(long x, long y) {
        long result = x + y;
        if (((x ^ result) & (y ^ result)) >= 0L) {
            return result;
        }
        return result < x ? Long.MAX_VALUE : Long.MIN_VALUE;
    }

    public static long saturatingSubtract(long x, long y) {
        long result = x - y;
        if (((x ^ y) & (x ^ result)) >= 0L) {
            return result;
        }
        return result < x ? Long.MAX_VALUE : Long.MIN_VALUE;
    }

    public static long roundAndClamp(double value) {
        return Math.max(-9007199254740992L, Math.min(0x20000000000000L, Math.round(value)));
    }

    public static int clamp(long value) {
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }

    public static Number fraction(long numerator, long denominator) {
        try {
            return Fraction.valueOf(numerator, denominator).unique();
        }
        catch (ArithmeticException e) {
            return (double)numerator / (double)denominator;
        }
    }

    public static boolean equals(float v1, float v2) {
        return Float.floatToIntBits(v1) == Float.floatToIntBits(v2);
    }

    public static boolean equals(double v1, double v2) {
        return Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static boolean equalsIgnoreZeroSign(double v1, double v2) {
        return v1 == v2 || Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static boolean epsilonEqual(double v1, double v2, double threshold) {
        return Math.abs(v1 - v2) <= threshold || Numerics.equals(v1, v2);
    }

    public static boolean epsilonEqual(double v1, double v2, ComparisonMode mode) {
        double mg;
        if (mode.isApproximate() && (mg = Math.max(Math.abs(v1), Math.abs(v2))) != Double.POSITIVE_INFINITY) {
            return Numerics.epsilonEqual(v1, v2, 1.0E-13 * mg);
        }
        return Numerics.equals(v1, v2);
    }

    public static String messageForDifference(String name, double v1, double v2) {
        StringBuilder builder = new StringBuilder();
        if (name != null) {
            builder.append(name).append(": ");
        }
        builder.append("values ").append(v1).append(" and ").append(v2).append(" differ");
        float delta = (float)Math.abs(v1 - v2);
        if (delta < Float.POSITIVE_INFINITY) {
            builder.append(" by ").append(delta);
        }
        return builder.toString();
    }

    public static float toUnsignedFloat(long value) {
        if (value >= 0L) {
            return value;
        }
        return Float.parseFloat(Long.toUnsignedString(value));
    }

    public static double toUnsignedDouble(long value) {
        if (value >= 0L) {
            return value;
        }
        return Double.parseDouble(Long.toUnsignedString(value));
    }

    public static int toExp10(int exp2) {
        assert (exp2 >= -2620 && exp2 <= 2620) : exp2;
        return exp2 * 315653 >> 20;
    }

    public static long getSignificand(double value) {
        long bits = Double.doubleToRawLongBits(value);
        long exponent = bits & 0x7FF0000000000000L;
        bits &= 0xFFFFFFFFFFFFFL;
        bits = exponent != 0L ? (bits |= 0x10000000000000L) : (bits <<= 1);
        return bits;
    }

    public static int getSignificand(float value) {
        int bits = Float.floatToRawIntBits(value);
        int exponent = bits & 0x7F800000;
        bits &= 0x7FFFFF;
        bits = exponent != 0 ? (bits |= 0x800000) : (bits <<= 1);
        return bits;
    }

    public static int fractionDigitsForDelta(double ulp) {
        return ulp != 0.0 ? Math.max(0, Math.min(16, DecimalFunctions.fractionDigitsForDelta(ulp, false))) : 0;
    }

    public static int suggestFractionDigits(double ... values) {
        double ulp = 0.0;
        if (values != null) {
            for (double v : values) {
                double e = Math.ulp(v);
                if (!(e > ulp) || e == Double.POSITIVE_INFINITY) continue;
                ulp = e;
            }
        }
        return Numerics.fractionDigitsForDelta(ulp);
    }

    public static int suggestFractionDigits(Statistics stats) {
        double minimum = stats.minimum();
        double maximum = stats.maximum();
        double delta = stats.standardDeviation(true);
        if (delta == 0.0) {
            delta = stats.span();
            if (delta == 0.0) {
                delta = Math.abs(maximum) / 1000000.0;
            }
        } else {
            double mean = stats.mean();
            delta *= 2.0;
            delta = Math.min(maximum, mean + delta) - Math.max(minimum, mean - delta);
            delta /= Math.min((double)stats.count() * 100.0, 1000000.0);
            delta = Math.max(delta, Math.max(Math.ulp(minimum), Math.ulp(maximum)));
        }
        return Numerics.fractionDigitsForDelta(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String useScientificNotationIfNeeded(Format format, Object value, BiFunction<Format, Object, String> action) {
        if (value instanceof Number && format instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)format;
            int maxFD = df.getMaximumFractionDigits();
            double m = Math.abs(((Number)value).doubleValue());
            if (m > 0.0 && (m >= 1.0E9 || m < MathFunctions.pow10(-Math.min(maxFD, 6)))) {
                int minFD = df.getMinimumFractionDigits();
                String pattern = df.toPattern();
                try {
                    df.applyPattern("0.######E00");
                    if (maxFD > 0) {
                        df.setMinimumFractionDigits(minFD);
                        df.setMaximumFractionDigits(maxFD);
                    }
                    String string = action.apply(format, value);
                    return string;
                }
                finally {
                    df.applyPattern(pattern);
                }
            }
        }
        return action.apply(format, value);
    }
}

