/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.Displacement;
import org.apache.sis.style.se1.Fill;
import org.apache.sis.style.se1.Stroke;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Symbolizer;

@XmlType(name="PolygonSymbolizerType", propOrder={"fill", "stroke", "displacement", "perpendicularOffset"})
@XmlRootElement(name="PolygonSymbolizer")
public class PolygonSymbolizer<R>
extends Symbolizer<R> {
    @XmlElement(name="Fill")
    protected Fill<R> fill;
    private boolean isFillSet;
    @XmlElement(name="Stroke")
    protected Stroke<R> stroke;
    private boolean isStrokeSet;
    @XmlElement(name="Displacement")
    protected Displacement<R> displacement;
    @XmlElement(name="PerpendicularOffset")
    protected Expression<R, ? extends Number> perpendicularOffset;

    private void beforeMarshal(Marshaller caller) {
        if (this.fill == null && !this.isFillSet) {
            this.fill = this.factory.createFill();
        }
        if (this.stroke == null && !this.isStrokeSet) {
            this.stroke = this.factory.createStroke();
        }
    }

    private PolygonSymbolizer() {
        this.isFillSet = true;
        this.isStrokeSet = true;
    }

    public PolygonSymbolizer(StyleFactory<R> factory) {
        super(factory);
    }

    public PolygonSymbolizer(PolygonSymbolizer<R> source) {
        super(source);
        this.fill = source.fill;
        this.stroke = source.stroke;
        this.isFillSet = source.isFillSet;
        this.isStrokeSet = source.isStrokeSet;
        this.displacement = source.displacement;
        this.perpendicularOffset = source.perpendicularOffset;
    }

    public Optional<Fill<R>> getFill() {
        if (!this.isFillSet) {
            this.isFillSet = true;
            this.fill = this.factory.createFill();
        }
        return Optional.ofNullable(this.fill);
    }

    public void setFill(Fill<R> value) {
        this.isFillSet = true;
        this.fill = value;
    }

    public Optional<Stroke<R>> getStroke() {
        if (!this.isStrokeSet) {
            this.isStrokeSet = true;
            this.stroke = this.factory.createStroke();
        }
        return Optional.ofNullable(this.stroke);
    }

    public void setStroke(Stroke<R> value) {
        this.isStrokeSet = true;
        this.stroke = value;
    }

    public Displacement<R> getDisplacement() {
        if (this.displacement == null) {
            this.displacement = this.factory.createDisplacement();
        }
        return this.displacement;
    }

    public void setDisplacement(Displacement<R> value) {
        this.displacement = value;
    }

    public Expression<R, ? extends Number> getPerpendicularOffset() {
        return this.defaultToZero(this.perpendicularOffset);
    }

    public void setPerpendicularOffset(Expression<R, ? extends Number> value) {
        this.perpendicularOffset = value;
    }

    @Override
    public boolean isVisible() {
        return this.fill != null || this.stroke != null || !(this.isFillSet | this.isStrokeSet);
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.fill, this.isFillSet, this.stroke, this.isStrokeSet, this.displacement, this.perpendicularOffset};
    }

    @Override
    public PolygonSymbolizer<R> clone() {
        PolygonSymbolizer clone = (PolygonSymbolizer)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.stroke != null) {
            this.stroke = this.stroke.clone();
        }
        if (this.fill != null) {
            this.fill = this.fill.clone();
        }
        if (this.displacement != null) {
            this.displacement = this.displacement.clone();
        }
    }
}

