/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.text.NumberFormat;
import java.util.Optional;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.coverage.CellFormat;
import org.apache.sis.gui.coverage.GridControls;
import org.apache.sis.gui.coverage.GridTile;
import org.apache.sis.gui.coverage.GridTileCache;
import org.apache.sis.gui.coverage.GridViewSkin;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.image.DataType;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.Numerics;

@DefaultProperty(value="image")
public class GridView
extends Control {
    private ImageLoader loader;
    public final ObjectProperty<RenderedImage> imageProperty;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int tileWidth;
    private int tileHeight;
    private int tileGridXOffset;
    private int tileGridYOffset;
    private final GridTileCache tiles;
    private GridTile lastTile;
    public final IntegerProperty bandProperty;
    public final DoubleProperty headerWidth;
    public final DoubleProperty cellWidth;
    public final DoubleProperty cellHeight;
    public final DoubleProperty cellSpacing;
    public final ObjectProperty<Paint> headerBackground;
    private final NumberFormat headerFormat;
    final CellFormat cellFormat;
    final GridControls controls;

    public GridView() {
        this(null);
    }

    GridView(GridControls controls) {
        this.controls = controls;
        this.bandProperty = new BandProperty();
        this.imageProperty = new SimpleObjectProperty((Object)this, "image");
        this.headerWidth = new SimpleDoubleProperty((Object)this, "headerWidth", 80.0);
        this.cellWidth = new SimpleDoubleProperty((Object)this, "cellWidth", 60.0);
        this.cellHeight = new SimpleDoubleProperty((Object)this, "cellHeight", 20.0);
        this.cellSpacing = new SimpleDoubleProperty((Object)this, "cellSpacing", 4.0);
        this.headerBackground = new SimpleObjectProperty((Object)this, "headerBackground", (Object)Color.GAINSBORO);
        this.headerFormat = NumberFormat.getIntegerInstance();
        this.cellFormat = new CellFormat(this);
        this.tiles = new GridTileCache();
        this.tileWidth = 1;
        this.tileHeight = 1;
        this.setMinSize(120.0, 40.0);
        this.imageProperty.addListener((p, o, n) -> this.onImageSpecified((RenderedImage)n));
    }

    public final RenderedImage getImage() {
        return (RenderedImage)this.imageProperty.get();
    }

    public final void setImage(RenderedImage image) {
        this.imageProperty.set((Object)image);
    }

    public void setImage(ImageRequest source) {
        if (source == null) {
            this.setImage((RenderedImage)null);
            if (this.controls != null) {
                this.controls.notifyDataChanged(null, null);
            }
        } else {
            this.cancelLoader();
            this.loader = new ImageLoader(source);
            BackgroundThreads.execute((Runnable)((Object)this.loader));
        }
    }

    private void setLoadedImage(GridCoverageResource resource, GridCoverage coverage, RenderedImage image) {
        this.loader = null;
        this.setImage(image);
        if (this.controls != null && !this.controls.isAdjustingSlice) {
            this.controls.notifyDataChanged(resource, coverage);
        }
    }

    public final int getBand() {
        return this.bandProperty.get();
    }

    public final void setBand(int index) {
        this.bandProperty.set(index);
    }

    private void cancelLoader() {
        ImageLoader previous = this.loader;
        if (previous != null) {
            this.loader = null;
            previous.cancel(false);
        }
    }

    private void onImageSpecified(RenderedImage image) {
        Skin skin;
        this.cancelLoader();
        this.tiles.clear();
        this.lastTile = null;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        if (image != null) {
            this.tileWidth = Math.max(1, image.getTileWidth());
            this.tileHeight = Math.max(1, image.getTileHeight());
            this.tileGridXOffset = image.getTileGridXOffset();
            this.tileGridYOffset = image.getTileGridYOffset();
            this.cellFormat.dataTypeIsInteger = false;
            SampleModel sm = image.getSampleModel();
            if (sm != null) {
                int numBands = sm.getNumBands();
                if (this.getBand() >= numBands) {
                    ((BandProperty)this.bandProperty).setNoCheck(numBands - 1);
                }
                this.cellFormat.dataTypeIsInteger = DataType.isInteger((SampleModel)sm);
            }
            this.cellFormat.configure(image, this.getBand());
            this.minX = image.getMinX();
            this.maxX = Math.addExact(this.minX, image.getWidth());
            this.minY = image.getMinY();
            this.maxY = Math.addExact(this.minY, image.getHeight());
        }
        if ((skin = this.getSkin()) instanceof GridViewSkin) {
            ((GridViewSkin)skin).clear();
        }
        this.requestLayout();
    }

    final void updateCellValues() {
        Skin skin = this.getSkin();
        if (skin instanceof GridViewSkin) {
            ((GridViewSkin)skin).updateCellValues();
        }
    }

    final void scaleScrollBar(ScrollBar bar, int numCells, boolean vertical) {
        int max;
        int min;
        if (vertical) {
            min = this.minY;
            max = this.maxY;
        } else {
            min = this.minX;
            max = this.maxX;
        }
        if (max > min) {
            numCells = Math.max(1, Math.min(numCells - 2, max));
            bar.setMin((double)min);
            bar.setMax((double)(max -= numCells));
            bar.setVisibleAmount((double)numCells);
            double value = bar.getValue();
            if (value < (double)min) {
                value = min;
            } else if (value > (double)max) {
                value = max;
            } else {
                return;
            }
            bar.setValue(value);
        }
    }

    final Rectangle getTileBounds(int tileX, int tileY) {
        return new Rectangle(Numerics.clamp((long)((long)this.tileGridXOffset + Math.multiplyFull(tileX, this.tileWidth))), Numerics.clamp((long)((long)this.tileGridYOffset + Math.multiplyFull(tileY, this.tileHeight))), this.tileWidth, this.tileHeight);
    }

    public final String formatSampleValue(long x, long y) {
        Raster tile;
        if (x < (long)this.minX || x >= (long)this.maxX || y < (long)this.minY || y >= (long)this.maxY) {
            return null;
        }
        int tileX = Math.toIntExact(Math.floorDiv(x - (long)this.tileGridXOffset, this.tileWidth));
        int tileY = Math.toIntExact(Math.floorDiv(y - (long)this.tileGridYOffset, this.tileHeight));
        GridTile cache = this.lastTile;
        if (cache == null || cache.tileX != tileX || cache.tileY != tileY) {
            GridTile key = new GridTile(tileX, tileY);
            cache = this.tiles.putIfAbsent(key, key);
            if (cache == null) {
                cache = key;
            }
            this.lastTile = cache;
        }
        if ((tile = cache.tile()) == null) {
            cache.load(this);
            return null;
        }
        return this.cellFormat.format(tile, (int)x, (int)y, this.getBand());
    }

    public final String formatCoordinateValue(long index) {
        return this.cellFormat.format(this.headerFormat, index);
    }

    public final Optional<StringProperty> cellFormatPattern() {
        return this.cellFormat.hasPattern() ? Optional.of(this.cellFormat) : Optional.empty();
    }

    final void hideCoordinates() {
        if (this.controls != null) {
            this.controls.status.handle((MouseEvent)null);
        }
    }

    protected final Skin<GridView> createDefaultSkin() {
        return new GridViewSkin(this);
    }

    private final class BandProperty
    extends IntegerPropertyBase {
        private BandProperty() {
        }

        public Object getBean() {
            return GridView.this;
        }

        public String getName() {
            return "band";
        }

        public void set(int band) {
            SampleModel sm;
            RenderedImage image = GridView.this.getImage();
            if (image != null && (sm = image.getSampleModel()) != null) {
                ArgumentChecks.ensureBetween((String)"band", (int)0, (int)(sm.getNumBands() - 1), (int)band);
                GridView.this.cellFormat.configure(image, band);
            } else {
                ArgumentChecks.ensurePositive((String)"band", (int)band);
            }
            super.set(band);
            GridView.this.updateCellValues();
        }

        final void setNoCheck(int bands) {
            super.set(Math.max(bands, 0));
        }
    }

    private final class ImageLoader
    extends Task<RenderedImage> {
        private final ImageRequest request;
        private GridCoverage coverage;

        ImageLoader(ImageRequest request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RenderedImage call() throws Exception {
            Long id = LogHandler.loadingStart((Resource)this.request.resource);
            try {
                this.coverage = this.request.load().forConvertedValues(true);
                if (this.isCancelled()) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                GridExtent slice = this.request.slice;
                GridControls c = GridView.this.controls;
                if (c != null) {
                    GridGeometry gg = this.coverage.getGridGeometry();
                    slice = BackgroundThreads.runAndWait(() -> {
                        GridExtent s = c.configureSliceSelector(gg);
                        int[] xydims = c.sliceSelector.getXYDimensions();
                        c.status.applyCanvasGeometry(gg, s, xydims[0], xydims[1]);
                        return s;
                    });
                }
                RenderedImage renderedImage = this.coverage.render(slice);
                return renderedImage;
            }
            finally {
                LogHandler.loadingStop(id);
            }
        }

        protected void succeeded() {
            GridView.this.setLoadedImage(this.request.resource, this.coverage, (RenderedImage)this.getValue());
        }

        protected void cancelled() {
            GridView.this.setLoadedImage(null, null, null);
        }

        protected void failed() {
            this.cancelled();
            ExceptionReporter.canNotReadFile((Node)GridView.this, (Resource)this.request.resource, this.getException());
        }
    }
}

