/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.util.Collections;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.NilReason;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.Role;
import org.opengis.util.CodeList;

final class MetadataFallback
extends MetadataSource {
    static final MetadataFallback INSTANCE = new MetadataFallback();

    private MetadataFallback() {
    }

    @Override
    public String search(Object metadata) {
        ArgumentChecks.ensureNonNull((String)"metadata", (Object)metadata);
        return null;
    }

    @Override
    public <T> T lookup(Class<T> type, String identifier) throws MetadataStoreException {
        Citation value;
        ArgumentChecks.ensureNonNull((String)"type", type);
        ArgumentChecks.ensureNonEmpty((String)"identifier", (CharSequence)identifier);
        if (CodeList.class.isAssignableFrom(type)) {
            try {
                value = MetadataFallback.getCodeList(type, identifier);
            }
            catch (IllegalArgumentException e) {
                throw new MetadataStoreException(Errors.format((short)33, type, (Object)identifier), e);
            }
        } else {
            value = null;
            if (type == Citation.class) {
                value = MetadataFallback.createCitation(identifier);
            }
            if (value == null) {
                return NilReason.MISSING.createNilObject(type);
            }
        }
        return type.cast(value);
    }

    static Citation createCitation(String key) {
        String title;
        String alternateTitle = null;
        String edition = null;
        String code = key;
        String codeSpace = null;
        String version = null;
        String citedResponsibleParty = null;
        PresentationForm presentationForm = null;
        String copyFrom = null;
        switch (key) {
            case "ISO 19115-1": {
                title = "Geographic Information \u2014 Metadata Part 1: Fundamentals";
                edition = "ISO 19115-1:2014";
                code = "19115-1";
                codeSpace = "ISO";
                version = "2014";
                citedResponsibleParty = "International Organization for Standardization";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "ISO 19115-2": {
                title = "Geographic Information \u2014 Metadata Part 2: Extensions for imagery and gridded data";
                edition = "ISO 19115-2:2019";
                code = "19115-2";
                codeSpace = "ISO";
                version = "2019";
                copyFrom = "ISO 19115-1";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "WMS": {
                title = "Web Map Server";
                alternateTitle = "WMS";
                version = "1.3";
                edition = "1.3";
                codeSpace = "OGC";
                copyFrom = "OGC";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "OGC": {
                title = "OGC Naming Authority";
                citedResponsibleParty = "Open Geospatial Consortium";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "WMO": {
                title = "WMO Information System (WIS)";
                citedResponsibleParty = "World Meteorological Organization";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "IOGP": {
                title = "IOGP Surveying and Positioning Guidance Note 7";
                copyFrom = "EPSG";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "EPSG": {
                title = "EPSG Geodetic Parameter Dataset";
                alternateTitle = "EPSG Dataset";
                codeSpace = "IOGP";
                citedResponsibleParty = "International Association of Oil & Gas producers";
                presentationForm = PresentationForm.TABLE_DIGITAL;
                break;
            }
            case "SIS": {
                title = "Apache Spatial Information System";
                codeSpace = "Apache";
                break;
            }
            case "ISBN": {
                title = "International Standard Book Number";
                alternateTitle = key;
                code = null;
                break;
            }
            case "ISSN": {
                title = "International Standard Serial Number";
                alternateTitle = key;
                code = null;
                break;
            }
            case "PROJ": {
                title = "PROJ coordinate transformation software library";
                codeSpace = "OSGeo";
                break;
            }
            case "GDAL": {
                title = "Geospatial Data Abstraction Library";
                alternateTitle = "GDAL";
                codeSpace = "OSGeo";
                break;
            }
            case "Unidata": {
                title = "Unidata netCDF library";
                code = null;
                break;
            }
            case "IHO S-57": {
                code = "S-57";
                title = "S-57";
                codeSpace = "IHO";
                version = "3.1";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            default: {
                return null;
            }
        }
        DefaultCitation c = new DefaultCitation(title);
        if (alternateTitle != null) {
            c.setAlternateTitles(Collections.singleton(Types.toInternationalString(alternateTitle)));
        }
        if (edition != null) {
            c.setEdition(Types.toInternationalString(edition));
        }
        if (code != null) {
            c.setIdentifiers(Collections.singleton(new DefaultIdentifier(codeSpace, code, version)));
        }
        if (presentationForm != null) {
            c.setPresentationForms(Collections.singleton(presentationForm));
        }
        if (citedResponsibleParty != null) {
            DefaultResponsibleParty r = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
            r.setParties(Collections.singleton(new DefaultOrganisation(citedResponsibleParty, null, null, null)));
            c.setCitedResponsibleParties(Collections.singleton(r));
        }
        if (copyFrom != null) {
            c.setCitedResponsibleParties(MetadataFallback.createCitation(copyFrom).getCitedResponsibleParties());
        }
        c.transitionTo(ModifiableMetadata.State.FINAL);
        return c;
    }

    @Override
    public void close() {
    }
}

