/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.internal.shared;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.metadata.sql.internal.shared.Dialect;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;

public class ScriptRunner
implements AutoCloseable {
    private static final String COMMENT = "--";
    private static final char QUOTE = '\'';
    private static final char IDENTIFIER_QUOTE = '\"';
    private static final char END_OF_STATEMENT = ';';
    private final Dialect dialect;
    private final Map<String, String> replacements;
    protected final String identifierQuote;
    protected final boolean isEnumTypeSupported;
    private final int maxRowsPerInsert;
    private final Statement statement;
    private Matcher statementsToSkip;
    private StringBuilder regexOfStmtToSkip;
    private String currentFile;
    private int currentLine;
    private String currentSQL;

    public ScriptRunner(Connection connection, String schemaToCreate, int maxRowsPerInsert) throws SQLException {
        ArgumentChecks.ensurePositive((String)"maxRowsPerInsert", (int)maxRowsPerInsert);
        this.maxRowsPerInsert = maxRowsPerInsert;
        this.replacements = new HashMap<String, String>();
        DatabaseMetaData metadata = connection.getMetaData();
        this.dialect = Dialect.guess(metadata);
        this.identifierQuote = metadata.getIdentifierQuoteString();
        if (schemaToCreate != null && metadata.supportsSchemasInTableDefinitions()) {
            try (Statement stmt = connection.createStatement();){
                stmt.executeUpdate("CREATE SCHEMA " + this.identifierQuote + schemaToCreate + this.identifierQuote);
                if (this.dialect.supportsGrantUsageOnSchema()) {
                    stmt.executeUpdate("GRANT USAGE ON SCHEMA " + this.identifierQuote + schemaToCreate + this.identifierQuote + " TO PUBLIC");
                }
            }
            connection.setSchema(schemaToCreate);
        }
        this.statement = connection.createStatement();
        switch (this.dialect) {
            default: {
                this.isEnumTypeSupported = false;
                break;
            }
            case POSTGRESQL: {
                int version = metadata.getDatabaseMajorVersion();
                this.isEnumTypeSupported = version == 8 ? metadata.getDatabaseMinorVersion() >= 4 : version >= 8;
                break;
            }
            case HSQL: {
                this.isEnumTypeSupported = false;
                this.statement.execute("SET DATABASE DEFAULT TABLE TYPE CACHED");
            }
        }
        if (!this.isEnumTypeSupported) {
            this.addStatementToSkip("CREATE\\s+(?:TYPE|CAST)\\s+.*");
        }
        if (!this.dialect.supportsAllGrants()) {
            this.addStatementToSkip("GRANT\\s+\\w+\\s+ON\\s+");
            if (this.dialect.supportsGrantUsageOnSchema()) {
                this.regexOfStmtToSkip.append("TABLE");
            } else if (this.dialect.supportsGrantSelectOnTable()) {
                this.regexOfStmtToSkip.append("SCHEMA");
            } else {
                this.regexOfStmtToSkip.append("(?:TABLE|SCHEMA)");
            }
            this.regexOfStmtToSkip.append("\\s+.*");
        }
        if (!this.dialect.supportsComment()) {
            this.addStatementToSkip("COMMENT\\s+ON\\s+.*");
        }
        if (!this.dialect.supportsAlterTableWithAddConstraint()) {
            this.addStatementToSkip("ALTER\\s+TABLE\\s+\\w+\\s+ADD\\s+CONSTRAINT\\s+.*");
        }
    }

    protected final Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    protected final void addStatementToSkip(String regex) {
        if (this.statementsToSkip != null) {
            throw new IllegalStateException();
        }
        if (this.regexOfStmtToSkip == null) {
            this.regexOfStmtToSkip = new StringBuilder(regex);
        } else {
            this.regexOfStmtToSkip.append('|').append(regex);
        }
    }

    protected final void addReplacement(String inScript, String replacement) {
        if (this.replacements.put(inScript, replacement) != null) {
            throw new IllegalArgumentException(inScript);
        }
    }

    protected final String getReplacement(String inScript) {
        return this.replacements.getOrDefault(inScript, inScript);
    }

    public final int run(String statement) throws IOException, SQLException {
        return this.run(null, new LineNumberReader(new StringReader(statement)));
    }

    public final int run(String filename, InputStream in) throws IOException, SQLException {
        if (in == null) {
            throw new FileNotFoundException(Errors.format((short)52, (Object)filename));
        }
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            int n = this.run(filename, reader);
            return n;
        }
    }

    public final int run(String filename, BufferedReader in) throws IOException, SQLException {
        String line;
        boolean hasReplacements;
        this.currentFile = filename;
        this.currentLine = 0;
        int statementCount = 0;
        int posOpeningTextQuote = -1;
        int posOpeningIdentifierQuote = -1;
        StringBuilder buffer = new StringBuilder();
        boolean bl = hasReplacements = !this.replacements.isEmpty();
        block5: while ((line = in.readLine()) != null) {
            ++this.currentLine;
            if (buffer.length() == 0) {
                int s = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)0, (int)line.length());
                if (s >= line.length() || line.startsWith(COMMENT, s)) continue;
                if (in instanceof LineNumberReader) {
                    this.currentLine = ((LineNumberReader)in).getLineNumber();
                }
            } else {
                buffer.append('\n');
            }
            int pos = buffer.length();
            int length = buffer.append(line).length();
            block6: while (pos < length) {
                int c = buffer.codePointAt(pos);
                int n = Character.charCount(c);
                if ((posOpeningTextQuote & posOpeningIdentifierQuote) < 0) {
                    int start = pos;
                    while (Character.isUnicodeIdentifierStart(c)) {
                        String word;
                        String replace;
                        while ((pos += n) < length) {
                            c = buffer.codePointAt(pos);
                            n = Character.charCount(c);
                            if (Character.isUnicodeIdentifierPart(c)) continue;
                        }
                        if (hasReplacements && (replace = this.replacements.get(word = buffer.substring(start, pos))) != null) {
                            length = buffer.replace(start, pos, replace).length();
                            pos = start + replace.length();
                        }
                        if (pos >= length) continue block5;
                        while (Character.isWhitespace(c)) {
                            if ((pos += n) >= length) continue block5;
                            c = buffer.codePointAt(pos);
                            n = Character.charCount(c);
                        }
                        start = pos;
                    }
                }
                switch (c) {
                    case 34: {
                        if (posOpeningTextQuote >= 0) break;
                        length = buffer.replace(pos, pos + n, this.identifierQuote).length();
                        n = this.identifierQuote.length();
                        if (posOpeningIdentifierQuote < 0) {
                            posOpeningIdentifierQuote = pos;
                            break;
                        }
                        this.editQuotedIdentifier(buffer, posOpeningIdentifierQuote, pos += n);
                        int n2 = length;
                        length = buffer.length();
                        pos -= n2 - length;
                        posOpeningIdentifierQuote = -1;
                        continue block6;
                    }
                    case 39: {
                        if (posOpeningIdentifierQuote >= 0) break;
                        if (posOpeningTextQuote < 0) {
                            posOpeningTextQuote = pos;
                            break;
                        }
                        if ((pos += n) < length && buffer.codePointAt(pos) == 39) break;
                        this.editText(buffer, posOpeningTextQuote, pos);
                        int n3 = length;
                        length = buffer.length();
                        pos -= n3 - length;
                        posOpeningTextQuote = -1;
                        continue block6;
                    }
                    case 59: {
                        if ((posOpeningTextQuote & posOpeningIdentifierQuote) >= 0) break;
                        if (CharSequences.skipLeadingWhitespaces((CharSequence)buffer, (int)(pos + n), (int)length) >= length) {
                            buffer.setLength(pos);
                        }
                        statementCount += this.execute(buffer);
                        buffer.setLength(0);
                        continue block5;
                    }
                }
                pos += n;
            }
        }
        line = buffer.toString().trim();
        if (!line.isEmpty() && !line.startsWith(COMMENT)) {
            throw new EOFException(Errors.format((short)169, (Object)line));
        }
        this.currentFile = null;
        return statementCount;
    }

    protected void editText(StringBuilder sql, int lower, int upper) {
    }

    protected void editQuotedIdentifier(StringBuilder sql, int lower, int upper) {
    }

    private static boolean isOutsideQuotes(CharSequence sql, int from, int to) {
        int nq = 0;
        int ni = 0;
        while (from < to) {
            switch (sql.charAt(from++)) {
                case '\"': {
                    ++ni;
                    break;
                }
                case '\'': {
                    if (nq & true && from < to && sql.charAt(from) == '\'') {
                        ++from;
                        break;
                    }
                    ++nq;
                }
            }
        }
        return !((nq | ni) & true);
    }

    protected boolean isSupported(CharSequence sql) {
        if (this.statementsToSkip != null) {
            return !this.statementsToSkip.reset(sql).matches();
        }
        if (this.regexOfStmtToSkip != null) {
            this.statementsToSkip = Pattern.compile(this.regexOfStmtToSkip.toString(), 32).matcher(sql);
            this.regexOfStmtToSkip = null;
            return !this.statementsToSkip.matches();
        }
        return true;
    }

    protected int execute(StringBuilder sql) throws SQLException, IOException {
        int s;
        if (!this.isSupported(sql)) {
            return 0;
        }
        String subSQL = this.currentSQL = CharSequences.trimWhitespaces((CharSequence)sql).toString();
        if (!this.dialect.supportsTableInheritance() && subSQL.startsWith("CREATE TABLE") && (s = sql.lastIndexOf("INHERITS")) >= 0 && ScriptRunner.isOutsideQuotes(sql, s + 8, sql.length())) {
            sql.setLength(CharSequences.skipTrailingWhitespaces((CharSequence)sql, (int)0, (int)s));
            subSQL = this.currentSQL = sql.toString();
        }
        int count = 0;
        if (subSQL.startsWith("SELECT ")) {
            this.statement.executeQuery(subSQL).close();
        } else {
            if (this.maxRowsPerInsert != Integer.MAX_VALUE && subSQL.startsWith("INSERT INTO")) {
                if (this.maxRowsPerInsert == 0) {
                    subSQL = null;
                } else {
                    int endOfLine = subSQL.indexOf(10, 11);
                    if (subSQL.startsWith("VALUES", endOfLine - 6)) {
                        int end;
                        sql.setLength(0);
                        int startOfValues = sql.append(subSQL, 0, endOfLine).append(' ').length();
                        int nrows = this.maxRowsPerInsert;
                        int begin = endOfLine + 1;
                        while (true) {
                            ++endOfLine;
                            if ((endOfLine = subSQL.indexOf(10, endOfLine)) < 0) break;
                            if (--nrows != 0) continue;
                            end = endOfLine;
                            if (subSQL.charAt(end - 1) == ',') {
                                --end;
                            }
                            this.currentSQL = sql.append(subSQL, begin, end).toString();
                            count += this.statement.executeUpdate(this.currentSQL);
                            sql.setLength(startOfValues);
                            nrows = this.maxRowsPerInsert;
                            begin = endOfLine + 1;
                        }
                        end = CharSequences.skipTrailingWhitespaces((CharSequence)subSQL, (int)begin, (int)subSQL.length());
                        subSQL = end > begin ? sql.append(subSQL, begin, end).toString() : null;
                        this.currentSQL = subSQL;
                    }
                }
            }
            if (subSQL != null) {
                count += this.statement.executeUpdate(subSQL);
            }
        }
        this.currentSQL = null;
        return count;
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    public String status(Locale locale) {
        String position = null;
        if (this.currentFile != null) {
            position = Errors.forLocale((Locale)locale).getString((short)48, (Object)this.currentFile, (Object)this.currentLine);
        }
        if (this.currentSQL != null) {
            StringBuilder buffer = new StringBuilder();
            if (position != null) {
                buffer.append(position).append('\n');
            }
            position = buffer.append("SQL: ").append(this.currentSQL).toString();
        }
        return position;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"status", this.status(null)});
    }
}

