/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.identification.CharacterSet;

final class LegacyCodes {
    static final Map<String, String> IANA_TO_LEGACY;
    static final Map<String, String> LEGACY_TO_IANA;

    private LegacyCodes() {
    }

    static String fromIANA(String name) {
        String legacy = IANA_TO_LEGACY.get(name);
        if (legacy == null && (legacy = IANA_TO_LEGACY.get(name.toUpperCase(Locale.US))) == null) {
            return name;
        }
        return legacy;
    }

    static String toIANA(String legacy) {
        String name = LEGACY_TO_IANA.get(legacy);
        if (name == null && (name = LEGACY_TO_IANA.get(legacy.toLowerCase(Locale.US))) == null) {
            return legacy;
        }
        return name;
    }

    static {
        CharacterSet[] codes = CharacterSet.values();
        int capacity = Containers.hashMapCapacity((int)codes.length);
        IANA_TO_LEGACY = new HashMap<String, String>(capacity);
        LEGACY_TO_IANA = new HashMap<String, String>(capacity);
        for (CharacterSet code : codes) {
            String legacy = code.identifier().intern();
            String[] names = code.names();
            String name = names[names.length - 1];
            if (name.equals("ebcdic")) {
                name = "EBCDIC";
            }
            IANA_TO_LEGACY.put(name.toUpperCase(Locale.US), legacy);
            LEGACY_TO_IANA.put(legacy.toLowerCase(Locale.US), name);
            IANA_TO_LEGACY.put(name, legacy);
            LEGACY_TO_IANA.put(legacy, name);
        }
    }
}

