/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.reader;

import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.base.Tags;
import org.apache.sis.storage.geotiff.reader.Type;
import org.apache.sis.temporal.LenientDateFormat;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.XML;
import org.apache.sis.xml.internal.shared.InputFactory;

public final class XMLMetadata
implements Filter {
    private static final String ITEM = "Item";
    private static final String NAME = "name";
    private byte[] bytes;
    private String string;
    private String currentElement;
    private final StoreListeners listeners;
    private final boolean isGDAL;
    private XMLMetadata next;

    XMLMetadata(String xml, boolean isGDAL) {
        this.isGDAL = isGDAL;
        this.string = xml;
        this.listeners = null;
    }

    public XMLMetadata(ChannelDataInput input, Charset encoding, StoreListeners listeners, Type type, long count, short tag) throws IOException {
        this.listeners = listeners;
        this.isGDAL = tag == -23424;
        block0 : switch (type) {
            case ASCII: {
                CharSequence[] cs = type.readAsStrings(input, count, encoding);
                switch (cs.length) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.string = cs[0];
                        break block0;
                    }
                }
                this.string = String.join((CharSequence)System.lineSeparator(), cs);
                break;
            }
            case BYTE: 
            case UBYTE: {
                this.bytes = ((ByteBuffer)type.readAsVector(input, count).buffer().get()).array();
            }
        }
    }

    final void appendTo(XMLMetadata head) {
        while (head.next != null) {
            head = head.next;
        }
        head.next = this;
    }

    String tag() {
        return Tags.name(this.isGDAL ? (short)-23424 : -14627);
    }

    public boolean isEmpty() {
        return this.bytes == null && this.string == null;
    }

    public String toString() {
        if (this.string == null) {
            if (this.bytes == null) {
                return null;
            }
            this.string = new String(this.bytes, StandardCharsets.UTF_8);
        }
        return this.string;
    }

    private XMLEventReader toXML() throws XMLStreamException {
        if (this.bytes != null) {
            return InputFactory.createXMLEventReader((InputStream)new ByteArrayInputStream(this.bytes));
        }
        if (this.string != null) {
            return InputFactory.createXMLEventReader((Reader)new StringReader(this.string));
        }
        return null;
    }

    private void append(XMLEventReader reader, StartElement element, TreeTable.Node node) throws XMLStreamException {
        String value;
        String previous = this.currentElement;
        this.currentElement = element.getName().getLocalPart();
        node.setValue(Root.NAME, (Object)this.currentElement);
        boolean isItem = this.isGDAL && this.currentElement.equals(ITEM);
        Iterator<Attribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!attribute.isSpecified()) continue;
            String name = attribute.getName().getLocalPart();
            String value2 = attribute.getValue();
            if (isItem && name.equals(NAME)) {
                node.setValue(Root.NAME, (Object)value2);
                continue;
            }
            TreeTable.Node child = node.newChild();
            child.setValue(Root.NAME, (Object)name);
            child.setValue(Root.VALUE, (Object)value2);
        }
        StringJoiner buffer = new StringJoiner("");
        while (reader.hasNext()) {
            Characters characters;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                this.append(reader, event.asStartElement(), node.newChild());
            }
            if (event.isCharacters() && !(characters = event.asCharacters()).isWhiteSpace()) {
                buffer.add(characters.getData());
            }
            if (!event.isEndElement()) continue;
            break;
        }
        if (!(value = buffer.toString()).isEmpty()) {
            node.setValue(Root.VALUE, (Object)value);
        }
        this.currentElement = previous;
    }

    public XMLMetadata appendTo(MetadataBuilder metadata) throws XMLStreamException, JAXBException {
        XMLEventReader reader = this.toXML();
        if (reader != null) {
            if (this.isGDAL) {
                Parser parser = new Parser(reader, metadata);
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    if (!event.isStartElement()) continue;
                    parser.root(event.asStartElement());
                }
                parser.flush();
            } else {
                metadata.mergeMetadata(XML.unmarshal((Source)new StAXSource(reader), Map.of("org.apache.sis.xml.warningFilter", this)), this.listeners != null ? this.listeners.getLocale() : null);
            }
            reader.close();
        }
        return this.next;
    }

    @Override
    public boolean isLoggable(LogRecord warning) {
        this.listeners.warning(warning);
        return false;
    }

    public static final class Root
    extends DefaultTreeTable.Node {
        private static final long serialVersionUID = -3656784393688796818L;
        private static final TableColumn<CharSequence> NAME = TableColumn.NAME;
        private static final TableColumn<Object> VALUE = TableColumn.VALUE;
        private final String xml;

        public Object getUserObject() {
            return this.xml;
        }

        public Root(XMLMetadata source, DefaultTreeTable.Node parent, String name) {
            super(parent);
            this.xml = source.toString();
            source.currentElement = name;
            this.setValue(NAME, name);
            try {
                XMLEventReader reader = source.toXML();
                if (reader != null) {
                    while (reader.hasNext()) {
                        XMLEvent event = reader.nextEvent();
                        if (!event.isStartElement()) continue;
                        source.append(reader, event.asStartElement(), (TreeTable.Node)this.newChild());
                    }
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                this.getChildren().clear();
                this.setValue(VALUE, this.xml);
                DefaultTreeTable.Node child = this.newChild();
                child.setValue(NAME, (Object)Errors.format((short)19, (Object)source.currentElement));
                child.setValue(VALUE, (Object)e);
            }
            source.currentElement = null;
        }
    }

    private static final class Parser {
        private final XMLEventReader reader;
        private final QName name;
        private int depth;
        private final MetadataBuilder metadata;
        private Instant startTime;
        private Instant endTime;

        Parser(XMLEventReader reader, MetadataBuilder metadata) {
            this.reader = reader;
            this.metadata = metadata;
            this.name = new QName(XMLMetadata.NAME);
        }

        void root(StartElement start) throws XMLStreamException {
            boolean parse = start.getName().getLocalPart().equals("GDALMetadata");
            while (this.reader.hasNext()) {
                XMLEvent event = this.reader.nextEvent();
                if (event.isStartElement()) {
                    if (parse) {
                        this.item(event.asStartElement());
                        continue;
                    }
                    this.root(event.asStartElement());
                    continue;
                }
                if (!event.isEndElement()) continue;
                break;
            }
        }

        private void item(StartElement start) throws XMLStreamException {
            XMLEvent event;
            Attribute a;
            String attribute = null;
            if (this.depth == 0 && start.getName().getLocalPart().equals(XMLMetadata.ITEM) && (a = start.getAttributeByName(this.name)) != null) {
                attribute = a.getValue();
            }
            StringJoiner buffer = new StringJoiner("");
            while (this.reader.hasNext() && !(event = this.reader.nextEvent()).isEndElement()) {
                if (event.isCharacters()) {
                    buffer.add(event.asCharacters().getData());
                    continue;
                }
                if (!event.isStartElement()) continue;
                ++this.depth;
                this.item(event.asStartElement());
                --this.depth;
            }
            if (attribute != null) {
                String content;
                if (Character.isUpperCase(attribute.codePointAt(0))) {
                    attribute = attribute.toLowerCase(Locale.US);
                }
                if (!(content = buffer.toString()).isEmpty()) {
                    switch (attribute) {
                        case "acquisitionStartDate": {
                            this.startTime = LenientDateFormat.parseInstantUTC((CharSequence)content);
                            break;
                        }
                        case "acquisitionEndDate": {
                            this.endTime = LenientDateFormat.parseInstantUTC((CharSequence)content);
                            break;
                        }
                        case "title": {
                            this.metadata.addTitle((CharSequence)content);
                        }
                    }
                }
            }
        }

        void flush() {
            this.metadata.addTemporalExtent((Temporal)this.startTime, (Temporal)this.endTime);
        }
    }
}

